/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.db.insight.model.ColumnInsightDataProvider;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DataTypeProvider;
import oracle.ide.db.insight.model.DeclarativeSQLQueryParentLocator;
import oracle.ide.db.insight.model.FunctionProvider;
import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.ide.db.insight.model.PlSqlInsightDataProvider;
import oracle.ide.db.insight.model.ReservedWordInsightDataProvider;
import oracle.ide.db.insight.model.SQLFromObjectProvider;
import oracle.ide.db.insight.model.SQLParentLocator;
import oracle.ide.db.insight.model.SchemaObjectInsightDataProvider;
import oracle.ide.db.insight.model.SchemaProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public final class DBInsightProvider {
    private final DBInsightContext m_insightContext;
    private final Class<? extends ParentLocator> m_parentLocatorClass;
    private final List<Class<? extends InsightDataProvider>> m_insightDataProviderClasses;
    private Map<String, DBInsightData> m_data;
    private Boolean m_makeLower;
    private String m_searchString;
    private int m_replacementStart;
    private int m_replacementEnd;
    private DBObjectProvider m_pro;
    private String m_text;
    private Schema m_schema;
    private Integer m_offset;
    private Class<? extends DBObject> m_targetObjectClass;
    private Class<? extends DBObject> m_parentScopeClass;
    private DBObject m_contextObjectAtOffset;
    private String m_language;
    private boolean m_userOnly;

    public DBInsightProvider(DBInsightContext insightContext) {
        this(insightContext, null, null);
    }

    public DBInsightProvider(DBInsightContext insightContext, Class<? extends ParentLocator> parentLocatorClass, List<Class<? extends InsightDataProvider>> insightDataProviderClasses) {
        if (insightContext == null) {
            throw new IllegalArgumentException("No context");
        }
        if (insightContext.getProvider() == null) {
            throw new IllegalArgumentException("No DBObjectProvider in the context");
        }
        if (insightContext.getText() == null) {
            throw new IllegalArgumentException("No text in the context");
        }
        this.m_insightContext = insightContext;
        this.m_parentLocatorClass = parentLocatorClass;
        this.m_insightDataProviderClasses = insightDataProviderClasses;
        if (!SwingUtilities.isEventDispatchThread()) {
            this.init();
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void init() {
        if (this.m_data == null) {
            this.m_data = new HashMap<String, DBInsightData>();
            this.m_pro = this.m_insightContext.getProvider();
            this.m_targetObjectClass = this.m_insightContext.getTargetObjectClass();
            this.m_parentScopeClass = this.m_insightContext.getParentScopeClass();
            this.m_language = this.m_insightContext.getLanguage();
            if (this.m_language == null) {
                this.m_language = "SQL";
            }
            this.m_userOnly = (userOnly = this.m_insightContext.getUserOnly()) == null ? this.m_pro instanceof Database : userOnly;
            this.m_searchString = "";
            if (this.m_insightContext.getSchema() != null) {
                this.m_schema = this.m_insightContext.getSchema();
            } else {
                s = null;
                try {
                    s = this.m_pro.getDefaultSchema();
                }
                catch (DBException e) {
                    s = null;
                }
                this.m_schema = s;
            }
            start = this.m_insightContext.getRangeStart();
            if (start == null) {
                start = 0;
            }
            if ((end = this.m_insightContext.getRangeEnd()) == null) {
                end = this.m_insightContext.getText().length();
            }
            this.m_text = this.m_insightContext.getText().substring(start, end);
            EOL = System.getProperty("line.separator");
            if (EOL.length() > 1 && this.m_text.contains(EOL)) {
                this.m_text = this.m_text.replace(EOL, "\n");
            }
            this.m_offset = (offset = this.m_insightContext.getSearchOffset()) == null ? end : offset;
            if (this.m_offset < start || this.m_offset > end) {
                throw new IllegalStateException("offset not within the specied range");
            }
            givenContextObject = this.m_insightContext.getContextObject();
            contextObjectAtOffset = givenContextObject;
            if (contextObjectAtOffset == null) {
                so = null;
                try {
                    schemaName = this.m_schema == null ? null : this.m_schema.getName();
                    pid = PlSqlIdentifier.getPlSqlIdentifier((String)this.m_text, (String)schemaName, (boolean)false);
                    if (pid != null && pid.getPlsqlType() != null) {
                        so = (PlSqlSourceObject)this.m_pro.getObjectFactory().newObject(Metadata.getInstance().getObjectClass(pid.getPlsqlType().toString()));
                        so.setSource(this.m_text);
                        so.setSchema(this.m_schema);
                    }
                }
                catch (Exception e) {
                    so = null;
                }
                contextObjectAtOffset = so;
            }
            tkLeftOfCursor = null;
            parentTk = null;
            if (contextObjectAtOffset instanceof PlSqlSourceObject) {
                contextPlSqlSourceObject = (PlSqlSourceObject)contextObjectAtOffset;
                plsInterrogator = PlSqlInterrogatorFactory.getInterrogator((SourceObject)contextPlSqlSourceObject);
                startTk = plsInterrogator.getTokenAtOffset(0);
            } else {
                contextPlSqlSourceObject = null;
                plsInterrogator = null;
                startTk = PlSqlTokenizer.tokenize((String)this.m_text, (String[])new String[0]);
            }
            if (startTk == null) {
                this.m_replacementStart = this.m_offset;
                this.m_replacementEnd = this.m_offset;
            } else {
                tkLeftOfCursor = startTk.getTokenAt(this.m_offset - start - 1);
                if (this.m_offset - start >= this.m_text.length()) {
                    prevCodeTok = startTk.getTokenAt(this.m_offset - start);
                    tkRightOfCursor = prevCodeTok.getNextToken();
                } else {
                    tkRightOfCursor = startTk.getTokenAt(this.m_offset - start);
                    prevCodeTok = tkRightOfCursor.getPrevCodeToken();
                }
                if (prevCodeTok.matches("%")) {
                    parentTk = prevCodeTok.getPrevCodeToken();
                    this.m_replacementStart = parentTk.getStart() + start;
                    this.m_replacementEnd = prevCodeTok.getEnd() + start + 1;
                    if (prevCodeTok.getNextToken().isCode(true)) {
                        this.m_replacementEnd = prevCodeTok.getNextToken().getEnd() + start + 1;
                    }
                } else if (tkLeftOfCursor.isWord()) {
                    this.m_replacementStart = tkLeftOfCursor.getStart() + start;
                    this.m_replacementEnd = tkLeftOfCursor.getEnd() + start + 1;
                    if (tkLeftOfCursor.getNextToken().matches("%")) {
                        this.m_replacementEnd = tkLeftOfCursor.getNextToken().getEnd() + start + 1;
                        if (tkLeftOfCursor.getNextToken().getNextToken().isCode(true)) {
                            this.m_replacementEnd = tkLeftOfCursor.getNextToken().getNextToken().getEnd() + start + 1;
                        }
                    }
                    this.m_searchString = (userString = this.m_text.substring(this.m_replacementStart - start, this.m_offset - start)).startsWith("\"") != false ? userString.substring(1) : this.m_pro.getInternalName(userString);
                    if (tkLeftOfCursor.getPrevCodeToken().matches(".")) {
                        parentTk = tkLeftOfCursor.getPrevCodeToken().getPrevCodeToken();
                    }
                } else {
                    if (tkRightOfCursor.isWord()) {
                        this.m_replacementStart = tkRightOfCursor.getStart() + start;
                        this.m_replacementEnd = tkRightOfCursor.getEnd() + start + 1;
                    } else {
                        this.m_replacementStart = this.m_offset;
                        this.m_replacementEnd = this.m_offset;
                    }
                    if (prevCodeTok.matches(".")) {
                        parentTk = prevCodeTok.getPrevCodeToken();
                    }
                }
            }
            if (tkLeftOfCursor != null) {
                tokType = tkLeftOfCursor.getType();
                if (tkLeftOfCursor.matches("..") || tokType == PlSqlToken.Type.MULTI_LINE_COMMENT || tokType == PlSqlToken.Type.SINGLE_LINE_COMMENT || tokType == PlSqlToken.Type.SINGLE_QUOTED_STRING) {
                    return;
                }
            }
            if (contextPlSqlSourceObject != null) {
                if (plsInterrogator.getRoot() == null || plsInterrogator.getRoot().getEndOffset() <= this.m_offset) {
                    return;
                }
                this.m_contextObjectAtOffset = ((DBObjectPlSqlFragment)contextPlSqlSourceObject).getChildAtOffset(this.m_offset.intValue());
                if (this.m_targetObjectClass == null) {
                    frag = plsInterrogator.getFragmentAtOffset(this.getOffset() - 1);
                    tk2 = tk = plsInterrogator.getTokenAtOffset(this.getOffset() - 1);
                    if (tk.getStart() > frag.getStartOffset() && tk.matches(".")) {
                        tk2 = tk.getPrevCodeToken();
                    }
                    while (tk2.getPrevCodeToken().matches(".") && tk2.getStart() >= frag.getStartOffset()) {
                        tk2 = tk2.getPrevCodeToken().getPrevCodeToken();
                    }
                    tk = tk2;
                    if (frag.getFragmentType() == PlSqlFragment.Type.PARAMETER && tk != frag.getFirstToken()) {
                        this.m_targetObjectClass = DataType.class;
                    } else if (frag.getFragmentType() == PlSqlFragment.Type.DECLARATION && tk != frag.getFirstToken()) {
                        this.m_targetObjectClass = DataTypeUsage.class;
                    } else if (frag.getFragmentType() == PlSqlFragment.Type.STATEMENT && tk != frag.getFirstToken()) {
                        this.m_targetObjectClass = DBObject.class;
                        intoSearch = new PlSqlSearch("{SELECT|WITH} {^INTO}... <into INTO>");
                        if (intoSearch.matches(frag.getFirstToken(), frag.getLastToken()) && intoSearch.getNamedMatchStartToken("into").getStart() <= this.m_offset) {
                            fromSearch = new PlSqlSearch("{SELECT|WITH} {^FROM}... <from FROM>");
                            if (fromSearch.matches(frag.getFirstToken(), frag.getLastToken())) {
                                if (fromSearch.getNamedMatchEndToken("from").getEnd() >= this.m_offset) {
                                    this.m_targetObjectClass = PlSqlDatum.class;
                                }
                            } else {
                                this.m_targetObjectClass = PlSqlDatum.class;
                            }
                        }
                    }
                }
            } else if (contextObjectAtOffset != null) {
                this.m_contextObjectAtOffset = contextObjectAtOffset;
            } else if (givenContextObject != null) {
                this.m_contextObjectAtOffset = givenContextObject;
            } else if (this.m_schema != null) {
                this.m_contextObjectAtOffset = this.m_schema;
            } else {
                DBLog.getLogger((Object)this).fine("Unable to identify a valid value for m_contextObjectAtOffset");
            }
            if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.LOWER) {
                this.m_makeLower = Boolean.TRUE;
            } else if (this.m_insightContext.getCasePolicy() == DBInsightContext.CasePolicy.UPPER || tkLeftOfCursor == null) {
                this.m_makeLower = Boolean.FALSE;
            } else {
                tk = tkLeftOfCursor;
                while (!tk.isEndMarker() && !tk.isCode(true)) {
                    tk = tk.getPrevCodeToken();
                }
                test = tk.isEndMarker() != false ? "X" : tk.getSource();
                this.m_makeLower = test.equals(test.toLowerCase());
            }
            insightProviders = new ArrayList<InsightDataProvider>();
            if (this.m_insightDataProviderClasses == null) {
                insightProviders.add(new ColumnInsightDataProvider());
                insightProviders.add(new SchemaProvider());
                if (!(this.m_contextObjectAtOffset instanceof SQLQuery) || this.m_targetObjectClass == FromObject.class) {
                    insightProviders.add(new SchemaObjectInsightDataProvider());
                }
                if (this.m_contextObjectAtOffset instanceof DBObjectPlSqlFragment) {
                    insightProviders.add(new PlSqlInsightDataProvider());
                }
                if (this.m_targetObjectClass != null && (DataType.class.isAssignableFrom(this.m_targetObjectClass) || DataTypeUsage.class.isAssignableFrom(this.m_targetObjectClass))) {
                    insightProviders.add(new DataTypeProvider());
                } else {
                    insightProviders.add(new FunctionProvider());
                    insightProviders.add(new SQLFromObjectProvider());
                }
                if (this.m_insightContext.isIncludeReservedWords()) {
                    insightProviders.add(new ReservedWordInsightDataProvider());
                }
            } else {
                for (Class<? extends InsightDataProvider> clz : this.m_insightDataProviderClasses) {
                    try {
                        insightProviders.add(clz.newInstance());
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).severe("Failed to instantiate insightDataProvider: " + e.getMessage());
                    }
                }
            }
            for (InsightDataProvider aidp : insightProviders) {
                aidp.setDBInsightProvider(this);
            }
            if (this.m_parentLocatorClass == null) {
                parentLocator = givenContextObject instanceof SQLQuery && ((SQLQuery)givenContextObject).isDeclarative() ? new DeclarativeSQLQueryParentLocator() : (givenContextObject instanceof SQLQuery || givenContextObject instanceof SQLQueryOwner || givenContextObject instanceof PlSqlSourceObject || givenContextObject == null ? new SQLParentLocator() : new ParentLocator());
            } else {
                loc = null;
                try {
                    loc = this.m_parentLocatorClass.newInstance();
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).severe("Failed to instantiate parentLocator: " + e.getMessage());
                }
                if (loc == null) {
                    loc = new ParentLocator();
                }
                parentLocator = loc;
            }
            parentLocator.setDBInsightProvider(this);
            top = this.m_contextObjectAtOffset == null ? null : DBUtil.getUppermostParent((DBObject)this.m_contextObjectAtOffset);
            parentNames = new ArrayList<String>();
            while (parentTk != null && parentTk.isCode()) {
                parentNames.add(0, this.m_pro.getInternalName(parentTk.getSource()));
                if (parentTk.getPrevCodeToken().matches(".") && parentTk.getPrevCodeToken().getPrevCodeToken().isCode(true)) {
                    parentTk = parentTk.getPrevCodeToken().getPrevCodeToken();
                    continue;
                }
                if (parentTk.getPrevCodeToken().matches(":") && parentNames.size() == 1 && top instanceof Trigger) {
                    trigger = (Trigger)top;
                    refAsses = new ArrayList<String>();
                    newAs = trigger.getReferencingNewAs();
                    if (newAs == null) {
                        newAs = "NEW";
                    }
                    refAsses.add(newAs);
                    oldAs = trigger.getReferencingOldAs();
                    if (oldAs == null) {
                        oldAs = "OLD";
                    }
                    refAsses.add(oldAs);
                    if (refAsses.contains(parentNames.get(0)) && (id = trigger.getBaseObjectID()) != null) {
                        parentNames.clear();
                        schemaName = DBUtil.getSchemaName((DBObjectID)id);
                        if (schemaName != null) {
                            parentNames.add(schemaName);
                        }
                        if ((name = DBUtil.getDBObjectName((DBObjectID)id)) != null) {
                            parentNames.add(name);
                        }
                    }
                }
                parentTk = null;
            }
            context = null;
            if (parentNames.size() > 0 && (context = parentLocator.getParent(parentNames)) == null) {
                return;
            }
            if (context instanceof Synonym) {
                context = DBUtil.getSynonymReference((Synonym)((Synonym)context));
            }
            v0 = parentContextSet = context != null;
            if (context == null) {
                context = this.m_contextObjectAtOffset;
            }
            while (true) lbl-1000:
            // 5 sources

            {
                for (InsightDataProvider p : insightProviders) {
                    p.addItems(context);
                }
                if (parentContextSet || context == null || this.m_parentScopeClass != null && this.m_parentScopeClass.isAssignableFrom(context.getClass())) break;
                if (context instanceof Index && ((Index)context).getTable() != null) {
                    context = ((Index)context).getTable();
                    ** continue;
                }
                if (context instanceof SchemaObject) {
                    context = ((SchemaObject)context).getSchema();
                    ** continue;
                }
                context = context.getParent();
            }
        }
    }

    public String getMatchingText() {
        this.init();
        return this.m_searchString;
    }

    public List<DBInsightData> getInsightData() {
        this.init();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.m_data.keySet());
        Collections.sort(keys);
        ArrayList<DBInsightData> ret = new ArrayList<DBInsightData>();
        for (String key : keys) {
            ret.add(this.m_data.get(key));
        }
        return ret;
    }

    final DBObjectProvider getProvider() {
        this.init();
        return this.m_pro;
    }

    final Schema getSchema() {
        this.init();
        return this.m_schema;
    }

    final String getText() {
        this.init();
        return this.m_text;
    }

    final Integer getOffset() {
        this.init();
        return this.m_offset;
    }

    final DBObject getContextObjectAtOffset() {
        this.init();
        return this.m_contextObjectAtOffset;
    }

    final DBInsightContext.FilterMode getFilterMode() {
        return this.m_insightContext.getFilterMode();
    }

    final Class<? extends DBObject> getTargetObjectClass() {
        this.init();
        return this.m_targetObjectClass;
    }

    final Class<? extends DBObject> getParentScopeClass() {
        this.init();
        return this.m_parentScopeClass;
    }

    final DBInsightContext getInsightContext() {
        this.init();
        return this.m_insightContext;
    }

    final Class<? extends ParentLocator> getParentLocatorClass() {
        this.init();
        return this.m_parentLocatorClass;
    }

    final List<Class<? extends InsightDataProvider>> getInsightDataProviderClasses() {
        this.init();
        return this.m_insightDataProviderClasses;
    }

    final Boolean getMakeLower() {
        this.init();
        return this.m_makeLower;
    }

    final int getReplacementStart() {
        this.init();
        return this.m_replacementStart;
    }

    final int getReplacementEnd() {
        this.init();
        return this.m_replacementEnd;
    }

    final String getLanguage() {
        this.init();
        return this.m_language;
    }

    final boolean isUserOnly() {
        this.init();
        return this.m_userOnly;
    }

    final void addItem(DBInsightData item) {
        this.init();
        String key = item.getName();
        if (!this.m_data.containsKey(key)) {
            this.m_data.put(key, item);
        }
    }
}

