/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.List;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

class DeclarativeSQLQueryParentLocator
extends ParentLocator {
    DeclarativeSQLQueryParentLocator() {
    }

    @Override
    protected DBObject getParent(List<String> names) {
        if (names.size() == 1) {
            SQLQuery query;
            String alias = names.get(0);
            if (this.getContextObjectAtOffset() instanceof SQLQuery && (query = (SQLQuery)this.getContextObjectAtOffset()).isDeclarative()) {
                for (FromObject fo : query.getFromObjects()) {
                    SQLFragment sf;
                    String foAlias = fo.getAlias();
                    if (foAlias != null) {
                        foAlias = this.getProvider().getInternalName(foAlias);
                    }
                    if (!ModelUtil.areEqual((Object)alias, (Object)foAlias) || !((sf = fo.getExpression()) instanceof AbstractSchemaObjectUsage)) continue;
                    AbstractSchemaObjectUsage sou = (AbstractSchemaObjectUsage)sf;
                    DBObjectID id = sou.getObjectID();
                    try {
                        DBObject obj = id.resolveID();
                        if (!(obj instanceof SchemaObject)) continue;
                        SchemaObject so = (SchemaObject)obj;
                        names.clear();
                        names.add(this.getProvider().getInternalName(so.getSchema().getName()));
                        names.add(this.getProvider().getInternalName(so.getName()));
                        break;
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
        }
        return super.getParent(names);
    }
}

