/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.icons.OracleIcons;

public abstract class InsightDataProvider {
    protected DBInsightProvider m_DBInsightProvider = null;

    public abstract void addItems(DBObject var1);

    protected final void setDBInsightProvider(DBInsightProvider insightProvider) {
        this.m_DBInsightProvider = insightProvider;
    }

    protected final DBInsightContext.FilterMode getFilterMode() {
        return this.m_DBInsightProvider.getFilterMode();
    }

    protected final String getSearchString() {
        return this.m_DBInsightProvider.getMatchingText();
    }

    protected final DBObjectProvider getProvider() {
        return this.m_DBInsightProvider.getProvider();
    }

    protected final DBObject getContextObjectAtOffset() {
        return this.m_DBInsightProvider.getContextObjectAtOffset();
    }

    protected final Class<? extends DBObject> getParentScopeClass() {
        return this.m_DBInsightProvider.getParentScopeClass();
    }

    protected final Integer getOffset() {
        return this.m_DBInsightProvider.getOffset();
    }

    protected final boolean isTopLevel(DBObject parent) {
        Class<? extends DBObject> parentScope = this.getParentScopeClass();
        return parent == null || parentScope != null && parentScope.isAssignableFrom(parent.getClass());
    }

    protected final void addDBObject(DBObject obj) {
        if (this.isTargetClassOrPossibleParent(obj.getClass()) && obj != null && obj.getName() != null) {
            String name = obj.getName();
            if (obj instanceof FromObject) {
                name = this.getProvider().getInternalName(name);
            }
            if (this.accept(name)) {
                if (obj instanceof PlSqlSubProgram) {
                    PlSqlSubProgram sub = (PlSqlSubProgram)obj;
                    String type = sub.getReturnTypeID() == null ? "PROCEDURE" : "FUNCTION";
                    Icon icon = DBTypeDisplayRegistry.getNodeIcon(type);
                    String desc = DBTypeDisplayRegistry.getSingularDisplayName(type);
                    String display = this.getSubProgramDisplayValue(sub, this.getProvider());
                    DBInsightData item = new DBInsightData(display, desc, icon, true, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd());
                    this.m_DBInsightProvider.addItem(item);
                } else {
                    String display = this.getProvider().getExternalName(name);
                    String desc = DBTypeDisplayRegistry.getSingularDisplayName(obj.getType());
                    Icon icon = DBTypeDisplayRegistry.getNodeIcon(obj.getType());
                    display = this.correctCase(display);
                    DBInsightData item = new DBInsightData(display, desc, icon, true, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd());
                    this.m_DBInsightProvider.addItem(item);
                }
            }
        }
    }

    protected final void addReservedWord(String reservedWord) {
        this.addWords(this.m_DBInsightProvider.getLanguage(), null, reservedWord);
    }

    protected final void addExpression(String desc, Icon icon, String expression) {
        PlSqlToken tk = PlSqlTokenizer.tokenize((String)expression, (String[])new String[0]);
        ArrayList<String> words = new ArrayList<String>();
        while (!tk.isEndMarker()) {
            words.add(tk.getSource());
            tk = tk.getNextToken();
        }
        this.addWords(desc, icon, words.toArray(new String[words.size()]));
    }

    protected final void addWords(String desc, Icon icon, String ... words) {
        if (this.accept(words[0])) {
            StringBuilder sb = new StringBuilder();
            for (String word : words) {
                sb.append(this.correctCase(word));
            }
            if (icon == null) {
                icon = OracleIcons.getIcon((String)"spacer.png");
            }
            DBInsightData item = new DBInsightData(sb.toString(), desc, icon, false, this.m_DBInsightProvider.getReplacementStart(), this.m_DBInsightProvider.getReplacementEnd());
            this.m_DBInsightProvider.addItem(item);
        }
    }

    protected final boolean isTargetClass(Class clz, boolean strict) {
        Class<? extends DBObject> targetClz = this.m_DBInsightProvider.getTargetObjectClass();
        if (strict) {
            return targetClz == clz;
        }
        return targetClz == null || clz != null && targetClz.isAssignableFrom(clz);
    }

    protected final boolean isTargetClassOrPossibleParent(Class clz) {
        HashSet<Class> done = new HashSet<Class>();
        return this.isTargetClassOrPossibleParent(clz, done);
    }

    private boolean isTargetClassOrPossibleParent(Class clz, Set<Class> done) {
        if (this.isTargetClass(clz, false)) {
            return true;
        }
        if (clz == Schema.class) {
            return true;
        }
        if (DBObject.class.isAssignableFrom(clz) && !done.contains(clz)) {
            done.add(clz);
            for (String propName : Metadata.getInstance().getSupportedProperties(clz, null)) {
                PropertyInfo pinf;
                if ("parent".equals(propName) || "schema".equals(propName) || (pinf = PropertyHelper.findPropertyInfo((Class)clz, (String)propName, (DBObjectProvider)this.getProvider())) == null || !this.isTargetClassOrPossibleParent(pinf.getPropertyClass(), done)) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean accept(String name) {
        DBInsightContext.FilterMode filterMode = this.m_DBInsightProvider.getFilterMode();
        if (name == null) {
            return false;
        }
        if (filterMode == null) {
            return true;
        }
        if (filterMode == DBInsightContext.FilterMode.STARTS_WITH && name.startsWith(this.getSearchString())) {
            return true;
        }
        return filterMode == DBInsightContext.FilterMode.CONTAINS && name.contains(this.getSearchString());
    }

    protected final SchemaObject[] getMatchingSchemaItems(Schema schema, String ... types) {
        StringBuilder sb = new StringBuilder();
        if (this.getFilterMode() == DBInsightContext.FilterMode.CONTAINS) {
            sb.append("%");
        }
        if (this.getFilterMode() != null) {
            sb.append(this.getSearchString());
        }
        sb.append("%");
        String search = sb.toString();
        try {
            return this.getProvider().listObjects(types, schema, search);
        }
        catch (DBException e) {
            return new SchemaObject[0];
        }
    }

    protected final String getSubProgramDisplayValue(PlSqlSubProgram sub, DBObjectProvider pro) {
        StringBuilder sb = new StringBuilder();
        String subName = sub.getName();
        if (subName.contains("(")) {
            subName = subName.substring(0, subName.indexOf("("));
        }
        sb.append(this.correctCase(pro.getExternalName(subName)));
        String sep = "(";
        for (PlSqlParameter p : sub.getParameters()) {
            if (p.getDefaultValue() != null) continue;
            sb.append(sep);
            sep = ",";
        }
        if (sep.equals(",")) {
            sb.append(")");
        }
        String ret = sb.toString();
        return ret;
    }

    protected final String correctCase(String s) {
        if (s == null || s.startsWith("\"")) {
            return s;
        }
        if (this.m_DBInsightProvider.getMakeLower().booleanValue()) {
            return s.toLowerCase();
        }
        return s.toUpperCase();
    }
}

