/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import oracle.ide.db.insight.model.DataTypeProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.PropertyBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class PlSqlInsightDataProvider
extends DataTypeProvider {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addItems(DBObject context) {
        DataTypeUsage dtu;
        PlSqlDatum datum;
        PlSqlReference ref;
        if (context instanceof PlSqlBlock) {
            PlSqlBlock block = (PlSqlBlock)context;
            for (PlSqlSubProgram plSqlSubProgram : block.getSubPrograms()) {
                PlSqlReference ref2 = plSqlSubProgram.getReturnTypeReference();
                if (this.isTargetClass(DBObject.class, true) && ref2 == null) continue;
                this.addDBObject((DBObject)plSqlSubProgram);
            }
            for (PlSqlSubProgram plSqlSubProgram : block.getVariables()) {
                this.addDBObject((DBObject)plSqlSubProgram);
            }
            if (this.isTargetClass(DataType.class, true) || this.isTargetClass(DataTypeUsage.class, true)) {
                for (PlSqlSubProgram plSqlSubProgram : block.getDatatypes()) {
                    this.addDBObject((DBObject)plSqlSubProgram);
                }
            }
        }
        if (context instanceof PlSqlSubProgram) {
            PlSqlSubProgram sub = (PlSqlSubProgram)context;
            for (PlSqlSubProgram plSqlSubProgram : sub.getParameters()) {
                this.addDBObject((DBObject)plSqlSubProgram);
            }
        }
        if (context instanceof PlSqlDatum && (ref = (datum = (PlSqlDatum)context).getDataTypeReference()) != null && (dtu = ref.getDataTypeUsage()) != null) {
            void var6_19;
            DBObjectID dtID = dtu.getDataTypeID();
            Object var6_17 = null;
            try {
                DBObject dBObject = dtID.resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (var6_19 instanceof Type) {
                Type type = (Type)var6_19;
                this.addItems((DBObject)type);
                if (ModelUtil.hasLength((String)type.getCollectionType())) {
                    this.addReservedWord("COUNT");
                    this.addReservedWord("DELETE");
                    this.addReservedWord("DELETE()");
                    this.addReservedWord("DELETE(,)");
                    this.addReservedWord("EXISTS()");
                    this.addReservedWord("EXTEND");
                    this.addReservedWord("EXTEND()");
                    this.addReservedWord("EXTEND(,)");
                    this.addReservedWord("DELETE");
                    this.addReservedWord("FIRST");
                    this.addReservedWord("LAST");
                    this.addReservedWord("LIMIT");
                    this.addReservedWord("NEXT()");
                    this.addReservedWord("PRIOR()");
                    this.addReservedWord("TRIM");
                    this.addReservedWord("TRIM()");
                }
            }
        }
        if (context instanceof Sequence) {
            this.addReservedWord("NEXTVAL");
            this.addReservedWord("CURRVAL");
        }
        if (context instanceof Schema && this.isTargetClass(null, true)) {
            Schema schema = (Schema)context;
            for (PlSqlSubProgram plSqlSubProgram : this.getMatchingSchemaItems(schema, "PROCEDURE")) {
                this.addDBObject((DBObject)plSqlSubProgram);
            }
        }
        if (this.addDataTypes(context) || this.addDataTypeUsages(context)) {
            super.addItems(context);
            this.addPlSqlDataTypes("BINARY_INTEGER", "BOOLEAN", "NATURAL", "NATURALN", "PLS_INTEGER", "POSITIVE", "POSITIVEN", "RECORD", "REF", "REF CURSOR", "SIGNTYPE", "SMALLINT", "STRING", "TABLE", "VARRAY");
        }
        if (this.isTargetClass(DataType.class, true) || this.isTargetClass(DataTypeUsage.class, true)) {
            SchemaObject[] sos = new SchemaObject[]{};
            if (context instanceof Schema) {
                Schema schema = (Schema)context;
                sos = this.getMatchingSchemaItems(schema, "TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM");
            } else if (context instanceof Relation) {
                sos = new SchemaObject[]{(Relation)context};
            } else if (context instanceof Column || context instanceof PlSqlDatum) {
                this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(context.getName()), "%", "TYPE");
            }
            for (PlSqlSubProgram plSqlSubProgram : sos) {
                Relation rel = null;
                if (plSqlSubProgram instanceof Synonym) {
                    SchemaObject soref = DBUtil.getSynonymReference((Synonym)((Synonym)plSqlSubProgram));
                    if (soref instanceof Relation) {
                        rel = (Relation)soref;
                    }
                } else if (plSqlSubProgram instanceof Relation) {
                    rel = (Relation)plSqlSubProgram;
                }
                if (rel == null) continue;
                for (Column c : rel.getColumns()) {
                    if (context instanceof Schema) {
                        this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(rel.getName()), ".", this.getProvider().getExternalName(c.getName()), "%", "TYPE");
                        continue;
                    }
                    this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(c.getName()), "%", "TYPE");
                }
                this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), this.getProvider().getExternalName(rel.getName()), "%", "ROWTYPE");
            }
        }
    }

    private void addPlSqlDataTypes(String ... datatypes) {
        for (String datatype : datatypes) {
            this.addWords(PropertyBundle.get((String)"datatype"), OracleIcons.getIcon((String)"domain.png"), datatype);
        }
    }
}

