/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.sql.SqlAliasExpander;

class SQLParentLocator
extends ParentLocator {
    SQLParentLocator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DBObject getParent(List<String> names) {
        PlSqlToken tkEnd;
        PlSqlToken tkStart;
        DBObject context;
        DBObjectProvider pro;
        ArrayList<String> namesCopy;
        block23: {
            block21: {
                PlSqlFragment frag;
                block24: {
                    block22: {
                        namesCopy = new ArrayList<String>();
                        namesCopy.addAll(names);
                        pro = this.getProvider();
                        context = this.getContextObjectAtOffset();
                        tkStart = null;
                        tkEnd = null;
                        if (!(context instanceof DBObjectPlSqlFragment)) break block21;
                        PlSqlSourceObject so = (PlSqlSourceObject)DBUtil.getUppermostParent((DBObject)context);
                        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                        frag = pi.getFragmentAtOffset(this.getOffset());
                        if (frag.getFragmentType() != PlSqlFragment.Type.STATEMENT) break block22;
                        if (this.isSQL(frag.getFirstToken())) {
                            tkStart = frag.getFirstToken();
                            tkEnd = frag.getLastToken();
                        }
                        break block23;
                    }
                    if (frag.getFragmentType() != PlSqlFragment.Type.FOR_LOOP) break block24;
                    PlSqlSearch search = new PlSqlSearch("for ? in <sel (...)> loop");
                    if (search.matches(frag.getFirstToken())) {
                        tkStart = search.getNamedMatchStartToken("sel").getNextCodeToken();
                        tkEnd = search.getNamedMatchEndToken("sel").getPrevCodeToken();
                    }
                    break block23;
                }
                if (frag.getFragmentType() == PlSqlFragment.Type.CURSOR) break block23;
                break block23;
            }
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)this.getText(), (String[])new String[0]);
            if (!tk.isCode()) {
                tk = tk.getNextCodeToken();
            }
            if (this.isSQL(tk)) {
                tkStart = tk;
                tkEnd = tk;
                while (!tkEnd.getNextToken().isEndMarker()) {
                    tkEnd = tkEnd.getNextToken();
                }
            }
        }
        if (tkStart != null) {
            SqlAliasExpander ex = pro.getDescriptor().getSqlAliasExpander(pro, this.getSchema());
            boolean done = false;
            try {
                Collection usages = ex.getUsages(tkStart, tkEnd);
                done = this.updateParents(namesCopy, usages, this.getOffset() - 1, this.getSearchString());
            }
            catch (IllegalArgumentException iae) {
                done = true;
            }
            if (!done) {
                int insertPos = this.getOffset() - tkStart.getStart();
                String dummyCol = "X";
                if (this.getSearchString().length() == 0 && insertPos != 0) {
                    StringBuilder sb = new StringBuilder(tkStart.getSource(false, tkEnd));
                    if (insertPos < sb.length()) {
                        sb.insert(insertPos, "X");
                    } else {
                        sb.append("X");
                    }
                    try {
                        Collection usages2 = ex.getUsages(sb.toString());
                        this.updateParents(namesCopy, usages2, insertPos, "X");
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                }
            }
        }
        if (namesCopy.size() > 0) {
            List refs = PlSqlUtil.findReferences(namesCopy, (DBObjectProvider)this.getProvider(), (DBObject)context);
            DBObject bestObj = null;
            for (DBObjectID refId : refs) {
                DBObject obj;
                try {
                    obj = refId.resolveID();
                }
                catch (DBException e) {
                    obj = null;
                }
                if (obj == null) continue;
                if (bestObj == null) {
                    bestObj = obj;
                    continue;
                }
                if (bestObj instanceof PlSqlDatum && !(obj instanceof PlSqlDatum)) {
                    bestObj = obj;
                    continue;
                }
                if (!(bestObj instanceof PlSqlDatum) || bestObj instanceof PlSqlAttribute || !(obj instanceof PlSqlAttribute)) continue;
                bestObj = obj;
            }
            if (bestObj != null) {
                return bestObj;
            }
        }
        return super.getParent(names);
    }

    private boolean isSQL(PlSqlToken token) {
        return token.matches("select") || token.matches("with") || token.matches("insert") || token.matches("update") || token.matches("delete");
    }

    private boolean updateParents(List<String> names, Collection<SqlAliasExpander.Usage> usages, int pos, String match) {
        for (SqlAliasExpander.Usage usage : usages) {
            if (usage.getStartOffset() > pos || usage.getEndOffset() < pos || !((String)usage.getTokens().get(usage.getTokens().size() - 1)).startsWith(match)) continue;
            names.clear();
            for (int i = 0; i < usage.getTokens().size() - 1; ++i) {
                names.add(this.getProvider().getInternalName((String)usage.getTokens().get(i)));
            }
            return true;
        }
        return false;
    }
}

