/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectNode
extends Node
implements DBObjectNode {
    private DBObjectID m_id;

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    public DBObject getDBObject() {
        DBObject retval = null;
        if (this.m_id != null) {
            try {
                retval = this.m_id.resolveID();
                if (retval != null && ModelUtil.areDifferent((Object)retval.getName(), (Object)this.getObjectName())) {
                    retval = null;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (retval == null && (retval = BaseDBObjectNode.findDBObject(this)) != null) {
            this.m_id = retval.getID();
        }
        return retval;
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    @Override
    public void init(DBObject obj, DBObjectProvider pro) {
    }

    static DBObject findDBObject(DBObjectNode node) {
        SystemObject retval = null;
        try {
            DBObjectProvider pro = node.getProvider();
            if (pro != null) {
                Schema s = DBObjectNodeUtil.getSchema(node, true);
                String objectType = DBObjectNodeUtil.normalizeType(node);
                String objectName = node.getObjectName();
                if (pro.supportsObjectType(objectType)) {
                    DBObjectCriteria crit = DBObjectCriteria.createSingleObjectCriteria((String)objectType, (Schema)s, (String)objectName);
                    retval = pro.getObject(crit);
                }
            }
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not retrieve object for node {0}: {1}", new Object[]{node.getURL(), dbe.getMessage()});
        }
        return retval;
    }

    static DBObjectProvider findProvider(DBObjectNode node) {
        try {
            return DBObjectProviderFactory.findOrCreateProvider((String)node.getProviderType(), (Object)node.getProviderIdentifier());
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not retrieve provider for node {0}: {1}", new Object[]{node.getURL(), dbe.getMessage()});
            return null;
        }
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(DBObjectNodeUtil.normalizeType(this));
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String name = this.getObjectName();
        if (ModelUtil.hasLength((String)name)) {
            return name;
        }
        return super.getShortLabel();
    }
}

