/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.model;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.model.BaseDBObjectNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class BaseDBObjectTextNode
extends TextNode
implements DBObjectNode {
    private final Lock m_lock = new ReentrantLock();
    private SourceObject m_objectBeingBuilt;
    private SourceObject m_builtObject;
    private SourceObject m_tempObject;
    private int m_lastChangeId;
    private String m_lastSource;
    private boolean m_builtSinceLastChange = false;

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    public DBObject getDBObject() {
        return this.findProviderDBObject();
    }

    @Override
    public DBObjectProvider getProvider() {
        return BaseDBObjectNode.findProvider(this);
    }

    public Icon getIcon() {
        Icon icon = DBTypeDisplayRegistry.getNodeIcon(DBObjectNodeUtil.normalizeType(this));
        if (icon != null) {
            return icon;
        }
        return super.getIcon();
    }

    public String getShortLabel() {
        String name = this.getObjectName();
        if (ModelUtil.hasLength((String)name)) {
            return name;
        }
        return super.getShortLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SourceObject getDBObject(boolean fullyBuilt) {
        if (fullyBuilt && SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Calling getDBObject(true) on EDT");
        }
        DBObjectProvider pro = this.getProvider();
        String type = this.getObjectType();
        SourceObject ret = null;
        while (true) {
            boolean locked = false;
            try {
                locked = this.m_lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (locked) {
                    SourceObject so;
                    if (type != null && pro != null) {
                        DBObject provObj = this.getDBObject();
                        if (provObj == null) {
                            so = this.getTempObject();
                        } else if (provObj instanceof SourceObject) {
                            this.m_tempObject = null;
                            so = (SourceObject)provObj;
                        } else {
                            so = null;
                        }
                    } else {
                        so = null;
                    }
                    if (so == null) break;
                    TextBuffer tb = this.tryAcquireTextBuffer();
                    if (tb != null) {
                        try {
                            if (this.isOpen()) {
                                int changeId = tb.getChangeId();
                                String source = tb.getString(0, tb.getLength());
                                if (changeId != this.m_lastChangeId || ModelUtil.areDifferent((Object)source, (Object)this.m_lastSource)) {
                                    this.updateSource(so, source);
                                    this.m_builtSinceLastChange = false;
                                    this.m_lastSource = source;
                                    this.m_builtObject = null;
                                    this.m_lastChangeId = changeId;
                                } else if (this.m_builtObject != null && DBUtil.needsBuilding((DBObject)this.m_builtObject, (String)"comments")) {
                                    this.m_builtSinceLastChange = false;
                                    this.m_builtObject = null;
                                }
                            }
                        }
                        finally {
                            this.releaseTextBuffer();
                        }
                    }
                    if (fullyBuilt) {
                        if (!this.m_builtSinceLastChange) {
                            try {
                                this.m_objectBeingBuilt = so;
                                DerivedPropertyBuilder dpb = this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)this.m_objectBeingBuilt);
                                DBUtil.ensureObjectBuilt((DBObject)this.m_objectBeingBuilt, (String[])new String[]{"comments"});
                                this.m_builtObject = this.m_objectBeingBuilt;
                            }
                            catch (DBException e) {
                                DBLog.getLogger((Object)this).fine("Exception building Derived Properties: " + e.getMessage());
                                this.m_builtObject = null;
                            }
                            finally {
                                this.m_objectBeingBuilt = null;
                                this.m_builtSinceLastChange = true;
                            }
                        }
                        ret = this.m_builtObject;
                        break;
                    }
                    ret = so;
                    break;
                }
                SourceObject updSo = this.m_objectBeingBuilt;
                if (updSo == null || fullyBuilt) continue;
                ret = updSo;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!locked) continue;
                this.m_lock.unlock();
                continue;
            }
            break;
        }
        return ret;
    }

    public final void cancelCurrentBuild() {
        DerivedPropertyBuilder dpb;
        SourceObject so = this.m_objectBeingBuilt;
        if (so != null && (dpb = this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)so)) != null) {
            dpb.cancelCurrentBuild((DBObject)so);
        }
    }

    protected SourceObject findProviderDBObject() {
        return (SourceObject)BaseDBObjectNode.findDBObject(this);
    }

    protected void updateSource(SourceObject so, String source) {
        so.setSource(source);
    }

    private SourceObject getTempObject() {
        if (this.m_tempObject == null) {
            String type = this.getObjectType();
            Class cls = Metadata.getInstance().getObjectClass(type);
            if (cls != null && SourceObject.class.isAssignableFrom(cls)) {
                DBObjectProvider pro = this.getProvider();
                DBObjectFactory fac = pro.getObjectFactory();
                try {
                    this.m_tempObject = (SourceObject)fac.newObject(cls);
                    this.m_tempObject.setName(this.getObjectName());
                    this.m_tempObject.setSchema(pro.getSchema(this.getSchemaName()));
                    this.m_tempObject.setID(TemporaryObjectID.createID((DBObject)this.m_tempObject));
                }
                catch (Exception e) {
                    this.m_tempObject = null;
                    DBLog.getLogger((Object)this).log(Level.WARNING, "Failed to create temporary Source Object of type " + type, e);
                }
            }
        }
        return this.m_tempObject;
    }
}

