/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public class TemplateObjectsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener,
ListCellRenderer {
    public static final String TEMPLATE_SCHEMA = UIBundle.get("TEMPLATE_DEFAULT_SCHEMA_NAME");
    private JLabel m_lblSchemaForTemplates = new JLabel();
    private DBObjectChooser m_schemaForTemplates = new DBObjectChooser("SCHEMA");
    private DefaultListModel m_typeModel = new DefaultListModel();
    private JScrollPane m_scrTypes = new JScrollPane();
    private JList m_typeList = new JList(this.m_typeModel);
    private JLabel m_typeLabel = new JLabel();
    private JComboBox m_typeCombo = new JComboBox();
    private final Map<String, UIHolder> m_UIMap = new HashMap<String, UIHolder>();
    private JCheckBox m_makeDefault = new JCheckBox();
    private HashMap<String, DBObject> m_defaultTemplates = new HashMap();
    private DBObjectProvider m_pro;
    private int m_lastTypeIndex = -1;
    private boolean m_pickOneMode = false;
    private boolean m_initialised = false;
    private DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("TemplateObjectsPanel");

    public TemplateObjectsPanel(boolean pickOneMode) {
        this.m_pickOneMode = pickOneMode;
        this.setLayout(new GridBagLayout());
        this.m_typeList.getSelectionModel().addListSelectionListener(this);
        this.m_typeList.setCellRenderer(this);
        this.m_typeCombo.setRenderer(this);
        this.m_schemaForTemplates.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                Schema s = (Schema)chooser.getOrCreateDBObject();
                TemplateObjectsPanel.this.m_defaultTemplates.put("SCHEMA", s);
            }
        });
        this.m_typeCombo.addActionListener(this);
        this.m_resHelper.resLabel(this.m_lblSchemaForTemplates, this.m_schemaForTemplates, UIBundle.get("TEMPLATE_SCHEMA"), "m_templateSchema");
        this.m_resHelper.resLabel(this.m_typeLabel, this.m_typeCombo, UIBundle.get("UDT_PANEL_LABEL_TYPE"), "m_typeCombo");
        this.m_resHelper.resButton(this.m_makeDefault, UIBundle.get("TEMPLATE_OBJECT_MAKE_DEFAULT"), "m_makeDefault");
        this.m_scrTypes.setVerticalScrollBarPolicy(20);
        this.m_typeList.setSelectionMode(0);
        this.m_scrTypes.getViewport().add((Component)this.m_typeList, null);
        if (this.m_pickOneMode) {
            this.add(this.m_typeLabel, this.gbc(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            this.add(this.m_typeCombo, this.gbc(3, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        } else {
            JPanel p1 = new JPanel();
            p1.setLayout(new GridBagLayout());
            p1.add((Component)this.m_lblSchemaForTemplates, this.gbc(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0)));
            p1.add((Component)this.m_schemaForTemplates, this.gbc(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0)));
            this.add(p1, this.gbc(1, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 10, 0)));
            this.add(this.m_scrTypes, this.gbc(1, 2, 1, 4, 0.0, 1.0, 18, 3, new Insets(10, 0, 0, 10)));
        }
        if (this.m_pickOneMode) {
            this.add(this.m_makeDefault, this.gbc(3, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0)));
        }
        this.add(Box.createVerticalGlue(), this.gbc(2, 6, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0)));
    }

    public void init(DBObjectProvider pro, HashMap<String, DBObject> map) {
        if (!this.m_initialised) {
            this.m_pro = pro;
            this.m_defaultTemplates = map;
            if (!this.m_pickOneMode || pro instanceof Database) {
                this.m_makeDefault.setVisible(false);
            }
            if (!this.m_pickOneMode && !(pro instanceof Database)) {
                Schema templateSchema = (Schema)this.m_defaultTemplates.get("SCHEMA");
                if (templateSchema == null || templateSchema.getID() == null) {
                    String templateSchemaName = TEMPLATE_SCHEMA;
                    try {
                        templateSchema = this.m_pro.getSchema(templateSchemaName);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                this.m_schemaForTemplates.setProvider(this.m_pro);
                if (templateSchema != null && templateSchema.getID() != null) {
                    this.m_schemaForTemplates.setDBObject((DBObject)templateSchema);
                }
                this.m_schemaForTemplates.setEditable(true);
                this.m_schemaForTemplates.getDBObjectCriteria().setUserOnly(true);
            }
            Object[] types = new String[map.size()];
            int i = 0;
            for (String type : map.keySet()) {
                types[i++] = type;
            }
            Arrays.sort(types);
            for (Object type : types) {
                UIHolder h = new UIHolder((String)type, this.m_pro);
                this.m_UIMap.put((String)type, h);
            }
            this.m_typeCombo.removeActionListener(this);
            for (Object type : types) {
                if ("SCHEMA".equals(type)) continue;
                this.m_typeModel.addElement(type);
                this.m_typeCombo.addItem(type);
            }
            this.m_typeCombo.addActionListener(this);
            this.m_typeList.setSelectedIndex(0);
            this.m_lastTypeIndex = 0;
            this.typeChange();
            if (this.m_pickOneMode) {
                this.m_typeCombo.setSelectedItem("TABLE");
            }
            this.m_initialised = true;
        }
    }

    public HashMap<String, DBObject> commit() {
        String templateSchemaName = this.m_schemaForTemplates.getDBObject() == null ? null : this.m_schemaForTemplates.getDBObject().getName();
        Schema templateSchema = null;
        try {
            if (templateSchemaName != null && templateSchemaName.length() > 0 && (templateSchema = this.m_pro.getSchema(templateSchemaName = this.m_pro.getInternalName(templateSchemaName))) == null) {
                templateSchema = new Schema(templateSchemaName);
                this.m_pro.createSchema(templateSchema, false);
            }
        }
        catch (DBException e) {
            DBLog.getLogger((Object)this).warning("Couldn't create schema: " + e.getMessage());
        }
        this.m_defaultTemplates.put("SCHEMA", (DBObject)templateSchema);
        if (this.m_pickOneMode) {
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            SystemObject so = (SystemObject)this.m_defaultTemplates.get(type);
            if (!(this.m_pro instanceof Database) && this.m_makeDefault.isSelected()) {
                this.m_pro.setDefaultTemplateForType(type, (DBObject)so);
            }
            if (so == null) {
                so = (SystemObject)Metadata.getInstance().newInstance(type);
            }
            this.m_defaultTemplates.clear();
            this.m_defaultTemplates.put(type, (DBObject)so);
        }
        return this.m_defaultTemplates;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.m_lastTypeIndex = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
        this.typeChange();
    }

    private void typeChange() {
        String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
        for (String key : this.m_defaultTemplates.keySet()) {
            this.m_UIMap.get(key).setVisible(false);
        }
        this.m_UIMap.get(type).setVisible(true);
        Class clz = Metadata.getInstance().getObjectClass(type);
        if (SchemaObject.class.isAssignableFrom(clz)) {
            this.m_lblSchemaForTemplates.setEnabled(true);
            this.m_schemaForTemplates.setEnabled(true);
        } else {
            this.m_lblSchemaForTemplates.setEnabled(false);
            this.m_schemaForTemplates.setEnabled(false);
        }
        String checkBoxLabel = UIBundle.format("TEMPLATE_OBJECT_MAKE_DEFAULT", DBTypeDisplayRegistry.getDisplayName(type));
        this.m_resHelper.resButton(this.m_makeDefault, checkBoxLabel, "m_makeDefault");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setListeners(false);
        if (e.getSource() == this.m_typeCombo) {
            this.m_typeList.setSelectedIndex(this.m_typeCombo.getSelectedIndex());
            this.m_lastTypeIndex = this.m_typeCombo.getSelectedIndex();
        }
        this.setListeners(true);
    }

    private void setListeners(boolean on) {
        if (on) {
            this.m_typeCombo.addActionListener(this);
        } else {
            this.m_typeCombo.removeActionListener(this);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String type = (String)value;
        type = this.m_pickOneMode ? DBTypeDisplayRegistry.getSingularDisplayName(type) : DBTypeDisplayRegistry.getDisplayName(type);
        JLabel label = (JLabel)this.m_delegateLCR.getListCellRendererComponent((JList<?>)list, type, index, isSelected, cellHasFocus);
        label.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)value));
        return label;
    }

    private void addButton(JPanel panel, JButton button, GridBagConstraints gbc, String tooltip, String mnemonicText, String name) {
        this.m_resHelper.setName(button, name);
        button.setToolTipText(tooltip);
        if (ModelUtil.hasLength((String)mnemonicText)) {
            button.setMnemonic(StringUtils.getMnemonicKeyCode((String)mnemonicText));
        }
        IconicButtonUI.install((AbstractButton)button);
        panel.add((Component)button, gbc);
    }

    public final void setComponentsEnabledStatus(boolean status) {
        this.m_lblSchemaForTemplates.setEnabled(status);
        this.m_schemaForTemplates.setEnabled(status);
        this.m_scrTypes.setEnabled(status);
        this.m_typeList.setEnabled(status);
        this.m_typeLabel.setEnabled(status);
        this.m_typeCombo.setEnabled(status);
        this.m_makeDefault.setEnabled(status);
    }

    private class UIHolder {
        private final String m_type;
        private final JLabel m_schemaLabel;
        private final DBObjectChooser m_schemaChooser;
        private final JLabel m_templateLabel;
        private final DBObjectChooser m_templateChooser;

        UIHolder(final String type, DBObjectProvider pro) {
            this.m_type = type;
            this.m_schemaLabel = new JLabel();
            this.m_templateLabel = new JLabel();
            this.m_schemaChooser = new DBObjectChooser("SCHEMA");
            this.m_schemaChooser.setProvider(pro);
            this.m_schemaChooser.getDBObjectCriteria().setUserOnly(true);
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (SchemaObject.class.isAssignableFrom(clz)) {
                this.m_templateChooser = new DBObjectChooser(this.m_schemaChooser, type);
            } else {
                this.m_templateChooser = new DBObjectChooser(type);
                this.m_schemaChooser.setEnabled(false);
                this.m_schemaLabel.setEnabled(false);
            }
            this.m_templateChooser.setProvider(pro);
            this.m_templateChooser.setEditable(false);
            this.m_templateChooser.setNullText(" ");
            this.m_templateChooser.setDBObject((DBObject)TemplateObjectsPanel.this.m_defaultTemplates.get(type));
            this.m_templateChooser.addChangeListener(new DBObjectChooser.ChangeListener(){

                @Override
                public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                    DBObject obj = chooser.getDBObject();
                    TemplateObjectsPanel.this.m_defaultTemplates.put(type, obj);
                }
            });
            TemplateObjectsPanel.this.m_resHelper.resLabel(this.m_schemaLabel, this.m_schemaChooser, UIBundle.get("LABEL_SCHEMA"), "schema." + type);
            TemplateObjectsPanel.this.m_resHelper.resLabel(this.m_templateLabel, this.m_templateChooser, UIBundle.get("LABEL_NAME"), "template." + type);
            TemplateObjectsPanel.this.add(this.m_schemaLabel, TemplateObjectsPanel.this.gbc(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_schemaChooser, TemplateObjectsPanel.this.gbc(3, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_templateLabel, TemplateObjectsPanel.this.gbc(2, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            TemplateObjectsPanel.this.add(this.m_templateChooser, TemplateObjectsPanel.this.gbc(3, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
            this.setVisible(false);
        }

        void setVisible(boolean vis) {
            this.m_schemaLabel.setVisible(vis);
            this.m_schemaChooser.setVisible(vis);
            this.m_templateLabel.setVisible(vis);
            this.m_templateChooser.setVisible(vis);
            if (vis) {
                this.m_schemaChooser.resetCaches();
                this.m_templateChooser.resetCaches();
                Class clz = Metadata.getInstance().getObjectClass(this.m_type);
                if (SchemaObject.class.isAssignableFrom(clz)) {
                    SchemaObject template = (SchemaObject)TemplateObjectsPanel.this.m_defaultTemplates.get(this.m_type);
                    if (template != null) {
                        this.m_schemaChooser.setDBObject((DBObject)template.getSchema());
                        this.m_templateChooser.setDBObject((DBObject)template);
                    } else {
                        this.m_schemaChooser.setDBObject(null);
                        this.m_templateChooser.setDBObject(null);
                    }
                } else {
                    SystemObject template = (SystemObject)TemplateObjectsPanel.this.m_defaultTemplates.get(this.m_type);
                    this.m_templateChooser.setDBObject((DBObject)template);
                }
            }
        }
    }
}

