/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.controls.JWrappedLabel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.util.Pair;

public abstract class TesterComponent {
    private Map<String, Object> m_bindVariables;

    public abstract void testSQL(Database var1, String var2);

    public abstract Component getComponent();

    public abstract String getName();

    public void close() {
    }

    protected void setBindVariables(Map<String, Object> bindVariables) {
        this.m_bindVariables = bindVariables;
    }

    protected Map<String, ?> getBindVariables(Database db, String sqlText) {
        this.promptForBindVariables(db, sqlText);
        return this.m_bindVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForBindVariables(Database db, String sqlText) {
        HashSet<String> vars = new HashSet<String>();
        for (String bv : SQLFragmentUtils.listBindVariables((String)sqlText)) {
            vars.add(bv);
        }
        if (vars.size() > 0) {
            if (this.m_bindVariables == null) {
                this.m_bindVariables = new HashMap<String, Object>();
            }
            for (String bv : vars) {
                if (this.m_bindVariables.containsKey(bv)) continue;
                this.m_bindVariables.put(bv, null);
            }
            BindVariablePanel panel = new BindVariablePanel(this.m_bindVariables);
            JEWTDialog dialog = JEWTDialog.createDialog((Component)this.getComponent(), (String)UIBundle.get("TESTSQL_BIND_TITLE"), (int)5);
            dialog.setContent(panel.getComponent());
            dialog.setMinimumSize(400, 300);
            dialog.setPreferredSize(400, 300);
            dialog.setResizable(true);
            dialog.setName("SQLQueryTester.BindDialog");
            try {
                dialog.runDialog();
                for (Map.Entry<String, ?> entry : panel.getBindVariables().entrySet()) {
                    Object value = entry.getValue();
                    this.m_bindVariables.put(entry.getKey(), value == null ? "" : value);
                }
            }
            finally {
                dialog.dispose();
            }
        }
    }

    public static abstract class DelegateTesterComponent
    extends TesterComponent {
        private TesterComponent m_delegate;

        @Override
        public abstract String getName();

        protected abstract TesterComponent createDelegate();

        protected final TesterComponent getDelegate() {
            if (this.m_delegate == null) {
                this.m_delegate = this.createDelegate();
            }
            return this.m_delegate;
        }

        @Override
        public Component getComponent() {
            Component retval = null;
            TesterComponent d = this.getDelegate();
            if (d != null) {
                retval = d.getComponent();
            }
            return retval;
        }

        @Override
        public void testSQL(Database db, String sqlQuery) {
            TesterComponent d = this.getDelegate();
            if (d != null) {
                d.testSQL(db, sqlQuery);
            }
        }

        @Override
        public void close() {
            TesterComponent d = this.m_delegate;
            if (d != null) {
                d.close();
                this.m_delegate = null;
            }
        }

        @Override
        protected Map<String, ?> getBindVariables(Database db, String sqlText) {
            TesterComponent d = this.getDelegate();
            return d == null ? super.getBindVariables(db, sqlText) : d.getBindVariables(db, sqlText);
        }

        @Override
        protected void setBindVariables(Map<String, Object> bindVariables) {
            super.setBindVariables(bindVariables);
            TesterComponent d = this.getDelegate();
            if (d != null) {
                d.setBindVariables(bindVariables);
            }
        }
    }

    private static class PairTableFormat
    implements SimpleTableFormat<Pair> {
        private PairTableFormat() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? UIBundle.get("TESTSQL_BIND_NAME") : UIBundle.get("TESTSQL_BIND_VALUE");
        }

        public Object getValueAt(Pair rowValue, int columnIndex) {
            return columnIndex == 0 ? rowValue.getFirst() : rowValue.getSecond();
        }

        public boolean isCellEditable(Pair rowValue, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Pair rowValue, Object value, int columnIndex) {
            if (columnIndex == 1) {
                rowValue.setSecond(value);
            }
        }
    }

    private static class BindVariablePanel {
        private final SimpleTableModel<Pair> m_tableModel;
        private final GenericTable m_table;
        private final JPanel m_panel;

        public BindVariablePanel(Map<String, Object> bindVars) {
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            for (Map.Entry<String, Object> entry : bindVars.entrySet()) {
                pairs.add(new Pair((Object)entry.getKey(), entry.getValue()));
            }
            this.m_tableModel = new SimpleTableModel(pairs, (SimpleTableFormat)new PairTableFormat());
            this.m_table = new GenericTable(this.m_tableModel);
            this.m_table.setColumnSelectorAvailable(false);
            this.m_table.setColumnHeaderSelectionEnabled(false);
            this.m_table.setSelectAllEnabled(false);
            this.m_table.setName("BindVariablePanel.Table");
            JWrappedLabel desc = new JWrappedLabel(UIBundle.get("TESTSQL_BIND_DESC"));
            this.m_panel = new JPanel();
            HelpUtils.setHelpID((JComponent)this.m_panel, (String)"f1_odbsqltestbindvariable_html");
            this.m_panel.setName("BindVariablePanel");
            this.m_panel.setLayout(new BorderLayout(0, 15));
            this.m_panel.add((Component)desc, "North");
            this.m_panel.add((Component)new JScrollPane((Component)this.m_table), "Center");
        }

        public Component getComponent() {
            return this.m_panel;
        }

        public Map<String, ?> getBindVariables() {
            TableCellEditor ce = this.m_table.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            TreeMap<String, Object> retval = new TreeMap<String, Object>();
            for (Pair pair : this.m_tableModel.asList()) {
                retval.put((String)pair.getFirst(), pair.getSecond());
            }
            return retval;
        }
    }
}

