/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideri.util.Product;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

public class DBObjectActionsContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context ctx = contextMenu.getContext();
        DBObjectNode node = DBObjectNodeUtil.getSelectedElement(ctx, DBObjectNode.class);
        if (node != null) {
            DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory(node);
            if (fac != null) {
                Class clz;
                String type = DBObjectNodeUtil.normalizeType(node);
                boolean isSystemObject = type != null ? (clz = Metadata.getInstance().getObjectClass(type)) != null && SystemObject.class.isAssignableFrom(clz) : false;
                if (!(node instanceof DBObjectPlSqlNode && ((DBObjectPlSqlNode)node).isBody() || Product.isRaptor() || !isSystemObject)) {
                    JMenuItem duplicate = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getDuplicateAction());
                    contextMenu.add((Component)duplicate, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                }
                if (this.shouldAddProperties(ctx)) {
                    JMenuItem edit = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getPropertiesAction());
                    contextMenu.add((Component)edit, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                }
            }
            if (node instanceof DBObjectPlSqlNode) {
                String type = node.getObjectType();
                if (("PACKAGE".equals(type) || "TYPE".equals(type) || "PACKAGE BODY".equals(type) || "TYPE BODY".equals(type)) && PlSqlFeatures.isSupportedSyncSpecAndBody()) {
                    JMenuItem body = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getSynchronizeSpecAndBody());
                    contextMenu.add((Component)body, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                }
                if (ctx.getView() instanceof CodeEditor) {
                    if (PlSqlFeatures.isSupportedQuickDocumentation()) {
                        JMenuItem comments = contextMenu.createMenuItem((ToggleAction)IdeAction.find((String)"AbstractDocPopupController.SHOW_DOC_POPUP_CMD"));
                        contextMenu.add((Component)comments, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                    if (PlSqlFeatures.isSupportedTestQuery()) {
                        JMenuItem testQuery = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getTestQueryAction());
                        contextMenu.add((Component)testQuery, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                }
            }
        }
    }

    private boolean shouldAddProperties(Context context) {
        return context.getView() instanceof ExplorerWindow && DBObjectNodeUtil.isOnlineNode(context.getNode());
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

