/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.ideimpl.db.ceditor.PlSqlQueryTester;
import oracle.ideimpl.db.ceditor.PlSqlSpecAndBodySynchronizer;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;

class DBObjectActionsController
implements Controller {
    DBObjectActionsController() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean retval = false;
        int cmdID = action.getCommandId();
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            DBObjectNode node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node != null) {
                DBObject template = node.getDBObject();
                DBObjectProvider pro = node.getProvider();
                SystemObject sysObj = DBUtil.getSystemObject((DBObject)template);
                if (sysObj != null) {
                    try {
                        template = DBUtil.getProviderDefinition((DBObject)template, (DBObjectProvider)pro);
                    }
                    catch (DBException e) {
                        DBLog.getLogger((Object)this).log(Level.WARNING, "Error checking object is latest version: " + e.getMessage());
                    }
                    DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((DBObject)sysObj, pro);
                    if (fac != null) {
                        DBEditorConfig config;
                        DBObject newObj = pro.getObjectFactory().newObject(template);
                        if (!(newObj instanceof SystemObject) && newObj instanceof ChildDBObject) {
                            SystemObject original = sysObj;
                            config = DBEditorConfig.newEditConfig(pro, (DBObject)original);
                            SystemObject newSysObject = config.getUpdatedObject();
                            ((ChildDBObject)newObj).setParent((DBObject)newSysObject);
                            config.setObjectType(newObj.getType());
                            config.setChildEditOnly(true);
                            config.setChildObject(newObj);
                        } else {
                            config = DBEditorConfig.newCreateConfig(pro, newObj);
                        }
                        fac.launchDialog(config);
                    }
                }
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId()) {
            DBObjectNode node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node != null && DBObjectNodeUtil.isOnlineNode(node)) {
                retval = true;
                DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory(node);
                if (fac != null) {
                    fac.editDBObject(node);
                }
            }
        } else if (cmdID == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            retval = true;
            Node node = context.getNode();
            if (node instanceof BaseDBObjectTextNode) {
                View view = context.getView();
                Integer offset = view instanceof CodeEditor ? Integer.valueOf(((CodeEditor)view).getSelectionStart()) : null;
                PlSqlSpecAndBodySynchronizer.launch((BaseDBObjectTextNode)node, offset);
            }
        } else if (cmdID == DBObjectActions.getTestQueryAction().getCommandId()) {
            retval = true;
            PlSqlQueryTester.invokeTestQuery(context);
        }
        return retval;
    }

    public boolean update(IdeAction action, Context context) {
        boolean retval = false;
        boolean enabled = false;
        int cmdID = action.getCommandId();
        DBObjectNode node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            if (node != null) {
                enabled = DBEditorFactoryRegistry.getEditFactory(node) != null;
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId()) {
            if (node != null) {
                retval = true;
                enabled = DBObjectNodeUtil.isOnlineNode(node) && DBEditorFactoryRegistry.getEditFactory(node) != null;
            }
        } else if (cmdID == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            retval = true;
            if (node != null) {
                enabled = true;
            }
        } else if (cmdID == DBObjectActions.getTestQueryAction().getCommandId()) {
            retval = true;
            enabled = PlSqlQueryTester.enableTestQuery(context);
        }
        if (retval) {
            action.setEnabled(enabled);
        }
        return retval;
    }
}

