/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.MnemonicBuilder;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.util.Pair;

public class DBUIMnemonicBuilder {
    private static final String IGNORE_KEY = "DBUIMnemonicBuilder.IGNORE_KEY";
    private static final String s_validCharacters;
    private final JPanel m_panel;
    private final List<Container> m_roots;
    private final List<Component> m_compList;
    private final List<String> m_labels;
    private final List<String> m_options;
    private final boolean m_skipLabels;
    private String m_availableCharacters;

    public DBUIMnemonicBuilder(JPanel panel) {
        this(panel, panel);
    }

    public DBUIMnemonicBuilder(JPanel panel, JPanel childPanel) {
        Container container;
        this.m_panel = panel;
        this.m_compList = new ArrayList<Component>();
        this.m_roots = new ArrayList<Container>();
        this.m_labels = new ArrayList<String>();
        this.m_options = new ArrayList<String>();
        this.m_availableCharacters = s_validCharacters;
        for (container = childPanel; container != panel && container != null; container = container.getParent()) {
            if (!this.isTabRoot(container.getParent())) continue;
            this.m_roots.add(container);
        }
        if (container == null) {
            throw new IllegalArgumentException("childPanel is not a child of panel");
        }
        String test = DisplayNames.getPropertyDisplayName((String)"name");
        boolean use = false;
        for (int i = 0; i < test.length(); ++i) {
            if (s_validCharacters.indexOf(test.charAt(i)) <= -1) continue;
            use = true;
            break;
        }
        this.m_skipLabels = !use;
    }

    public void reserveMnemonic(char mnemonic) {
        if (mnemonic != '\u0000') {
            String str = Character.toString(mnemonic);
            this.m_availableCharacters = this.m_availableCharacters.replace(str, "");
        }
    }

    public static void addLabelOption(JComponent comp, String option, String label) {
        LabelOptions opts = (LabelOptions)comp.getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
        if (opts == null) {
            opts = new LabelOptions();
            comp.putClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options", opts);
        }
        opts.m_map.put(option, new Pair((Object)label, null));
    }

    public static void setLabelOption(JComponent comp, String option) {
        Pair opt;
        LabelOptions opts = (LabelOptions)comp.getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
        if (opts != null && (opt = (Pair)opts.m_map.get(option)) != null && opt.first != null) {
            Character mnemonic = (Character)opt.second;
            if (mnemonic == null) {
                mnemonic = Character.valueOf('\u0000');
            }
            DBUIMnemonicBuilder.setMnemonicAndText(comp, mnemonic, (String)opt.first);
            return;
        }
        throw new IllegalStateException("Option " + option + " not found");
    }

    public static void setIgnoreComponent(Component comp, boolean ignore) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (ignore) {
                jcomp.putClientProperty(IGNORE_KEY, Boolean.TRUE);
            } else {
                jcomp.putClientProperty(IGNORE_KEY, null);
            }
        } else if (ignore) {
            DBLog.getLogger(DBUIMnemonicBuilder.class).warning("setIgnoreComponent only supported on JComponent");
        }
    }

    private static boolean isIgnoreComponent(Component comp) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            Object o = jcomp.getClientProperty(IGNORE_KEY);
            return Boolean.TRUE.equals(o);
        }
        return false;
    }

    public void build() {
        JEWTDialog dlg = this.getDialog();
        if (dlg != null) {
            this.reserveDialogMnemonics(dlg);
            TabbedEditorPanel tpe = this.getTabbedEditorPanel((Container)dlg);
            if (tpe != null && tpe.getTop() != null) {
                this.reserveHeaderMnemonics((Container)tpe.getTop().getComponent());
            }
        }
        this.buildComponentList(this.m_panel);
        ArrayList<Character> mnemonics = new ArrayList<Character>();
        if (this.m_skipLabels) {
            for (int i = 0; i < this.m_labels.size(); ++i) {
                mnemonics.add(null);
            }
        } else {
            MnemonicBuilder.build((String)this.m_availableCharacters, this.m_labels, mnemonics);
        }
        for (Character m : mnemonics) {
            if (m == null) continue;
            this.reserveMnemonic(m.charValue());
        }
        this.setMnemonics(mnemonics);
    }

    public void removeAll() {
        this.buildComponentList(this.m_panel);
        for (int i = 0; i < this.m_compList.size(); ++i) {
            Component comp = this.m_compList.get(i);
            if (this.getExistingMnemonic(comp) == 0) continue;
            DBUIMnemonicBuilder.setMnemonicAndText(comp, Character.valueOf('\u0000'), this.getText(comp));
        }
    }

    private void reserveDialogMnemonics(JEWTDialog dialog) {
        this.reserveMnemonic((char)dialog.getButtonMnemonic(1));
        this.reserveMnemonic((char)dialog.getButtonMnemonic(2));
        this.reserveMnemonic((char)dialog.getButtonMnemonic(4));
        this.reserveMnemonic((char)dialog.getButtonMnemonic(8));
        this.reserveMnemonic((char)dialog.getButtonMnemonic(16));
    }

    private void reserveHeaderMnemonics(Container parent) {
        for (Component comp : parent.getComponents()) {
            int m = this.getExistingMnemonic(comp);
            if (m != 0) {
                this.reserveMnemonic((char)m);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.reserveHeaderMnemonics((Container)comp);
        }
    }

    private void buildComponentList(Container container) {
        List<Component> children = Arrays.asList(container.getComponents());
        Container onlyChild = null;
        if (this.isTabRoot(container)) {
            for (Container root : this.m_roots) {
                if (!children.contains(root)) continue;
                onlyChild = root;
                break;
            }
        }
        if (onlyChild != null) {
            children = Collections.singletonList(onlyChild);
        }
        for (Component comp : children) {
            boolean ignore;
            ReorderableTableWithTitleBar tab;
            int m = this.getExistingMnemonic(comp);
            if (m != 0 && this.m_availableCharacters.indexOf(m) >= 0) {
                this.reserveMnemonic((char)m);
                continue;
            }
            if (comp instanceof JLabel && ((JLabel)comp).getLabelFor() == null && (tab = (ReorderableTableWithTitleBar)this.findParent(comp, ReorderableTableWithTitleBar.class, 10)) != null) {
                ((JLabel)comp).setLabelFor((Component)tab);
            }
            if (!(ignore = DBUIMnemonicBuilder.isIgnoreComponent(comp)) && comp instanceof JComponent && ((JComponent)comp).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options") != null) {
                LabelOptions opts = (LabelOptions)((JComponent)comp).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options");
                for (String opt : opts.m_map.keySet()) {
                    Pair labelAndMnemonic = (Pair)opts.m_map.get(opt);
                    this.m_compList.add(comp);
                    this.m_labels.add((String)labelAndMnemonic.first);
                    this.m_options.add(opt);
                }
                continue;
            }
            if (!ignore && comp instanceof JLabel && ((JLabel)comp).getLabelFor() != null) {
                this.m_compList.add(comp);
                this.m_labels.add(this.getText(comp));
                this.m_options.add(null);
                continue;
            }
            if (!ignore && comp instanceof AbstractButton && (comp instanceof JCheckBox || comp.getName() != null)) {
                this.m_compList.add(comp);
                this.m_labels.add(this.getText(comp));
                this.m_options.add(null);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.buildComponentList((Container)comp);
        }
    }

    private Component findParent(Component comp, Class<? extends Component> clz, int maxDepth) {
        if (maxDepth > 0 && comp != null) {
            Container parent = comp.getParent();
            if (parent != null && clz.isAssignableFrom(parent.getClass())) {
                return parent;
            }
            return this.findParent(parent, clz, maxDepth - 1);
        }
        return null;
    }

    private boolean isTabRoot(Container container) {
        return container instanceof JTabbedPane;
    }

    private void setMnemonics(List<Character> mnemonics) {
        for (int i = 0; i < this.m_compList.size(); ++i) {
            Component comp = this.m_compList.get(i);
            String opt = this.m_options.get(i);
            String text = this.getText(comp);
            Character m = mnemonics.get(i);
            if (m != null) {
                DBUIMnemonicBuilder.setMnemonicAndText(comp, m, null);
            } else if (this.getExistingMnemonic(comp) == 0 && this.m_availableCharacters.length() > 0) {
                if (text != null && text.length() > 0) {
                    m = Character.valueOf(this.m_availableCharacters.charAt(0));
                    StringBuilder sb = new StringBuilder(text);
                    int pos = text.lastIndexOf(":");
                    if (pos > -1) {
                        sb.insert(pos, UIBundle.format("DBUIMNEMONICBUILDER_PARENTHESES", m));
                    } else {
                        sb.append(UIBundle.format("DBUIMNEMONICBUILDER_PARENTHESES", m));
                    }
                    DBUIMnemonicBuilder.setMnemonicAndText(comp, m, sb.toString());
                } else {
                    m = Character.valueOf(this.m_availableCharacters.charAt(this.m_availableCharacters.length() - 1));
                    String tooltip = null;
                    if (comp instanceof JLabel) {
                        JLabel label = (JLabel)comp;
                        tooltip = label.getToolTipText();
                    } else if (comp instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)comp;
                        tooltip = button.getToolTipText();
                    }
                    tooltip = tooltip == null ? UIBundle.format("DBUIMNEMONICBUILDER_TOOLTIP", m) : tooltip + " " + UIBundle.format("DBUIMNEMONICBUILDER_TOOLTIP", m);
                    if (comp instanceof JLabel) {
                        JLabel label = (JLabel)comp;
                        label.setDisplayedMnemonic(m.charValue());
                        label.setToolTipText(tooltip);
                    } else if (comp instanceof AbstractButton) {
                        AbstractButton button = (AbstractButton)comp;
                        button.setMnemonic(m.charValue());
                        button.setToolTipText(tooltip);
                    }
                }
                this.reserveMnemonic(m.charValue());
            }
            if (opt == null) continue;
            ((Pair)((LabelOptions)((JComponent)comp).getClientProperty("oracle.ideimpl.db.DBUIMnemonicBuilder.options")).m_map.get(opt)).setSecond((Object)m);
        }
    }

    private JEWTDialog getDialog() {
        Window dialogOwner;
        JEWTDialog ret = null;
        Dialog dlg = IdeUtil.findDialog((Component)this.m_panel);
        if (dlg == null && (dialogOwner = IdeUtil.modalDialogOwner()) instanceof Dialog) {
            dlg = (Dialog)dialogOwner;
        }
        if (dlg instanceof JEWTDialog) {
            ret = (JEWTDialog)dlg;
        }
        return ret;
    }

    private String getText(Component comp) {
        String text = null;
        if (comp instanceof JLabel) {
            text = ((JLabel)comp).getText();
        } else if (comp instanceof AbstractButton) {
            text = ((AbstractButton)comp).getText();
        }
        return text;
    }

    private static void setMnemonicAndText(Component comp, Character mnemonic, String newText) {
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            if (newText != null) {
                label.setText(newText);
            }
            label.setDisplayedMnemonic(mnemonic.charValue());
            String labelText = label.getText();
            int mnemonicIndex = StringUtils.getMnemonicIndex((String)labelText);
            if (mnemonicIndex != -1) {
                label.setDisplayedMnemonicIndex(mnemonicIndex);
            }
        } else if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            if (newText != null) {
                button.setText(newText);
            }
            button.setMnemonic(mnemonic.charValue());
            String labelText = button.getText();
            int mnemonicIndex = StringUtils.getMnemonicIndex((String)labelText);
            if (mnemonicIndex != -1) {
                button.setDisplayedMnemonicIndex(mnemonicIndex);
            }
        }
    }

    private int getExistingMnemonic(Component comp) {
        int existingMnemonic = 0;
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            existingMnemonic = label.getDisplayedMnemonic();
        } else if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            existingMnemonic = button.getMnemonic();
        }
        return existingMnemonic;
    }

    private TabbedEditorPanel getTabbedEditorPanel(Container parent) {
        for (Component child : parent.getComponents()) {
            TabbedEditorPanel tpe;
            if (child instanceof TabbedEditorPanel) {
                return (TabbedEditorPanel)((Object)child);
            }
            if (!(child instanceof Container) || (tpe = this.getTabbedEditorPanel((Container)child)) == null) continue;
            return tpe;
        }
        return null;
    }

    static {
        String valid = UIBundle.get("DBUIMNEMONICBUILDER_CHARACTERS");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < valid.length(); ++i) {
            String chr = valid.substring(i, i + 1);
            if (valid.indexOf(chr) != i) continue;
            sb.append(chr);
        }
        s_validCharacters = sb.toString();
        if (!s_validCharacters.equals(valid)) {
            DBLog.getLogger().warning("DBUIMnemonicBuilder: " + valid + " contains repeated characters");
        }
    }

    private static class LabelOptions {
        private static final String KEY = "oracle.ideimpl.db.DBUIMnemonicBuilder.options";
        private final Map<String, Pair<String, Character>> m_map = new HashMap<String, Pair<String, Character>>();

        private LabelOptions() {
        }
    }
}

