/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;

public class ProgressBarExecutionWrapper
extends StatementWrapper.ExecutionProxy {
    private LogPage m_page;
    private boolean m_useLogPage;

    public ProgressBarExecutionWrapper() {
        String prop = System.getProperty("ide.db.logpage");
        this.m_useLogPage = prop != null && !prop.equalsIgnoreCase("false");
    }

    private LogPage getLogPage() {
        if (this.m_page == null && this.m_useLogPage) {
            this.m_page = new MessagePage(new ViewId("DatabaseLog", "Database Log"), OracleIcons.getIcon((String)"database.png"), true);
        }
        return this.m_page;
    }

    private boolean isSysPropDisabled() {
        String prop = System.getProperty("ide.db.progressBar");
        return prop != null && prop.equalsIgnoreCase("false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatementDelay() {
        String prop = System.getProperty("ide.db.statementDelay");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            ProgressBarExecutionWrapper progressBarExecutionWrapper = this;
            synchronized (progressBarExecutionWrapper) {
                try {
                    ((Object)((Object)this)).wait(4000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public <T> T execute(StatementWrapper.ExecutionRunnable<T> r) throws DBException {
        if (SwingUtilities.isEventDispatchThread() && !this.isSysPropDisabled()) {
            Frame parent = IdeUtil.getMainWindow();
            ProgressBar pb = new ProgressBar((Component)parent, UIBundle.format("EXEC_PB_TITLE", r.getName()), null, true);
            R run = new R(r, pb);
            pb.setRunnable((Runnable)run);
            pb.setDialogName("Progress Bar:" + DBUtil.createUUID());
            pb.start("", "", 1500);
            if (pb.hasUserCancelled()) {
                try {
                    r.cancel();
                }
                catch (SQLException sqe) {
                    SQLErrorDialog.showErrorDialog(parent, UIBundle.get("EXEC_CANCEL_TITLE"), sqe);
                }
                StatementWrapper.throwCancelledException();
            }
        } else {
            this.runAndLog(r);
        }
        return (T)r.getResult();
    }

    private void runAndLog(StatementWrapper.ExecutionRunnable r) {
        r.run();
        this.checkStatementDelay();
        try {
            LogPage log;
            final String name = r.getName();
            final String msg = r.getLogText();
            if (msg != null && (log = this.getLogPage()) != null) {
                SwingUtils.dispatch((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        log.log((Object)(name + ":\n" + msg.trim() + "\n\n"));
                    }
                });
            }
        }
        catch (Throwable t) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "sql logging failure", t);
        }
    }

    private class R
    implements Runnable {
        private StatementWrapper.ExecutionRunnable m_r;
        private ProgressBar m_pb;

        R(StatementWrapper.ExecutionRunnable r, ProgressBar pb) {
            this.m_r = r;
            this.m_pb = pb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ProgressBarExecutionWrapper.this.runAndLog(this.m_r);
            }
            finally {
                this.m_pb.setDoneStatus();
            }
        }
    }
}

