/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.model.SingletonProvider;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;

public abstract class DBEditorConnectionProvider {
    private static final Map<URL, String> m_urlToConnMap = new TreeMap<URL, String>((Comparator<URL>)new URLComparator());

    public abstract Collection<String> getAvailableConnections(Context var1);

    protected abstract String getStoreName(Context var1);

    public abstract void addConnectionsListener(Context var1, ConnectionProviderListener var2);

    public abstract void removeConnectionsListener(Context var1, ConnectionProviderListener var2);

    public static DBEditorConnectionProvider getInstance() {
        return (DBEditorConnectionProvider)SingletonProvider.find(DBEditorConnectionProvider.class);
    }

    public static Database getCurrentDatabase(Context context) {
        Node node = context.getNode();
        if (DBObjectNodeUtil.isOnlineNode(node)) {
            DBObjectProvider pro = ((DBObjectNode)node).getProvider();
            if (pro instanceof Database) {
                return (Database)pro;
            }
        } else if (node != null) {
            String connName = m_urlToConnMap.get(node.getURL());
            String storeName = DBEditorConnectionProvider.getInstance().getStoreName(context);
            if (connName != null && storeName != null) {
                try {
                    Database db = DatabaseFactory.findOrCreateDatabase((String)storeName, (String)connName);
                    return db;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean hasCurrentDatabase(Node node) {
        if (node == null) {
            return false;
        }
        if (DBObjectNodeUtil.isOnlineNode(node)) {
            return true;
        }
        return m_urlToConnMap.get(node.getURL()) != null;
    }

    static void setURLConnection(URL url, String connName, boolean defaultForSiblings) {
        if (url != null) {
            if (connName == null) {
                m_urlToConnMap.remove(url);
            } else {
                m_urlToConnMap.put(url, connName);
            }
            if (defaultForSiblings) {
                URL parURL = URLFileSystem.getParent((URL)url);
                DBEditorConnectionProvider.setURLConnection(parURL, connName, false);
            }
        }
    }

    static String getDefaultConnection(URL url) {
        URL parURL;
        if (url != null && (parURL = URLFileSystem.getParent((URL)url)) != null) {
            return m_urlToConnMap.get(parURL);
        }
        return null;
    }

    public static interface ConnectionProviderListener {
        public void connectionsChanged();
    }
}

