/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;

final class PlSqlBreadcrumb
implements Breadcrumb<Integer> {
    private static final StyledTextAttribute NORMAL_ATTR;
    private static final StyledTextAttribute BOLD_ATTR;
    private StyledTextModel m_shortName;
    private StyledTextModel m_longName;
    private int m_startOffset;
    private PlSqlFragment m_source;
    private String m_peekText;

    PlSqlBreadcrumb(String boldPart, String normalPart, int startOffset, PlSqlFragment source, String peekText) {
        this.m_shortName = new StyledTextModel(boldPart, BOLD_ATTR);
        this.m_longName = new StyledTextModel();
        this.m_longName.addText(boldPart, BOLD_ATTR);
        if (normalPart != null) {
            this.m_longName.addText(normalPart, NORMAL_ATTR);
        }
        this.m_startOffset = startOffset;
        this.m_source = source;
        this.m_peekText = peekText;
    }

    public StyledTextModel getShortName() {
        return this.m_shortName;
    }

    public StyledTextModel getLongName() {
        return this.m_longName;
    }

    public Integer getUserObject() {
        return this.m_startOffset;
    }

    public boolean canHavePopupItems() {
        return this.m_source.getFragmentType() == PlSqlFragment.Type.PACKAGE_SPEC || this.m_source.getFragmentType() == PlSqlFragment.Type.PACKAGE_BODY || this.m_source.getFragmentType() == PlSqlFragment.Type.TYPE_SPEC || this.m_source.getFragmentType() == PlSqlFragment.Type.TYPE_BODY;
    }

    public List<PopupItem> getPopupItems() {
        if (this.canHavePopupItems()) {
            ArrayList<PopupItem> items = new ArrayList<PopupItem>();
            PlSqlBreadcrumb.fillFunctionPopupItems(items, this.m_source);
            Collections.sort(items);
            return items;
        }
        return Collections.emptyList();
    }

    public String getPeekText() {
        return this.m_peekText;
    }

    private static void fillFunctionPopupItems(List<PopupItem> items, PlSqlFragment parent) {
        block3: for (PlSqlFragment child : parent.getChildren()) {
            switch (child.getFragmentType()) {
                case PROCEDURE: 
                case PROCEDURE_FD: 
                case FUNCTION: 
                case FUNCTION_FD: {
                    PopupItem item = new PopupItem();
                    item.setName(child.getDescription(Integer.valueOf(100)));
                    item.setUserObject((Object)child.getStartOffset());
                    items.add(item);
                    continue block3;
                }
            }
        }
    }

    static {
        Font font = UIManager.getFont("Label.font");
        NORMAL_ATTR = new StyledTextAttribute(font, null);
        BOLD_ATTR = new StyledTextAttribute(font.deriveFont(1), null);
    }
}

