/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

final class PlSqlBreadcrumbsModel
implements BreadcrumbsModel {
    private final List<BreadcrumbsModelListener> m_listeners = new LinkedList<BreadcrumbsModelListener>();
    private final ArrayList<Breadcrumb> m_crumbs = new ArrayList();

    PlSqlBreadcrumbsModel() {
    }

    public int getBreadcrumbCount() {
        return this.m_crumbs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breadcrumb getBreadcrumb(int crumb) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            if (crumb < this.getBreadcrumbCount()) {
                return this.m_crumbs.get(crumb);
            }
            return null;
        }
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (this.m_listeners.contains(l)) {
            this.m_listeners.remove(l);
        }
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        return ((PlSqlBreadcrumb)breadcrumb).canHavePopupItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(PlSqlFragment frag, int caretPosition) {
        ArrayList<Breadcrumb> arrayList = this.m_crumbs;
        synchronized (arrayList) {
            this.m_crumbs.clear();
            try {
                while (frag != null && frag.getFragmentType() != PlSqlFragment.Type.ROOT) {
                    PlSqlToken tk = frag.getFirstToken();
                    if (!tk.isCode()) {
                        tk = tk.getNextCodeToken();
                    }
                    String bold = null;
                    switch (frag.getFragmentType()) {
                        case PACKAGE_SPEC: 
                        case TYPE_SPEC: 
                        case PROCEDURE: 
                        case PROCEDURE_FD: 
                        case FUNCTION: 
                        case FUNCTION_FD: 
                        case TRIGGER: {
                            bold = tk.getNextCodeToken().getSource();
                            break;
                        }
                        case PACKAGE_BODY: 
                        case TYPE_BODY: {
                            bold = tk.getNextCodeToken(2).getSource();
                            break;
                        }
                        case IF: 
                        case ELSIF: 
                        case ELSE: 
                        case EXCEPTION: 
                        case LOOP: 
                        case CASE: {
                            bold = frag.getTypeString().toLowerCase();
                            break;
                        }
                        case FOR_LOOP: {
                            bold = "for";
                            break;
                        }
                        case WHILE_LOOP: {
                            bold = "while";
                            break;
                        }
                    }
                    if (bold != null) {
                        String plain = null;
                        if (this.m_crumbs.size() == 0) {
                            String desc = frag.getDescription(null);
                            int pos = desc.indexOf("(");
                            if (pos > 0) {
                                bold = desc.substring(0, pos);
                                plain = desc.substring(pos);
                            } else {
                                bold = desc;
                            }
                        }
                        PlSqlBreadcrumb crumb = new PlSqlBreadcrumb(bold, plain, frag.getStartOffset(), frag, this.getPeekString(frag));
                        this.m_crumbs.add(0, crumb);
                    }
                    frag = frag.getParent();
                }
                return true;
            }
            catch (ExpiredTextBufferException e) {
                this.m_crumbs.clear();
            }
        }
        return false;
    }

    private String getPeekString(PlSqlFragment frag) {
        PlSqlFragment[] kids = frag.getChildren();
        PlSqlToken start = frag.getFirstToken();
        PlSqlToken end = frag.getLastToken();
        if (kids != null && kids.length > 0) {
            end = kids[0].getFragmentType() == PlSqlFragment.Type.PARAMETER_LIST ? kids[0].getLastToken() : kids[0].getFirstToken().getPrevCodeToken();
        }
        String elip = "";
        while (end.getEnd() > start.getStart() + 1000) {
            elip = "...";
            end = end.getPrevToken();
        }
        return start.getSource(false, end) + elip;
    }

    public void dispose() {
        this.m_crumbs.clear();
    }

    void fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener l : this.m_listeners) {
            l.breadcrumbsUpdated();
        }
    }
}

