/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.PeekHelper;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumbsModel;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;

public final class PlSqlBreadcrumbsPlugin
extends BreadcrumbsPlugin
implements CaretListener {
    private PlSqlBreadcrumbsListener m_listener;
    private PlSqlBreadcrumbsModel m_breadcrumbsModel;
    private PopupHandler m_popupHandler;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane editor) {
        Preferences preferences = Preferences.getPreferences();
        if (DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs() && PlSqlFeatures.isSupportedBreadcrumbs() && PlSqlFeatures.getTextNode(editor) != null) {
            super.install(editor);
            editor.addCaretListener((CaretListener)this);
            this.m_breadcrumbsModel = new PlSqlBreadcrumbsModel();
            this.breadcrumbs.setModel((BreadcrumbsModel)this.m_breadcrumbsModel);
            this.m_listener = new PlSqlBreadcrumbsListener();
            this.breadcrumbs.addBreadcrumbsListener((BreadcrumbsListener)this.m_listener);
            this.m_popupHandler = new PopupHandler();
            this.m_popupHandler.attach(this.breadcrumbs, (PopupProvider)new PlSqlPopupProvider());
        }
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.m_breadcrumbsModel != null) {
            if (this.m_reqProc != null) {
                this.m_reqProc.cancel(this.getRequestProcessorKey());
                this.m_reqProc = null;
            }
            editor.removeCaretListener((CaretListener)this);
            this.breadcrumbs.removeBreadcrumbsListener((BreadcrumbsListener)this.m_listener);
            this.m_breadcrumbsModel.dispose();
            this.breadcrumbs.setModel(null);
            this.m_popupHandler.detatch();
            this.m_breadcrumbsModel = null;
            this.m_popupHandler = null;
            this.m_listener = null;
            super.deinstall(editor);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        BaseDBObjectTextNode node = this.getTextNode();
        if (this.m_reqProc == null) {
            this.m_reqProc = DBRequestProcessorFactory.getProcessor(node);
        }
        String string = this.getRequestProcessorKey();
        DBRequestProcessor dBRequestProcessor = this.m_reqProc;
        dBRequestProcessor.getClass();
        this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, node.getProvider(), UIBundle.format("PLSQL_BREADCRUMBS_TASK", node.getShortLabel())){
            {
                DBRequestProcessor dBRequestProcessor = x0;
                dBRequestProcessor.getClass();
                super(x1, x2);
            }

            @Override
            protected void doWork() {
                PlSqlBreadcrumbsPlugin.this.updateBreadCrumbs();
            }
        }, 1500);
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.editor);
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private void updateBreadCrumbs() {
        PlSqlFragment frag;
        PlSqlInterrogator pi;
        BaseDBObjectTextNode node;
        PlSqlSourceObject so;
        if (this.m_breadcrumbsModel != null && (so = (PlSqlSourceObject)(node = this.getTextNode()).getDBObject(false)) != null && (pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so)).getRoot() != null && this.editor != null && this.m_breadcrumbsModel != null && this.m_breadcrumbsModel.update(frag = pi.getFragmentAtOffset(this.editor.getCaretPosition()), this.editor.getCaretPosition())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel != null) {
                        PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel.fireBreadcrumbsUpdated();
                    }
                }
            });
        }
    }

    private class PlSqlBreadcrumbsListener
    implements BreadcrumbsListener<Integer> {
        private CodePeek _peek;

        private PlSqlBreadcrumbsListener() {
        }

        public void breadcrumbClicked(Breadcrumb<Integer> crumb) {
            if (crumb != null) {
                PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)crumb.getUserObject()).intValue());
                PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
            }
        }

        public void breadcrumbContextClicked(Breadcrumb<Integer> crumb, Point p) {
        }

        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
            String peekText;
            if (crumb == null) {
                return;
            }
            if (this._peek != null) {
                this._peek.hidePeek();
            }
            if ((peekText = ((PlSqlBreadcrumb)crumb).getPeekText()) == null) {
                return;
            }
            this._peek = PeekHelper.createCodePeek((JComponent)PlSqlBreadcrumbsPlugin.this.breadcrumbs, (String)PlSqlBreadcrumbsPlugin.this.getTextNode().getURL().toExternalForm(), (String)peekText, null, (Rectangle)peekLocation);
            this._peek.getGhostPointingPalette().setShowRectangle(false);
            this._peek.showPeek();
        }

        public void hideBreadcrumbPeek() {
            if (this._peek != null) {
                this._peek.hidePeek();
            }
        }

        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        }
    }

    private class PlSqlPopupProvider
    implements PopupProvider<Integer> {
        private PlSqlPopupProvider() {
        }

        public List<PopupItem> getPopupItems(Breadcrumb breadcrumb) {
            List<PopupItem> itemList = ((PlSqlBreadcrumb)breadcrumb).getPopupItems();
            return itemList;
        }

        public void itemSelected(PopupItem<Integer> popupItem) {
            PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)popupItem.getUserObject()).intValue());
            PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
        }
    }
}

