/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.editor.folding.DefaultFoldingBlock;

public class PlSqlFoldingBlock
extends DefaultFoldingBlock<PlSqlFoldingBlock, PlSqlFragment> {
    private boolean m_childrenLoaded;

    public void setChildrenLoaded(boolean loaded) {
        this.m_childrenLoaded = loaded;
    }

    public boolean isChildrenLoaded() {
        return this.m_childrenLoaded;
    }

    public PlSqlFoldingBlock(PlSqlFragment frag, String eol) {
        if (frag != null) {
            this.setUserObject(frag);
            this.setStartOffset(frag.getStartOffset());
            this.setEndOffset(this.getEnd(frag));
            String text = frag.getSource();
            int idx = text.indexOf(eol);
            if (idx > 0) {
                text = text.substring(0, idx) + "...";
            }
            this.setReplacementText(text);
        }
    }

    private int getEnd(PlSqlFragment frag) {
        int end = frag.getEndOffset();
        if (frag.getFragmentType() == PlSqlFragment.Type.IF) {
            PlSqlFragment par = frag.getParent();
            boolean found = false;
            for (PlSqlFragment sib : par.getChildren()) {
                if (sib == frag) {
                    found = true;
                    continue;
                }
                if (found && (sib.getFragmentType() == PlSqlFragment.Type.ELSIF || sib.getFragmentType() == PlSqlFragment.Type.ELSE)) {
                    end = sib.getEndOffset();
                    continue;
                }
                if (found) break;
            }
        }
        return end + 1;
    }
}

