/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ideimpl.db.ceditor.PlSqlFoldingBlock;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParserHelper;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel<PlSqlFoldingBlock> {
    private final String m_eol;
    private final BaseDBObjectTextNode m_node;
    private final Collection<Integer> m_collapsedOffsets = new HashSet<Integer>();
    private final CodeFoldingMargin m_margin;

    public PlSqlFoldingModel(BasicDocument document, BaseDBObjectTextNode node, CodeFoldingMargin margin) {
        super(document);
        TextBuffer buffer = document.getTextBuffer();
        this.m_eol = buffer.getEOLType();
        this.m_node = node;
        this.m_margin = margin;
        this.setRoot(new PlSqlFoldingBlock(null, null));
        this.resetRoot();
    }

    final void resetRoot() {
        Iterator i$;
        boolean skip;
        if (SwingUtilities.isEventDispatchThread()) {
            DBRequestProcessor reqProc = DBRequestProcessorFactory.getProcessor(this.m_node);
            String string = this.getRequestProcessorKey();
            DBRequestProcessor dBRequestProcessor = reqProc;
            dBRequestProcessor.getClass();
            reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, this.m_node.getProvider(), UIBundle.format("PLSQL_FOLDING_TASK", this.m_node.getShortLabel())){
                {
                    DBRequestProcessor dBRequestProcessor = x0;
                    dBRequestProcessor.getClass();
                    super(x1, x2);
                }

                @Override
                protected void doWork() throws DBException {
                    PlSqlFoldingModel.this.resetRoot();
                }
            }, 1500);
            return;
        }
        PlSqlSourceObject so = (PlSqlSourceObject)this.m_node.getDBObject(false);
        boolean bl = skip = so == null;
        if (!skip && this.getRoot() != null && (i$ = PlSqlParserHelper.getIssues((PlSqlSourceObject)so).iterator()).hasNext()) {
            Object x = i$.next();
            skip = true;
        }
        if (!skip) {
            DefaultFoldingBlock[] collapsed = this.getCollapsedBlocks();
            this.m_collapsedOffsets.clear();
            for (int i = 0; i < collapsed.length; ++i) {
                this.m_collapsedOffsets.add(collapsed[i].getStartOffset());
            }
            final PlSqlFragment root = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so).getRoot();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlSqlFoldingModel.this.setRoot(new PlSqlFoldingBlock(root, PlSqlFoldingModel.this.m_eol));
                }
            });
        }
    }

    public Iterator getChildren(PlSqlFoldingBlock block) {
        if (!block.isChildrenLoaded()) {
            PlSqlFragment frag = (PlSqlFragment)block.getUserObject();
            if (frag != null) {
                this.addChildren(block, frag);
            }
            block.setChildrenLoaded(true);
        }
        return block.getChildren();
    }

    private void addChildren(PlSqlFoldingBlock block, PlSqlFragment frag) {
        for (PlSqlFragment child : frag.getChildren()) {
            boolean addBlock = false;
            switch (child.getFragmentType()) {
                case PROCEDURE: 
                case FUNCTION: 
                case PACKAGE_SPEC: 
                case PACKAGE_BODY: 
                case TYPE_SPEC: 
                case TYPE_BODY: 
                case TRIGGER: 
                case IF: 
                case LOOP: 
                case FOR_LOOP: 
                case WHILE_LOOP: 
                case CASE: {
                    addBlock = true;
                    break;
                }
                case STATEMENT: {
                    PlSqlToken tk = child.getFirstToken();
                    if (!tk.matches("select") && !tk.matches("insert") && !tk.matches("update") && !tk.matches("delete")) break;
                    addBlock = true;
                    break;
                }
            }
            if (addBlock) {
                PlSqlFoldingBlock childBlock = new PlSqlFoldingBlock(child, this.m_eol);
                block.add((FoldingBlock)childBlock);
                if (!this.m_collapsedOffsets.contains(child.getStartOffset())) continue;
                this.m_margin.setExpansionState((Object)childBlock, false);
                continue;
            }
            this.addChildren(block, child);
        }
    }

    private String getRequestProcessorKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

