/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public class PlSqlGutterPlugin
implements EditorPlugin,
GutterColumnListener {
    private static final String COLUMN_NAME = "PLSQL_IMPLEMENTATIONS";
    private static final String RECALCULATE = "oracle.ideimpl.db.ceditor.PlSqlGutterPlugin.RECALCULATE";
    private final ViewListener m_viewListener = new ViewListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void viewActivated(ViewEvent e) {
            if (PlSqlGutterPlugin.access$000(PlSqlGutterPlugin.this) != null) {
                if (PlSqlGutterPlugin.access$100(PlSqlGutterPlugin.this)) {
                    node = PlSqlGutterPlugin.access$200(PlSqlGutterPlugin.this);
                    companionNode = DBObjectNodeUtil.getCompanionNode((PlSqlSchemaObject)node.getDBObject(), node.getProvider());
                    if (companionNode != null && companionNode.isOpen()) {
                        tb = null;
                        try {
                            tb = companionNode.acquireTextBuffer();
                            changeId = tb.getChangeId();
                            if (!ModelUtil.areDifferent((Object)PlSqlGutterPlugin.access$300(PlSqlGutterPlugin.this), (Object)changeId)) ** GOTO lbl21
                            PlSqlGutterPlugin.access$102(PlSqlGutterPlugin.this, false);
                            PlSqlGutterPlugin.access$302(PlSqlGutterPlugin.this, changeId);
                        }
                        finally {
                            companionNode.releaseTextBuffer();
                        }
                    } else {
                        PlSqlGutterPlugin.access$302(PlSqlGutterPlugin.this, null);
                    }
                }
lbl21:
                // 5 sources

                if (!PlSqlGutterPlugin.access$100(PlSqlGutterPlugin.this)) {
                    PlSqlGutterPlugin.this.propertyChange(new PropertyChangeEvent(this, "oracle.ideimpl.db.ceditor.PlSqlGutterPlugin.RECALCULATE", true, false));
                    PlSqlGutterPlugin.access$102(PlSqlGutterPlugin.this, true);
                }
            }
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
        }
    };
    private BasicEditorPane m_editor;
    private GutterColumn m_column;
    private boolean m_done;
    private Integer m_companionChangeID;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane editor) {
        if (PlSqlFeatures.isSupportedGutterNavigation()) {
            CodeEditor.getCodeEditor((BasicEditorPane)editor).addViewListener(this.m_viewListener);
            this.m_editor = editor;
            BaseDBObjectTextNode node = this.getTextNode();
            if (node != null && node.getProvider() != null && this.isSupportedType(node.getObjectType())) {
                CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)this.m_editor).getGutter();
                this.m_column = gutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.m_column != null) {
            CodeEditorGutter gutter;
            if (this.m_reqProc != null) {
                this.m_reqProc.cancel(this.getRequestProcessorKey());
                this.m_reqProc = null;
            }
            if ((gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter()) != null) {
                gutter.removeGutterColumn(this.m_column);
            }
            CodeEditor.getCodeEditor((BasicEditorPane)editor).removeViewListener(this.m_viewListener);
            this.m_column = null;
            this.m_editor = null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_column != null && (RECALCULATE.equals(evt.getPropertyName()) || "compoundEditInProgress".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getOldValue()) && Boolean.FALSE.equals(evt.getNewValue()))) {
            final BaseDBObjectTextNode node = this.getTextNode();
            if (this.m_reqProc == null) {
                this.m_reqProc = DBRequestProcessorFactory.getProcessor(node);
            }
            String string = this.getRequestProcessorKey();
            DBRequestProcessor dBRequestProcessor = this.m_reqProc;
            dBRequestProcessor.getClass();
            this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, node.getProvider(), UIBundle.format("PLSQL_GUTTER_TASK", node.getShortLabel())){
                {
                    DBRequestProcessor dBRequestProcessor = x0;
                    dBRequestProcessor.getClass();
                    super(x1, x2);
                }

                @Override
                protected void doWork() throws DBException {
                    PlSqlGutterPlugin.this.updateGutter();
                }

                @Override
                protected void cancelWork() {
                    node.cancelCurrentBuild();
                }
            }, 1500);
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        try {
            Integer startOffset = (Integer)gutterMark.getUserData();
            BaseDBObjectTextNode node = this.getTextNode();
            DBObjectProvider pro = node.getProvider();
            BaseDBObjectTextNode otherNode = DBObjectNodeUtil.getCompanionNode((PlSqlSchemaObject)node.getDBObject(), pro);
            Context c = Context.newIdeContext((Node)otherNode);
            OffsetNavigationPoint point = new OffsetNavigationPoint(c, startOffset.intValue(), 0);
            point.setPreferredEditorType(null);
            NavigationManager mgr = NavigationManager.getNavigationManager();
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Error in Go to Source for pl/sql", e);
        }
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        BaseDBObjectTextNode node = this.getTextNode();
        String otherType = PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)((PlSqlSchemaObject)node.getDBObject()));
        if (otherType != null) {
            return UIBundle.format("PLSQL_GUTTER_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(otherType));
        }
        return null;
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.m_editor);
    }

    private boolean isSupportedType(String type) {
        return "PACKAGE".equals(type) || "PACKAGE BODY".equals(type) || "TYPE".equals(type) || "TYPE BODY".equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGutter() {
        if (this.m_column != null) {
            BaseDBObjectTextNode node = this.getTextNode();
            DBObjectProvider pro = node.getProvider();
            String timestampKey = this.getClass().getSimpleName() + System.nanoTime();
            try {
                BaseDBObjectTextNode otherNode;
                PlSqlSourceObject otherObject;
                DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
                PlSqlSourceObject so = (PlSqlSourceObject)node.getDBObject(false);
                if (so instanceof PlSqlSchemaObject && (otherObject = (otherNode = DBObjectNodeUtil.getCompanionNode((PlSqlSchemaObject)so, pro)) != null ? (PlSqlSourceObject)otherNode.getDBObject(false) : null) != null) {
                    final List list = PlSqlUtil.getTopLevelPlSqlFragments((PlSqlSchemaObject)((PlSqlSchemaObject)so), (PlSqlSchemaObject)((PlSqlSchemaObject)otherObject));
                    final Icon icon = so instanceof PlSqlSchemaObjectSpec ? OracleIcons.getIcon((String)"gutter/down.png") : OracleIcons.getIcon((String)"gutter/up.png");
                    if (list != null) {
                        final PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PlSqlGutterPlugin.this.updateGutterUI(list, icon, pi);
                            }
                        });
                    }
                }
            }
            finally {
                DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
            }
        }
    }

    private void updateGutterUI(List<Pair<PlSqlFragment, PlSqlFragment>> list, Icon icon, PlSqlInterrogator pi) {
        if (this.m_column != null) {
            this.m_column.removeAllGutterMarks();
            for (Pair<PlSqlFragment, PlSqlFragment> pair : list) {
                int options;
                if (pair.getFirst() == null || pair.getSecond() == null) continue;
                PlSqlFragment frag1 = (PlSqlFragment)pair.getFirst();
                PlSqlFragment frag2 = (PlSqlFragment)pair.getSecond();
                int line = pi.getLineNumber(frag1.getStartOffset());
                GutterMark mark = this.m_column.addGutterMark(line, icon, null, 3000, options = 1);
                if (mark == null) continue;
                mark.setUserData((Object)frag2.getStartOffset());
            }
        }
    }

    static /* synthetic */ GutterColumn access$000(PlSqlGutterPlugin x0) {
        return x0.m_column;
    }

    static /* synthetic */ boolean access$100(PlSqlGutterPlugin x0) {
        return x0.m_done;
    }

    static /* synthetic */ BaseDBObjectTextNode access$200(PlSqlGutterPlugin x0) {
        return x0.getTextNode();
    }

    static /* synthetic */ Integer access$300(PlSqlGutterPlugin x0) {
        return x0.m_companionChangeID;
    }

    static /* synthetic */ boolean access$102(PlSqlGutterPlugin x0, boolean x1) {
        x0.m_done = x1;
        return x0.m_done;
    }

    static /* synthetic */ Integer access$302(PlSqlGutterPlugin x0, Integer x1) {
        x0.m_companionChangeID = x1;
        return x0.m_companionChangeID;
    }
}

