/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.ceditor.DBEditorConnectionProvider;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;

public class PlSqlQueryTester {
    private PlSqlQueryTester() {
    }

    public static boolean enableTestQuery(Context ctx) {
        return PlSqlQueryTester.getSelectTokens(ctx) != null;
    }

    public static void invokeTestQuery(final Context ctx) {
        if (SwingUtilities.isEventDispatchThread()) {
            Component parent = ctx.getView().getGUI();
            final ProgressBar pbar = new ProgressBar(parent, UIBundle.get("TEST_QUERY_ACTION"), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PlSqlQueryTester.invokeTestQueryImpl(ctx);
                    pbar.setDoneStatus();
                }
            };
            pbar.setRunnable(runnable);
            pbar.setCancelable(true);
            pbar.start(null, null, 1500);
        } else {
            PlSqlQueryTester.invokeTestQueryImpl(ctx);
        }
    }

    private static void invokeTestQueryImpl(final Context ctx) {
        PlSqlToken[] toks;
        SourceObject obj = ((BaseDBObjectTextNode)ctx.getNode()).getDBObject(true);
        final Database db = DBEditorConnectionProvider.getCurrentDatabase(ctx);
        if (obj != null && (toks = PlSqlQueryTester.getSelectTokens(ctx)) != null && toks.length == 4) {
            PlSqlToken startTk = toks[0];
            PlSqlToken endTk = toks[1];
            PlSqlToken intoStartTk = toks[2];
            PlSqlToken intoEndTk = toks[3];
            StringBuilder sb = new StringBuilder(startTk.getSource(false, endTk));
            boolean inInto = false;
            for (PlSqlToken tk = endTk; tk != startTk && !Thread.currentThread().isInterrupted(); tk = tk.getPrevCodeToken()) {
                DBObjectPlSqlFragment ref;
                if (tk == intoEndTk) {
                    inInto = true;
                    continue;
                }
                if (tk == intoStartTk) {
                    inInto = false;
                    sb.replace(intoStartTk.getStart() - startTk.getStart(), intoEndTk.getEnd() - startTk.getStart() + 1, "");
                    continue;
                }
                if (inInto || !((ref = ((DBObjectPlSqlFragment)obj).getReferenceAtOffset(tk.getStart())) instanceof PlSqlReference)) continue;
                try {
                    DBObject refObj = ((PlSqlReference)ref).getReferenceID().resolveID();
                    if (!(refObj instanceof PlSqlDatum)) continue;
                    PlSqlSourceObject otherSource = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)refObj);
                    PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)otherSource);
                    if (pi.isCurrentBuildCancelled()) break;
                    PlSqlSearch s = new PlSqlSearch("? constant ?% := <def {^{;}}...>;");
                    PlSqlToken tk2 = pi.getTokenAtOffset(((PlSqlDatum)refObj).getStartOffset().intValue());
                    if (s.matches(tk2)) {
                        sb.replace(tk.getStart() - startTk.getStart(), tk.getEnd() - startTk.getStart() + 1, s.getNamedMatch("def"));
                        continue;
                    }
                    if (tk.getPrevCodeToken().matches(".")) {
                        sb.replace(tk.getStart() - startTk.getStart() - 1, tk.getStart() - startTk.getStart(), "_");
                        continue;
                    }
                    sb.insert(tk.getStart() - startTk.getStart(), ":");
                    continue;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                String[] lines = sb.toString().split("\n");
                final StringBuilder sb2 = new StringBuilder();
                for (int i = 0; i < lines.length; ++i) {
                    String line;
                    if (lines[i] == null || (line = lines[i].trim()) == null || line.length() <= 0) continue;
                    sb2.append(line);
                    sb2.append("\n");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLQueryTester sqlTester = new SQLQueryTester(db);
                        sqlTester.showDialog(((CodeEditor)ctx.getView()).getDefaultFocusComponent(), sb2.toString());
                    }
                });
            }
        }
    }

    private static PlSqlToken[] getSelectTokens(Context ctx) {
        PlSqlToken[] ret = null;
        PlSqlSearch selSearch = new PlSqlSearch("{SELECT|WITH} {^;}...");
        PlSqlSearch selWithIntoSearch = new PlSqlSearch("{SELECT|WITH} {^INTO|BULK COLLECT INTO|;}... <into [[BULK COLLECT]INTO {^FROM}...]> {^;}...");
        if (ctx.getView() instanceof CodeEditor && ctx.getNode() instanceof DBObjectPlSqlNode) {
            CodeEditor ceditor = (CodeEditor)ctx.getView();
            BaseDBObjectTextNode node = (BaseDBObjectTextNode)ctx.getNode();
            PlSqlSourceObject obj = node != null ? (PlSqlSourceObject)node.getDBObject() : null;
            if (obj != null) {
                PlSqlToken startTk = null;
                PlSqlToken endTk = null;
                PlSqlToken intoStartTk = null;
                PlSqlToken intoEndTk = null;
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)obj);
                int pos = ceditor.getSelectionStart();
                PlSqlFragment frag = pi.getFragmentAtOffset(pos);
                if (ceditor.getSelectedText() != null) {
                    startTk = pi.getTokenAtOffset(ceditor.getSelectionStart());
                    if (!startTk.isCode()) {
                        startTk = startTk.getNextCodeToken();
                    }
                    if (!(endTk = pi.getTokenAtOffset(ceditor.getSelectionEnd())).isCode()) {
                        endTk = endTk.getPrevCodeToken();
                    }
                    if (endTk.matches(";")) {
                        endTk = endTk.getPrevCodeToken();
                    }
                    if (selWithIntoSearch.matches(startTk)) {
                        intoStartTk = selWithIntoSearch.getNamedMatchStartToken("into");
                        intoEndTk = selWithIntoSearch.getNamedMatchEndToken("into");
                    } else if (!selSearch.matches(startTk)) {
                        startTk = null;
                        endTk = null;
                    }
                } else if (frag != null) {
                    PlSqlSearch selInLoopSearch;
                    if (frag.getFragmentType() == PlSqlFragment.Type.STATEMENT) {
                        PlSqlSearch selInCursorSearch;
                        if (selWithIntoSearch.matches(frag.getFirstToken())) {
                            startTk = selWithIntoSearch.getStartToken();
                            endTk = selWithIntoSearch.getEndToken();
                            intoStartTk = selWithIntoSearch.getNamedMatchStartToken("into");
                            intoEndTk = selWithIntoSearch.getNamedMatchEndToken("into");
                        } else if (frag.getParent().getFragmentType() == PlSqlFragment.Type.CURSOR && (selInCursorSearch = new PlSqlSearch("CURSOR {^IS}... IS <select {SELECT|WITH} {^;}...>")).matches(frag.getParent().getFirstToken())) {
                            startTk = selInCursorSearch.getNamedMatchStartToken("select");
                            endTk = selInCursorSearch.getNamedMatchEndToken("select");
                        }
                    } else if (frag.getFragmentType() == PlSqlFragment.Type.FOR_LOOP && (selInLoopSearch = new PlSqlSearch("FOR ? IN <select (...)> LOOP")).matches(frag.getFirstToken())) {
                        startTk = selInLoopSearch.getNamedMatchStartToken("select").getNextCodeToken();
                        endTk = selInLoopSearch.getNamedMatchEndToken("select").getPrevCodeToken();
                    }
                }
                if (startTk != null && endTk != null) {
                    ret = new PlSqlToken[]{startTk, endTk, intoStartTk, intoEndTk};
                }
            }
        }
        return ret;
    }
}

