/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.util.Pair;

public final class PlSqlSpecAndBodySynchronizer {
    private PlSqlSpecAndBodySynchronizer() {
    }

    public static void launch(BaseDBObjectTextNode node, Integer offset) {
        PlSqlSpecAndBodySynchronizer.process(node, offset, null);
    }

    public static void add(BaseDBObjectTextNode node, PlSqlFragment frag) {
        PlSqlSpecAndBodySynchronizer.process(node, null, frag);
    }

    private static void process(final BaseDBObjectTextNode node, final Integer offset, final PlSqlFragment codeFrag) {
        if (SwingUtilities.isEventDispatchThread()) {
            final ProgressBar pbar = new ProgressBar((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_ACTION"), null, true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PlSqlSpecAndBodySynchronizer.process(node, offset, codeFrag);
                    pbar.setDoneStatus();
                }
            };
            pbar.setRunnable(runnable);
            pbar.setCancelable(true);
            pbar.start(null, null, 1500);
            return;
        }
        final DBObjectProvider pro = node.getProvider();
        final PlSqlSourceObject so = (PlSqlSourceObject)node.getDBObject(false);
        boolean useDialog = true;
        if (so instanceof PlSqlSchemaObject) {
            PlSqlInterrogator pi;
            Integer bodyOffset;
            BaseDBObjectTextNode bodyNode;
            PlSqlSchemaObjectBody body;
            Integer specOffset;
            BaseDBObjectTextNode specNode;
            PlSqlSchemaObjectSpec spec;
            BaseDBObjectTextNode otherNode;
            PlSqlSchemaObject otherObject = PlSqlUtil.getCompanionObject((PlSqlSchemaObject)((PlSqlSchemaObject)so), (DBObjectProvider)pro);
            if (otherObject != null) {
                URL url = DBURLFactory.getURL(pro, (SystemObject)otherObject);
                Node n = null;
                try {
                    n = NodeFactory.findOrCreate((URL)url);
                }
                catch (Exception e) {
                    // empty catch block
                }
                otherNode = DBObjectNodeUtil.getCompanionNode((PlSqlSchemaObject)so, pro);
                otherObject = (PlSqlSourceObject)otherNode.getDBObject(false);
            } else {
                otherNode = null;
                if (so instanceof PlSqlSchemaObjectSpec) {
                    useDialog = false;
                } else {
                    DBLog.getLogger(PlSqlSpecAndBodySynchronizer.class).warning("Body with no spec found.  Not suppoted.");
                    return;
                }
            }
            if (so instanceof PlSqlSchemaObjectSpec) {
                spec = (PlSqlSchemaObjectSpec)so;
                specNode = node;
                specOffset = offset;
                body = (PlSqlSchemaObjectBody)otherObject;
                bodyNode = otherNode;
                bodyOffset = null;
            } else {
                spec = (PlSqlSchemaObjectSpec)otherObject;
                specNode = otherNode;
                specOffset = null;
                body = (PlSqlSchemaObjectBody)so;
                bodyNode = node;
                bodyOffset = offset;
            }
            boolean bodyWrapped = body != null && !Thread.currentThread().isInterrupted() ? (pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)body)) != null && pi.isWrapped() : false;
            PlSqlSchemaObject companionObject = otherObject;
            boolean useDialog2 = useDialog;
            if (!Thread.currentThread().isInterrupted()) {
                SwingUtilities.invokeLater(new Runnable((PlSqlSourceObject)companionObject, codeFrag, otherNode, specNode, bodyNode, spec, body, specOffset, bodyOffset, bodyWrapped, useDialog2){
                    final /* synthetic */ PlSqlSourceObject val$companionObject;
                    final /* synthetic */ PlSqlFragment val$codeFrag;
                    final /* synthetic */ BaseDBObjectTextNode val$otherNode;
                    final /* synthetic */ BaseDBObjectTextNode val$specNode;
                    final /* synthetic */ BaseDBObjectTextNode val$bodyNode;
                    final /* synthetic */ PlSqlSchemaObjectSpec val$spec;
                    final /* synthetic */ PlSqlSchemaObjectBody val$body;
                    final /* synthetic */ Integer val$specOffset;
                    final /* synthetic */ Integer val$bodyOffset;
                    final /* synthetic */ boolean val$bodyWrapped;
                    final /* synthetic */ boolean val$useDialog2;
                    {
                        this.val$companionObject = plSqlSourceObject2;
                        this.val$codeFrag = plSqlFragment;
                        this.val$otherNode = baseDBObjectTextNode;
                        this.val$specNode = baseDBObjectTextNode2;
                        this.val$bodyNode = baseDBObjectTextNode3;
                        this.val$spec = plSqlSchemaObjectSpec;
                        this.val$body = plSqlSchemaObjectBody;
                        this.val$specOffset = n;
                        this.val$bodyOffset = n2;
                        this.val$bodyWrapped = bl;
                        this.val$useDialog2 = bl2;
                    }

                    @Override
                    public void run() {
                        PlSqlSpecAndBodySynchronizer.updateUI(pro, so, this.val$companionObject, this.val$codeFrag, this.val$otherNode, this.val$specNode, this.val$bodyNode, this.val$spec, this.val$body, this.val$specOffset, this.val$bodyOffset, this.val$bodyWrapped, this.val$useDialog2);
                    }
                });
            }
        }
    }

    private static void updateUI(DBObjectProvider pro, PlSqlSourceObject so, PlSqlSourceObject companionObject, PlSqlFragment codeFrag, BaseDBObjectTextNode otherNode, final BaseDBObjectTextNode specNode, final BaseDBObjectTextNode bodyNode, final PlSqlSchemaObjectSpec spec, final PlSqlSchemaObjectBody body, final Integer specOffset, final Integer bodyOffset, boolean bodyWrapped, boolean useDialog) {
        if (bodyWrapped) {
            DBMessageDialog.showErrorDialog(UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_BODY_WRAPPED"), spec, Level.INFO, UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), null);
        } else if (body == null && !spec.canHaveBody()) {
            String message = spec instanceof Type && "COLLECTION".equals(((Type)spec).getTypeCode()) ? UIBundle.get("FIND_OR_CREATE_BODY_COLLECTION_ERROR") : UIBundle.format("FIND_OR_CREATE_BODY_OTHER_ERROR", spec.getType(), spec.getName());
            DBMessageDialog.showErrorDialog(message, spec, Level.INFO, UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), null);
        } else if (codeFrag != null && otherNode != null) {
            StringBuilder sb = PlSqlSpecAndBodySynchronizer.getBuilder(Collections.singletonList(codeFrag), (PlSqlSchemaObject)so);
            PlSqlSpecAndBodySynchronizer.insertIntoBuffer(sb, otherNode, (PlSqlSchemaObject)companionObject, null);
        } else if (!useDialog) {
            PlSqlSpecAndBodySynchronizer.createDefaultBody(pro, spec);
        } else {
            final SyncPanel panel = new SyncPanel(pro, spec, body);
            panel.setHelpID("f1_synchspecbody_html");
            TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("SYNCHRONIZE_SPEC_AND_BODY_TITLE"), (Traversable)panel, new Namespace());
            JEWTDialog dialog = launcher.initDialog();
            dialog.setContent((Component)((Object)panel));
            dialog.setPreferredSize(400, 300);
            dialog.setResizable(true);
            dialog.setName("PlSqlSpecAndBodySynchronizer");
            VetoableChangeListener list = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        StringBuilder bodySb = PlSqlSpecAndBodySynchronizer.getBuilder(panel.getAddToBodyFragments(), (PlSqlSchemaObject)spec);
                        StringBuilder specSb = PlSqlSpecAndBodySynchronizer.getBuilder(panel.getAddToSpecFragments(), (PlSqlSchemaObject)body);
                        if (bodySb.length() > 0) {
                            PlSqlSpecAndBodySynchronizer.insertIntoBuffer(bodySb, bodyNode, (PlSqlSchemaObject)body, bodyOffset);
                        }
                        if (specSb.length() > 0) {
                            PlSqlSpecAndBodySynchronizer.insertIntoBuffer(specSb, specNode, (PlSqlSchemaObject)spec, specOffset);
                        }
                    }
                }
            };
            dialog.addVetoableChangeListener(list);
            launcher.showDialog();
        }
    }

    private static StringBuilder getBuilder(List<PlSqlFragment> frags, PlSqlSchemaObject source) {
        StringBuilder sb = new StringBuilder();
        Object subProgramSearch = source instanceof PackageBody ? new PlSqlSearch("<type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>") : (source instanceof TypeBody ? new PlSqlSearch("[overriding] [{map|order}] {member|static} [[final][instantiable]constructor] <type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype {SELF AS RESULT|?%}>]>") : null);
        if (frags.size() > 0) {
            PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)source);
            for (PlSqlFragment frag : frags) {
                if (source instanceof PlSqlSchemaObjectSpec) {
                    sb.append(PlSqlUtil.getDefaultImplementation((PlSqlSourceObject)source, (PlSqlFragment)frag));
                    continue;
                }
                if (subProgramSearch == null || !subProgramSearch.matches(frag.getFirstToken(), frag.getLastToken())) continue;
                sb.append("  ");
                sb.append(subProgramSearch.getStartToken().getSource(false, subProgramSearch.getEndToken()));
                sb.append(";\n\n");
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoBuffer(StringBuilder sb, BaseDBObjectTextNode node, PlSqlSchemaObject target, Integer offset) {
        PlSqlToken tk;
        PlSqlFragment[] kids;
        PlSqlFragment frag;
        PlSqlInterrogator pi2 = PlSqlInterrogatorFactory.getInterrogator((SourceObject)target);
        if (offset != null && ((frag = pi2.getFragmentAtOffset(offset.intValue())) == null || frag.getParent() == null || frag.getParent().getFragmentType() != PlSqlFragment.Type.ROOT)) {
            offset = null;
        }
        if (offset == null && (kids = pi2.getRoot().getChildren()) != null && kids.length == 1 && kids[0].getFragmentType() == PlSqlFragment.Type.PACKAGE_BODY && (kids = kids[0].getChildren()) != null && kids.length > 0 && (tk = kids[kids.length - 1].getFirstToken()).matches("begin")) {
            offset = tk.getStart();
        }
        if (offset == null) {
            PlSqlToken endTk = pi2.getRoot().getLastToken();
            if (!endTk.isCode()) {
                endTk = endTk.getPrevCodeToken();
            }
            tk = endTk;
            for (int i = 0; i < 3; ++i) {
                if (tk.matches("end")) {
                    endTk = tk;
                    break;
                }
                tk = tk.getPrevCodeToken();
            }
            offset = endTk.getStart();
        }
        try {
            Context context = Context.newIdeContext((Node)node);
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.openEditor(openEditorOptions);
            TextBuffer tb = node.acquireTextBuffer();
            int line = tb.getLineMap().getLineFromOffset(offset.intValue());
            int insertAt = tb.getLineMap().getLineStartOffset(line);
            tb.beginEdit();
            tb.insert(insertAt, sb.toString().toCharArray());
            tb.endEdit();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, insertAt, 0);
            point.setPreferredEditorType(null);
            NavigationManager mgr = NavigationManager.getNavigationManager();
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
        }
        finally {
            node.releaseTextBuffer();
        }
    }

    private static void createDefaultBody(DBObjectProvider pro, PlSqlSchemaObjectSpec spec) {
        PlSqlSchemaObjectBody body = spec instanceof Package ? (PlSqlSchemaObjectBody)pro.getObjectFactory().newObject(PackageBody.class) : (PlSqlSchemaObjectBody)pro.getObjectFactory().newObject(TypeBody.class);
        body.setSpecID(spec.getID());
        String bodySrc = PlSqlUtil.getDefaultBodyForSpec((PlSqlSourceObject)spec, (String)pro.getExternalName(spec.getName()));
        body.setSource(bodySrc);
        body.setName(spec.getName());
        body.setSchema(spec.getSchema());
        DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((SchemaObject)body, pro);
        if (fac != null) {
            DBEditorConfig config = DBEditorConfig.newCreateConfig(pro, (DBObject)body);
            fac.launchDialog(config);
        }
    }

    private static class SyncPanel
    extends DefaultTraversablePanel {
        private final LocalTreeNode m_rootNode = new LocalTreeNode("root");
        private LocalTreeNode m_addToBodyNode = null;
        private LocalTreeNode m_addToSpecNode = null;

        public SyncPanel(DBObjectProvider pro, PlSqlSchemaObjectSpec spec, PlSqlSchemaObjectBody body) {
            List specList = PlSqlUtil.getTopLevelPlSqlFragments((PlSqlSchemaObject)spec, (PlSqlSchemaObject)body);
            List bodyList = body != null ? PlSqlUtil.getTopLevelPlSqlFragments((PlSqlSchemaObject)body, (PlSqlSchemaObject)spec) : null;
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)((Object)this.m_rootNode));
            for (Pair pair : specList) {
                if (pair.getSecond() != null) continue;
                LocalTreeNode addToBodyNode = this.getAddToBodyNode(spec);
                LocalTreeNode node = new LocalTreeNode(pair.getFirst());
                node.setNodeState(TriStateNode.NodeState.YES);
                addToBodyNode.setNodeState(TriStateNode.NodeState.YES);
                addToBodyNode.add((MutableTreeNode)((Object)node));
            }
            if (bodyList != null) {
                for (Pair pair : bodyList) {
                    if (pair.getSecond() != null) continue;
                    LocalTreeNode node = new LocalTreeNode(pair.getFirst());
                    LocalTreeNode addToSpecNode = this.getAddToSpecNode(body);
                    addToSpecNode.add((MutableTreeNode)((Object)node));
                }
            }
            CheckboxTree tree = new CheckboxTree((TreeModel)model);
            tree.setRootVisible(false);
            for (int row = 0; tree.getRowCount() > row; ++row) {
                tree.expandRow(row);
            }
            DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)((Object)this));
            layout.add(new JScrollPane((Component)tree));
            layout.layout();
        }

        public List<PlSqlFragment> getAddToSpecFragments() {
            ArrayList<PlSqlFragment> list = new ArrayList<PlSqlFragment>();
            this.addSelectedFragments(list, this.m_addToSpecNode);
            return list;
        }

        public List<PlSqlFragment> getAddToBodyFragments() {
            ArrayList<PlSqlFragment> list = new ArrayList<PlSqlFragment>();
            this.addSelectedFragments(list, this.m_addToBodyNode);
            return list;
        }

        private LocalTreeNode getAddToBodyNode(PlSqlSchemaObjectSpec spec) {
            if (this.m_addToBodyNode == null && spec != null) {
                this.m_addToBodyNode = new LocalTreeNode(spec);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToBodyNode));
            }
            return this.m_addToBodyNode;
        }

        private LocalTreeNode getAddToSpecNode(PlSqlSchemaObjectBody body) {
            if (this.m_addToSpecNode == null && body != null) {
                this.m_addToSpecNode = new LocalTreeNode(body);
                this.m_rootNode.add((MutableTreeNode)((Object)this.m_addToSpecNode));
            }
            return this.m_addToSpecNode;
        }

        private void addSelectedFragments(List<PlSqlFragment> list, LocalTreeNode node) {
            if (node != null && !node.isLeaf()) {
                for (LocalTreeNode child = (LocalTreeNode)((Object)node.getFirstChild()); child != null; child = (LocalTreeNode)((Object)child.getNextSibling())) {
                    if (!TriStateNode.NodeState.YES.equals((Object)child.getNodeState())) continue;
                    list.add((PlSqlFragment)child.getUserObject());
                }
            }
        }

        private static class LocalTreeNode
        extends TriStateNode {
            public LocalTreeNode(Object userData) {
                super(userData);
            }

            public Icon getIcon() {
                Icon ret = null;
                Object obj = this.getUserObject();
                if (obj instanceof DBObject) {
                    ret = DBTypeDisplayRegistry.getNodeIcon((DBObject)obj);
                } else if (obj instanceof PlSqlFragment) {
                    PlSqlFragment.Type fragType = ((PlSqlFragment)obj).getFragmentType();
                    if (fragType == PlSqlFragment.Type.FUNCTION || fragType == PlSqlFragment.Type.FUNCTION_FD) {
                        ret = DBTypeDisplayRegistry.getNodeIcon("FUNCTION");
                    } else if (fragType == PlSqlFragment.Type.PROCEDURE || fragType == PlSqlFragment.Type.PROCEDURE_FD) {
                        ret = DBTypeDisplayRegistry.getNodeIcon("PROCEDURE");
                    } else if (fragType == PlSqlFragment.Type.CURSOR) {
                        ret = OracleIcons.getIcon((String)"selection.png");
                    }
                }
                return ret;
            }

            public String getLabel() {
                Object obj = this.getUserObject();
                if (obj instanceof PlSqlSchemaObject) {
                    String type = "PACKAGE BODY";
                    if (obj instanceof PackageBody) {
                        type = "PACKAGE";
                    } else if (obj instanceof Type) {
                        type = "TYPE BODY";
                    } else if (obj instanceof Type) {
                        type = "TYPE BODY";
                    }
                    return UIBundle.format("SYNCHRONIZE_SPEC_AND_BODY_ADD_TO", DBTypeDisplayRegistry.getSingularDisplayName(type));
                }
                if (obj instanceof PlSqlFragment) {
                    return PlSqlUtil.getSignature((PlSqlFragment)((PlSqlFragment)obj));
                }
                return super.getLabel();
            }
        }
    }
}

