/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.model.Node;
import oracle.ide.util.Namespace;

public abstract class AsynchronousComponentWrapper<T extends Component>
extends ComponentWrapper<T> {
    private boolean m_dirty;

    public AsynchronousComponentWrapper(T component) {
        super(component);
    }

    public void writeUpdates() {
        if (this.m_dirty) {
            this.fireChangeEvent();
            this.m_dirty = false;
        }
    }

    protected void cancelUpdates() {
        if (this.m_dirty) {
            this.m_dirty = false;
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getFocusComponents()[0];
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.getActiveComponent()};
    }

    @Override
    protected void initialiseComponentListener() {
        Component[] comps = this.getFocusComponents();
        if (comps != null) {
            for (Component comp : comps) {
                comp.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        AsynchronousComponentWrapper.this.gainingFocus();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        AsynchronousComponentWrapper.this.losingFocus();
                        AsynchronousComponentWrapper.this.writeUpdates();
                    }
                });
            }
        }
    }

    protected final void markDirty() {
        Namespace parent;
        this.m_dirty = true;
        Namespace dataContext = this.getComponentContext().getDataContext();
        while ((parent = dataContext.getParent()) != null && parent != dataContext) {
            dataContext = parent;
        }
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != this) {
            if (current != null) {
                current.writeUpdates();
            }
            dataContext.put(AsynchronousComponentWrapper.class.getName(), (Object)this);
            if (this.getComponentContext().isInFlatEditor()) {
                Node node;
                Context context = (Context)dataContext.find(Context.class);
                Node node2 = node = context == null ? null : context.getNode();
                if (node != null) {
                    node.markDirty(true);
                }
            }
        }
    }

    protected void gainingFocus() {
    }

    protected void losingFocus() {
    }

    public static void commitCurrentWrapper(Namespace dataContext, boolean exit) {
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != null) {
            current.writeUpdates();
            if (exit) {
                dataContext.remove(AsynchronousComponentWrapper.class.getName());
            }
        }
    }

    public static void cancelCurrentWrapper(Namespace dataContext) {
        AsynchronousComponentWrapper current = (AsynchronousComponentWrapper)dataContext.find(AsynchronousComponentWrapper.class);
        if (current != null) {
            current.cancelUpdates();
        }
    }

    protected boolean isDirty() {
        return this.m_dirty;
    }

    protected void processUpdate(DocumentEvent evt) {
        if (evt.getLength() != 0) {
            this.markDirty();
        }
    }

    protected class AsynchronousDocumentListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AsynchronousComponentWrapper.this.processUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AsynchronousComponentWrapper.this.processUpdate(e);
        }
    }
}

