/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationException;

public abstract class DelegateComponentWrapper
extends ComponentWrapper<JPanel> {
    private final Map<String, ComponentWrapper> m_wrappers = new HashMap<String, ComponentWrapper>();
    private final CardLayout m_layout = new CardLayout();
    private String m_currentKey;

    public DelegateComponentWrapper() {
        super(new JPanel());
        ((JPanel)this.getActiveComponent()).setLayout(this.m_layout);
    }

    protected final void registerDelegateWrapper(String key, ComponentWrapper delegate) {
        ComponentContext context = this.getComponentContext();
        if (context == null) {
            throw new IllegalStateException("Cannot call registerDelegateWrapper before initialise.");
        }
        this.m_wrappers.put(key, delegate);
        delegate.initialise(context);
        ((JPanel)this.getActiveComponent()).add(delegate.getComponent(), key);
    }

    protected abstract void registerDelegateWrappers();

    protected abstract String getDelegateKey();

    protected final ComponentWrapper getDelegate(String key) {
        return this.m_wrappers.get(key);
    }

    protected final ComponentWrapper getDelegate() {
        String key = this.getDelegateKey();
        ComponentWrapper retval = this.getDelegate(key);
        if (!key.equals(this.m_currentKey)) {
            if (this.m_currentKey != null) {
                ComponentWrapper old = this.getDelegate(this.m_currentKey);
                old.setActive(false);
            }
            this.m_currentKey = key;
            JPanel panel = (JPanel)this.getActiveComponent();
            this.m_layout.show(panel, key);
            retval.setActive(this.isActive());
        }
        return retval;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getDelegate().getDefaultFocusComponent();
    }

    @Override
    public void setValidationStatus(Collection<ValidationException> ves, DBValidationHandler handler) {
        this.getDelegate().setValidationStatus(ves, handler);
    }

    @Override
    public Object getPropertyValue() {
        return this.getDelegate().getPropertyValue();
    }

    @Override
    public void setPropertyValue(Object val) {
        ComponentWrapper delegate = this.getDelegate();
        if (delegate.isActive()) {
            delegate.setPropertyValue(val);
        }
    }

    @Override
    protected void initialiseComponentListener() {
    }

    @Override
    protected final void initialiseComponent() {
        this.registerDelegateWrappers();
    }

    @Override
    public void processComponent(boolean editable, boolean allowRecreate) {
        super.processComponent(editable, allowRecreate);
        for (ComponentWrapper wrapper : this.m_wrappers.values()) {
            wrapper.processComponent(editable, allowRecreate);
        }
        this.getDelegate();
    }

    @Override
    public boolean refreshObject(DBObject refreshedObject) {
        boolean retval = super.refreshObject(refreshedObject);
        for (ComponentWrapper wrapper : this.m_wrappers.values()) {
            if (!wrapper.refreshObject(refreshedObject)) continue;
            retval = true;
        }
        this.getDelegate();
        return retval;
    }

    @Override
    protected void setActiveImpl(boolean active) {
        this.getDelegate().setActive(active);
    }
}

