/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.PropertyDisplayListCellRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;

public class EnumPropertyComponentWrapper
extends ComponentWrapper<JComboBox> {
    public EnumPropertyComponentWrapper() {
        super(new JComboBox());
    }

    @Override
    public void setPropertyValue(Object value) {
        JComboBox comp;
        ComboBoxModel model;
        if (value == null) {
            value = PropertyDisplayListCellRenderer.NULL_ENTRY;
        }
        if ((model = (comp = (JComboBox)this.getActiveComponent()).getModel()) instanceof DefaultComboBoxModel && ((DefaultComboBoxModel)model).getIndexOf(value) == -1) {
            ((DefaultComboBoxModel)model).insertElementAt(value, 0);
        }
        comp.setSelectedItem(value);
    }

    @Override
    public Object getPropertyValue() {
        Object retval = ((JComboBox)this.getActiveComponent()).getSelectedItem();
        if (retval == PropertyDisplayListCellRenderer.NULL_ENTRY) {
            retval = null;
        }
        return retval;
    }

    @Override
    protected void initialiseComponent() {
        ListCellRenderer renderer = this.getRenderer();
        if (renderer != null) {
            ((JComboBox)this.getActiveComponent()).setRenderer(renderer);
        }
        this.setAllowableValues();
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addItemListener(this.createItemListener());
    }

    @Override
    public void processComponent(boolean editable, boolean allowRecreate) {
        super.processComponent(editable, allowRecreate);
        this.setAllowableValues();
    }

    @Override
    public boolean refreshObject(DBObject refreshedObject) {
        this.setAllowableValues();
        return super.refreshObject(refreshedObject);
    }

    protected ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumPropertyComponentWrapper.this.fireChangeEvent();
                }
            }
        };
    }

    protected ListCellRenderer getRenderer() {
        return new PropertyDisplayListCellRenderer(Property.getLastProperty((String)this.getPropertyName()));
    }

    private void setAllowableValues() {
        Collection allowedValues = this.getAllowedValues();
        JComboBox combo = (JComboBox)this.getActiveComponent();
        Object selected = combo.getSelectedItem();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        if (allowedValues != null) {
            for (Object value : allowedValues) {
                if (value == null) {
                    value = PropertyDisplayListCellRenderer.NULL_ENTRY;
                }
                model.addElement(value);
            }
        }
        if (selected != null && model.getIndexOf(selected) != -1) {
            model.setSelectedItem(selected);
        }
        combo.setModel(model);
    }

    protected Collection getAllowedValues() {
        PropertyManager mgr = this.getProvider().getPropertyManager();
        return mgr.getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), this.getPropertyName());
    }
}

