/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class IndexObjectComponentWrapper
extends AsynchronousComponentWrapper<JComboBox> {
    private final Document m_document;
    private final DocumentListener m_docListener;

    public IndexObjectComponentWrapper() {
        super(new CustomCombo());
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.setParent(this);
        comp.setEditable(true);
        Component editor = comp.getEditor().getEditorComponent();
        if (editor instanceof JTextField) {
            this.m_document = ((JTextField)editor).getDocument();
            this.m_docListener = new AsynchronousComponentWrapper.AsynchronousDocumentListener();
        } else {
            this.m_document = null;
            this.m_docListener = null;
        }
        this.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndexObject io;
                SQLFragment expr;
                if ("value".equals(evt.getPropertyName()) && !IndexObjectComponentWrapper.this.getComponentContext().isInFlatEditor() && (expr = (io = (IndexObject)IndexObjectComponentWrapper.this.getUpdatedObject()).getExpression()) != null) {
                    io.setExpressionSource(null);
                    io.setExpression(expr);
                }
            }
        });
    }

    @Override
    protected void losingFocus() {
        super.losingFocus();
        this.enableDocListener(false);
    }

    @Override
    protected void gainingFocus() {
        super.gainingFocus();
        this.enableDocListener(true);
    }

    private void enableDocListener(boolean enable) {
        if (this.m_document != null && this.m_docListener != null) {
            this.m_document.removeDocumentListener(this.m_docListener);
            if (enable) {
                this.m_document.addDocumentListener(this.m_docListener);
            }
        }
    }

    @Override
    public Object getPropertyValue() {
        return ((JComboBox)this.getActiveComponent()).getEditor().getItem();
    }

    @Override
    public void setPropertyValue(Object val) {
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.reset();
        this.enableDocListener(false);
        ((JComboBox)this.getActiveComponent()).setSelectedItem((String)val);
        this.enableDocListener(true);
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexObjectComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    private static class CustomCombo
    extends AbstractLazyCombo {
        private ComponentWrapper m_parent = null;

        private CustomCombo() {
        }

        @Override
        public void setName(String name) {
            super.setName(name + "-combo");
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().setName(name);
            }
        }

        private void setParent(ComponentWrapper parent) {
            this.m_parent = parent;
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.m_parent != null) {
                Table table;
                ComponentContext ctx = this.m_parent.getComponentContext();
                DBEditorConfig indexEditorConfig = ctx.getEditorConfig();
                DBObjectProvider pro = ctx.getProvider();
                Index index = (Index)indexEditorConfig.getUpdatedObject();
                if (index != null && (table = index.getTable()) != null) {
                    for (Column col : table.getColumns()) {
                        ret.add(pro.getExternalName(col.getName(), "COLUMN"));
                    }
                }
            }
            return ret;
        }
    }
}

