/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComboBox;
import oracle.ide.Ide;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.dialogs.MessageDialog;

public class PartitionTypePropertyWrapper
extends EnumPropertyComponentWrapper {
    @Override
    protected ItemListener createItemListener() {
        return new TypeComboListener();
    }

    private static final void setPartitionType(DBObject object, OracleTablePartitions partitionsOfObject, String prop, Object type) {
        if (type instanceof OracleTablePartitions.PartitionType) {
            OracleTablePartitions.ObjectType objectType = object instanceof Table ? OracleTablePartitions.ObjectType.PARTITION : OracleTablePartitions.ObjectType.SUBPARTITION;
            OracleTablePartitions otp = new OracleTablePartitions((OracleTablePartitions.PartitionType)type, objectType);
            object.setProperty(prop, (Object)otp);
            if (object instanceof Table) {
                object.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
            }
            if (object instanceof OracleTablePartitions) {
                OracleTablePartitions partitioning = (OracleTablePartitions)object;
                for (TablePartition partition : partitioning.getPartitions()) {
                    partition.setPartitionLevelSubpartitions(null);
                }
            }
        } else {
            if (partitionsOfObject != null) {
                partitionsOfObject.setPartitions(new TablePartition[0]);
            }
            object.setProperty(prop, null);
            if ("subpartitionModel".equals(prop) && object instanceof OracleTablePartitions) {
                TablePartition[] partitions;
                for (TablePartition tp : partitions = ((OracleTablePartitions)object).getPartitions()) {
                    tp.setPartitionLevelSubpartitions(null);
                }
            }
            if (object instanceof Table) {
                object.setProperty("PARTITIONED TABLE", null);
            }
        }
    }

    @Override
    protected Collection getAllowedValues() {
        ArrayList retval = new ArrayList();
        retval.add(null);
        retval.addAll(super.getAllowedValues());
        return retval;
    }

    private class TypeComboListener
    implements ItemListener {
        private boolean m_active = true;
        private Object m_previous = null;

        private TypeComboListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.m_active) {
                return;
            }
            if (e.getStateChange() == 2) {
                this.m_previous = e.getItem();
            } else if (e.getStateChange() == 1 && PartitionTypePropertyWrapper.this.isActive() && PartitionTypePropertyWrapper.this.getUpdatedObject() != null) {
                String prop;
                OracleTablePartitions otp;
                DBObject owner;
                DBObject parent = PartitionTypePropertyWrapper.this.getUpdatedObject();
                OracleTablePartitions partitioning = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
                boolean warn = false;
                if (!PartitionProperty.SUBPARTITION_TYPE.equals(PartitionTypePropertyWrapper.this.getPropertyName())) {
                    owner = parent;
                    otp = partitioning;
                    prop = "OracleTablePartitions";
                    warn = otp != null && otp.getPartitions() != null && otp.getPartitions().length > 0;
                } else if (partitioning != null) {
                    owner = partitioning;
                    prop = "subpartitionModel";
                    otp = (OracleTablePartitions)partitioning.getProperty(prop);
                    boolean bl = warn = otp != null && otp.getPartitions() != null && otp.getPartitions().length > 0;
                    if (!warn && partitioning.getPartitions() != null) {
                        for (TablePartition partition : partitioning.getPartitions()) {
                            OracleTablePartitions subs = partition.getPartitionLevelSubpartitions();
                            if (subs == null || subs.getPartitions() == null || subs.getPartitions().length <= 0) continue;
                            warn = true;
                            break;
                        }
                    }
                } else {
                    owner = null;
                    otp = null;
                    prop = null;
                }
                boolean stopIt = false;
                if (warn) {
                    boolean bl = stopIt = !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIBundle.get("PARTITION_CHANGE_WARNING_TEXT"), (String)UIBundle.get("PARTITION_CHANGE_WARNING_TITLE"), null);
                }
                if (stopIt) {
                    try {
                        this.m_active = false;
                        ((JComboBox)PartitionTypePropertyWrapper.this.getActiveComponent()).setSelectedItem(this.m_previous);
                    }
                    finally {
                        this.m_active = true;
                    }
                } else if (owner != null) {
                    PartitionTypePropertyWrapper.setPartitionType(owner, otp, prop, e.getItem());
                    PartitionTypePropertyWrapper.this.fireChangeEvent();
                }
            }
        }
    }
}

