/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.Arrays;
import java.util.Collection;
import oracle.ideimpl.db.components.InternalChildIdArrayWrapper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.Type;

public class TablePartitionColumnsWrapper
extends InternalChildIdArrayWrapper {
    private static final Collection<String> BANNED_TYPE_NAMES = Arrays.asList("LONG", "LONG RAW", "LONG VARCHAR", "BLOB", "CLOB", "NCLOB", "ROWID", "UROWID");

    public TablePartitionColumnsWrapper() {
        super(Column.class, new ColumnFilter(), true);
    }

    private static class ColumnFilter
    implements DBObjectFilter<Column> {
        ColumnFilter() {
        }

        public boolean accept(Column col) {
            DataType dt = null;
            try {
                dt = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).severe("Unable to resolve datatype of column: " + col);
                return false;
            }
            if (dt != null) {
                String name = dt.getName();
                if (dt instanceof Type || BANNED_TYPE_NAMES.contains(name)) {
                    return false;
                }
            }
            return true;
        }
    }
}

