/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractLazyCombo
extends JComboBox
implements ListCellRenderer {
    private final Object NULL_OBJ = new Object();
    private final DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private boolean m_gotModel = false;
    private boolean m_inMenuWillBecomeVisible = false;
    private boolean m_menuVisible = false;
    private boolean m_settingModel = false;

    public AbstractLazyCombo() {
        this.setRenderer(this);
        this.setEditor(new CustomComboBoxEditor());
        this.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (!AbstractLazyCombo.this.m_gotModel && !AbstractLazyCombo.this.m_inMenuWillBecomeVisible) {
                    AbstractLazyCombo.this.loadModel();
                    JComboBox list = (JComboBox)e.getSource();
                    AbstractLazyCombo.this.m_inMenuWillBecomeVisible = true;
                    try {
                        list.getUI().setPopupVisible(list, true);
                    }
                    finally {
                        AbstractLazyCombo.this.m_inMenuWillBecomeVisible = false;
                    }
                }
                AbstractLazyCombo.this.m_menuVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }
        });
    }

    protected abstract List getModelEntries();

    public String getNullText() {
        return null;
    }

    protected Icon getIcon(Object value) {
        return null;
    }

    public final void reset() {
        this.m_gotModel = false;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (!this.m_menuVisible) {
            super.processFocusEvent(e);
        }
    }

    protected final void loadModel() {
        if (!this.m_gotModel) {
            Object curr = this.getSelectedItem();
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
            String nullText = this.getNullText();
            if (nullText != null) {
                model.addElement(this.NULL_OBJ);
            }
            for (Object o : this.getModelEntries()) {
                model.addElement(o);
                if (!ModelUtil.areEqual(o, (Object)curr)) continue;
                model.setSelectedItem(o);
            }
            this.setModel((ComboBoxModel)model);
            this.m_gotModel = true;
            Logger logger = Logger.getLogger("oracle.abbot.test");
            if (logger != null) {
                logger.log(Level.FINE, this.getName() + ".loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ComboBoxModel model) {
        try {
            this.m_settingModel = true;
            super.setModel(model);
        }
        finally {
            this.m_settingModel = false;
            this.m_gotModel = true;
        }
    }

    @Override
    public void revalidate() {
        if (!this.m_settingModel) {
            super.revalidate();
        }
    }

    @Override
    public Object getSelectedItem() {
        Object ret = super.getSelectedItem();
        if (ret == this.NULL_OBJ) {
            return null;
        }
        return ret;
    }

    @Override
    public void setSelectedItem(Object val) {
        if (val == null) {
            val = this.NULL_OBJ;
        }
        super.setSelectedItem(val);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp;
        Object iconValue = value;
        if (value == null || value == this.NULL_OBJ) {
            value = this.getNullText();
            iconValue = null;
        }
        if ((comp = this.m_delegateLCR.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus)) instanceof JLabel) {
            ((JLabel)comp).setIcon(this.getIcon(iconValue));
        }
        return comp;
    }

    private class CustomJTextField
    extends JTextField {
        public CustomJTextField() {
            super("", 9);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (!AbstractLazyCombo.this.m_menuVisible) {
                super.processFocusEvent(e);
            }
        }
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            return new CustomJTextField();
        }
    }
}

