/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.controls.ShuttlePanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.util.DBObjectSet;

public class DBObjectIDShuttlePanel
extends ShuttlePanel {
    private final Class<? extends DBObject> m_clz;
    private final DBObjectFilter m_filter;

    public DBObjectIDShuttlePanel(Class<? extends DBObject> clz, DBObjectFilter filter, boolean addOrderButtons, Integer buttonMask) {
        super(addOrderButtons, buttonMask, DBTypeDisplayRegistry.getDisplayName(Metadata.getType(clz)), new DBObjectRenderer(), clz.getSimpleName() + "Shuttle");
        this.m_clz = clz;
        this.m_filter = filter;
    }

    public DBObjectID[] getSelectedIDs() {
        DefaultListModel selectedModel = this.getModel(true);
        ArrayList<DBObjectID> l = new ArrayList<DBObjectID>();
        for (int i = 0; i < selectedModel.getSize(); ++i) {
            l.add(((DBObject)selectedModel.get(i)).getID());
        }
        return l.toArray(new DBObjectID[l.size()]);
    }

    public void setSelectedIDs(DBObjectID[] ids) {
        DBObject obj;
        int i;
        DefaultListModel availableModel = this.getModel(false);
        DefaultListModel selectedModel = this.getModel(true);
        List<DBObjectID> list = Arrays.asList(ids);
        DBObjectSet set = new DBObjectSet();
        for (i = 0; i < availableModel.getSize(); ++i) {
            obj = (DBObject)availableModel.get(i);
            set.add(obj);
        }
        for (i = 0; i < selectedModel.getSize(); ++i) {
            obj = (DBObject)selectedModel.get(i);
            set.add(obj);
        }
        availableModel.removeAllElements();
        selectedModel.removeAllElements();
        DBObject[] selected = new DBObject[list.size()];
        for (DBObject obj2 : set) {
            int selIdx = list.indexOf(obj2.getID());
            if (selIdx >= 0) {
                selected[selIdx] = obj2;
                continue;
            }
            availableModel.addElement(obj2);
        }
        for (int i2 = 0; i2 < selected.length; ++i2) {
            DBObject obj2;
            obj2 = selected[i2];
            if (obj2 == null) {
                DBObjectID actual = list.get(i2);
                if (actual instanceof ReferenceID) {
                    try {
                        obj2 = (DBObject)Metadata.getInstance().getObjectClass(actual.getType()).newInstance();
                        obj2.setName(((ReferenceID)actual).getName());
                        obj2.setID(actual);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to create dummy object for ReferenceID", e);
                    }
                } else {
                    try {
                        obj2 = actual.resolveID();
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger((Object)this).warning(dbe.getMessage());
                    }
                }
            }
            selectedModel.addElement(obj2);
        }
    }

    public void initialiseIDs(List<DBObject> available) {
        this.initialiseIDs(available, true);
    }

    public void initialiseIDs(List<DBObject> available, boolean clearSelected) {
        this.clearList(false);
        if (clearSelected) {
            this.clearList(true);
        }
        DefaultListModel availableModel = this.getModel(false);
        DefaultListModel selectedModel = this.getModel(true);
        for (DBObject obj : available) {
            if (this.contains(selectedModel, obj) || this.m_filter != null && !this.m_filter.accept(obj)) continue;
            availableModel.addElement(obj);
        }
    }

    private boolean contains(DefaultListModel haystack, DBObject needle) {
        boolean retval = false;
        Enumeration e = haystack.elements();
        while (e.hasMoreElements()) {
            if (needle != e.nextElement()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public Class<? extends DBObject> getReferencedClass() {
        return this.m_clz;
    }
}

