/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;

public abstract class IntegerWithComboPanel
extends JPanel {
    private final JComboBox m_combo;
    private final JLabel m_label;
    private final NumberTextField m_text;
    public static final String COMBO_SUFFIX = "Combo";
    public static final String TEXT_SUFFIX = "Text";
    protected static final Integer ZERO = new Integer(0);
    protected static final Integer ONE = new Integer(1);

    public abstract Integer getValue();

    public abstract void setValue(Integer var1);

    public IntegerWithComboPanel(ComboItem[] allValues, String label) {
        this.m_combo = new JComboBox<ComboItem>(allValues);
        this.m_combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IntegerWithComboPanel.this.enableControls();
                IntegerWithComboPanel.this.m_text.setNumber((Number)IntegerWithComboPanel.this.getValue());
            }
        });
        this.m_label = new JLabel();
        this.m_text = new NumberTextField();
        this.m_text.setDecimal(false);
        ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_text, (String)label);
    }

    public final void initialisePanel() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this);
        layout.add(this.m_combo, 1, 1, false, false);
        layout.add(this.m_label, 1, 1, false, false);
        layout.add((Component)this.m_text, 1, 1, true, false);
        layout.layout();
    }

    @Override
    public final boolean isEnabled() {
        return this.m_combo.isEnabled();
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.m_combo.setEnabled(enabled);
        if (!enabled) {
            this.m_label.setEnabled(enabled);
            this.m_text.setEnabled(enabled);
        } else {
            this.enableControls();
        }
    }

    @Override
    public final boolean isVisible() {
        return this.m_combo.isVisible();
    }

    @Override
    public final void setVisible(boolean visible) {
        this.m_combo.setVisible(visible);
        this.m_label.setVisible(visible);
        this.m_text.setVisible(visible);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.m_combo.setName(name + COMBO_SUFFIX);
        this.m_text.setName(name + TEXT_SUFFIX);
    }

    public final void addItemListener(ItemListener l) {
        this.m_combo.addItemListener(l);
    }

    public final void removeItemListener(ItemListener l) {
        this.m_combo.removeItemListener(l);
    }

    public final JComboBox getCombo() {
        return this.m_combo;
    }

    public final Document getDocument() {
        return this.m_text.getDocument();
    }

    protected final void setComboValue(ComboItem val) {
        this.m_combo.setSelectedItem((Object)val);
        this.enableControls();
    }

    protected final ComboItem getComboValue() {
        return (ComboItem)((Object)this.m_combo.getSelectedItem());
    }

    protected final void setIntegerValue(Integer num) {
        this.m_text.setNumber((Number)num);
    }

    protected final Integer getIntegerValue() {
        if (this.m_text.getNumber() != null) {
            return new Integer(this.m_text.getNumber().toString());
        }
        return null;
    }

    private final void enableControls() {
        this.m_label.setEnabled(ComboItem.SELECT.equals((Object)this.getComboValue()));
        this.m_text.setEnabled(ComboItem.SELECT.equals((Object)this.getComboValue()));
    }

    protected static enum ComboItem {
        UNSPECIFIED("INT_WITH_COMBO_WRAPPER_VALUE_NULL"),
        NONE("INT_WITH_COMBO_WRAPPER_VALUE_NONE"),
        DEFAULT("INT_WITH_COMBO_WRAPPER_VALUE_DEFAULT"),
        SELECT("INT_WITH_COMBO_WRAPPER_VALUE_SELECT");

        final String m_itemText;

        private ComboItem(String id) {
            this.m_itemText = UIBundle.get(id);
        }

        public String toString() {
            return this.m_itemText;
        }
    }
}

