/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.util.StringComparator;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.plaf.IconicButtonUI;

public class ShuttlePanel<T>
extends JPanel {
    private final Shuttle m_shuttle = new Shuttle();
    private final JList m_availableJList = new JList();
    private final JList m_selectedJList = new JList();
    private final JLabel m_lblFrom;
    private final JComponent m_lblTo;

    public ShuttlePanel(boolean addOrderButtons, String typeDisplay, String componentBaseName) {
        this(addOrderButtons, null, typeDisplay, null, componentBaseName);
    }

    public ShuttlePanel(boolean addOrderButtons, Integer buttonMask, String typeDisplay, ListCellRenderer renderer, String componentBaseName) {
        ListPicker availablePicker = new ListPicker(this.m_availableJList);
        Object selectedPicker = addOrderButtons ? new ReorderableListPicker(this.m_selectedJList) : new ListPicker(this.m_selectedJList);
        this.m_shuttle.setFromPicker((ItemPicker)availablePicker);
        this.m_shuttle.setToPicker((ItemPicker)selectedPicker);
        if (buttonMask != null) {
            this.m_shuttle.setButtonsShown(buttonMask.intValue());
        }
        this.m_lblFrom = new JLabel(UIBundle.format("SHUTTLE_AVAILABLE_GENERIC_TITLE", typeDisplay));
        this.m_lblFrom.setLabelFor(this.m_availableJList);
        JLabel toLabel = new JLabel(UIBundle.format("SHUTTLE_SELECTED_GENERIC_TITLE", typeDisplay));
        toLabel.setLabelFor(this.m_selectedJList);
        StatusIndicator indicator = new StatusIndicator();
        indicator.setStatus(StatusIndicator.Status.OK);
        this.m_lblTo = indicator.configureLabel(toLabel, StatusIndicator.Location.LEADING);
        this.m_shuttle.add((Component)this.m_lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)this.m_lblTo, (Object)"ToHeader");
        if (renderer != null) {
            this.m_availableJList.setCellRenderer(renderer);
            this.m_selectedJList.setCellRenderer(renderer);
        }
        Component[] components = this.m_shuttle.getComponents();
        Container shuttleButtonPanel = null;
        for (Component comp : components) {
            if (comp instanceof JComponent) {
                ((JComponent)comp).setOpaque(false);
            }
            if (!comp.getClass().equals(JPanel.class)) continue;
            shuttleButtonPanel = (JPanel)comp;
        }
        if (shuttleButtonPanel instanceof JPanel) {
            for (Component comp : shuttleButtonPanel.getComponents()) {
                if (!(comp instanceof AbstractButton)) continue;
                IconicButtonUI.install((AbstractButton)((AbstractButton)comp));
            }
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_shuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        DBUIResourceHelper resHelp = new DBUIResourceHelper(componentBaseName);
        this.setName(componentBaseName);
        resHelp.setName((Component)this.m_shuttle, "Shuttle");
        resHelp.setName(this.m_availableJList, "Available");
        resHelp.setName(this.m_selectedJList, "Selected");
    }

    public synchronized void addShuttleListener(ShuttleListener listener) {
        this.m_shuttle.addShuttleListener(listener);
    }

    public synchronized void removeShuttleListener(ShuttleListener listener) {
        this.m_shuttle.removeShuttleListener(listener);
    }

    public Component getToComponent() {
        return this.m_shuttle.getToPicker().getComponent();
    }

    public Component getToLabel() {
        return this.m_lblTo;
    }

    public Component getFromComponent() {
        return this.m_shuttle.getFromPicker().getComponent();
    }

    public Component getFromLabel() {
        return this.m_lblFrom;
    }

    public List<T> getSelected() {
        DefaultListModel selectedModel = this.getModel(true);
        ArrayList ret = new ArrayList();
        for (int i = 0; i < selectedModel.getSize(); ++i) {
            ret.add(selectedModel.get(i));
        }
        return ret;
    }

    public void setSelected(List<T> list) {
        int i;
        DefaultListModel availableModel = this.getModel(false);
        DefaultListModel selectedModel = this.getModel(true);
        Set set = this.getSet();
        for (i = 0; i < availableModel.getSize(); ++i) {
            set.add(availableModel.get(i));
        }
        for (i = 0; i < selectedModel.getSize(); ++i) {
            set.add(selectedModel.get(i));
        }
        availableModel.removeAllElements();
        selectedModel.removeAllElements();
        for (Object obj : set) {
            if (list.contains(obj)) {
                selectedModel.addElement(obj);
                continue;
            }
            availableModel.addElement(obj);
        }
    }

    protected Set getSet() {
        return new TreeSet(new StringComparator());
    }

    public void initialise(List available) {
        this.clearList(false);
        this.clearList(true);
        DefaultListModel availableModel = this.getModel(false);
        Set set = this.getSet();
        set.addAll(available);
        for (Object obj : set) {
            availableModel.addElement(obj);
        }
    }

    protected void clearList(boolean selected) {
        DefaultListModel model = this.getModel(selected);
        model.removeAllElements();
    }

    protected DefaultListModel getModel(boolean selected) {
        ListPicker picker = selected ? (ListPicker)this.m_shuttle.getToPicker() : (ListPicker)this.m_shuttle.getFromPicker();
        return (DefaultListModel)picker.getList().getModel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_shuttle.setEnabled(enabled);
        this.m_availableJList.setEnabled(enabled);
        this.m_selectedJList.setEnabled(enabled);
        this.m_lblFrom.setEnabled(enabled);
        this.m_lblTo.setEnabled(enabled);
    }
}

