/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ora.TablePartition;

public class ValuesPropertyPanel
extends JPanel {
    private final JLabel m_label = new JLabel();
    private final JTextField m_text = new JTextField();
    private final JCheckBox m_check = new JCheckBox();
    private ExtendedPartitionType m_type = ExtendedPartitionType.UNDEFINED;
    private final Collection<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private static final String DEFAULT = "DEFAULT";
    private static final String MAXVALUE = "MAXVALUE";
    private static final String RANGE_OPTION = "RANGE_OPTION";
    private static final String LIST_OPTION = "LIST_OPTION";
    public static final String TEXTBOX_NAME = "PartitionVaues";
    public static final String CHECKBOX_NAME = "ValuesPropertyPanel.defaultCheckbox";

    public ValuesPropertyPanel() {
        this.setName("ValuesPropertyPanel");
        this.m_text.setName(TEXTBOX_NAME);
        this.m_check.setName(CHECKBOX_NAME);
        this.m_label.setLabelFor(this.m_text);
        DBUIMnemonicBuilder.addLabelOption(this.m_label, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_CHECKBOX"));
        DBUIMnemonicBuilder.addLabelOption(this.m_label, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_CHECKBOX"));
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuesPropertyPanel.this.enableTextControl();
                JCheckBox check = (JCheckBox)e.getSource();
                if (check.isSelected()) {
                    if (ValuesPropertyPanel.this.m_type.isList()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.DEFAULT);
                    } else if (ValuesPropertyPanel.this.m_type.isRange()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.MAXVALUE);
                    }
                } else {
                    ValuesPropertyPanel.this.m_text.setText(null);
                }
                ValuesPropertyPanel.this.notifyListeners();
            }
        };
        this.m_check.addActionListener(checkboxListener);
    }

    public void initialisePanel(ExtendedPartitionType type) {
        DBUILayoutHelper layout = new DBUILayoutHelper(this);
        layout.add(this.m_label, 1, 1, false, false);
        layout.add(this.m_text, 1, 1, true, false);
        layout.add(this.m_check, 1, 1, false, false);
        layout.layout();
        this.setLabelText(type);
        this.m_type = type;
    }

    public Document getDocument() {
        return this.m_text.getDocument();
    }

    public Object getValues(ExtendedPartitionType type) {
        if (type.isList() && this.m_check.isSelected()) {
            return new Object[]{DEFAULT};
        }
        if (type.isRange() && this.m_check.isSelected()) {
            return new Object[]{MAXVALUE};
        }
        String text = this.m_text.getText();
        List bits = TablePartition.splitValues((String)text);
        Object[] ret = new Object[bits.size()];
        int index = 0;
        for (String bit : bits) {
            ret[index++] = bit.trim();
        }
        return ret;
    }

    public void setValues(Object values, ExtendedPartitionType type) {
        this.setLabelText(type);
        if (values instanceof Object[]) {
            String stringValue = "";
            StringBuilder builder = new StringBuilder();
            String sep = ",";
            for (Object bit : (Object[])values) {
                builder.append(",");
                builder.append(bit);
            }
            stringValue = builder.toString();
            if (stringValue.length() > 0) {
                stringValue = stringValue.substring(",".length());
            }
            if (type.isList()) {
                this.m_check.setSelected(DEFAULT.equalsIgnoreCase(stringValue));
            } else if (type.isRange()) {
                this.m_check.setSelected(MAXVALUE.equalsIgnoreCase(stringValue));
            }
            this.enableTextControl();
            this.m_text.setText(stringValue);
        } else {
            this.m_text.setText(null);
        }
    }

    public void setLabelText(ExtendedPartitionType type) {
        if (type.isList()) {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, LIST_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, LIST_OPTION);
        } else {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, RANGE_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, RANGE_OPTION);
        }
    }

    private void enableTextControl() {
        this.m_text.setEnabled(this.isEnabled() && !this.m_check.isSelected());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_label.setVisible(visible);
        this.m_text.setVisible(visible);
        this.m_check.setVisible(visible);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_label.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
        this.m_check.setEnabled(enabled);
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.m_text, this.m_check};
    }

    public final void addChangeListener(ChangeListener l) {
        this.removeChangeListener(l);
        this.m_listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyListeners() {
        for (ChangeListener cl : this.m_listeners) {
            cl.valuesChanged();
        }
    }

    public static interface ChangeListener {
        public void valuesChanged();
    }
}

