/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;

public final class DBObjectNavigationPoint
extends DefaultNavigationPoint {
    private DBObject m_childObject;

    protected int navigateImpl() throws Exception {
        return super.navigateImpl();
    }

    protected int renavigate() throws Exception {
        int retval = 1;
        if (this.m_childObject == null) {
            retval = super.renavigate();
        } else {
            DBEditorFactory factory;
            Node node = NodeFactory.find((URL)this.nodeURL);
            if (node instanceof DBObjectNode && (factory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)node)) != null) {
                DBEditorConfig config = DBEditorConfig.newEditConfig((DBObjectNode)node);
                config.setChildObject(this.m_childObject);
                factory.launchDialog(config);
                retval = 0;
            }
        }
        return retval;
    }

    public void setContext(Context context) {
        super.setContext(context);
        DBEditorConfig config = DBEditorConfig.getConfig(context);
        this.m_childObject = config == null ? null : config.getChildObject();
    }

    public Object copyTo(Object target) {
        DBObjectNavigationPoint copy = target == null ? new DBObjectNavigationPoint() : (DBObjectNavigationPoint)((Object)target);
        super.copyToImpl((DefaultNavigationPoint)copy);
        copy.m_childObject = this.m_childObject;
        return copy;
    }

    public String getShortLabel() {
        return this.m_childObject == null ? super.getShortLabel() : DBUtil.getFullyQualifiedName((DBObject)this.m_childObject, (boolean)false);
    }

    public Icon getIcon() {
        return this.m_childObject == null ? super.getIcon() : DBTypeDisplayRegistry.getNodeIcon(this.m_childObject);
    }
}

