/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.util.ClassUtils;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.ideimpl.db.model.ProviderNodeRecognizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.ora.sxml.SXMLCommentGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

public class DatabaseExtensionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-hook";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-hook");
    private final List<HashStructure> m_recogHashes = new CopyOnWriteArrayList<HashStructure>();
    private final Map<String, ExtensionPropertyInfo> m_propertyInfos = new ConcurrentHashMap<String, ExtensionPropertyInfo>();
    private final Map<String, HashStructure> m_typeDisplayHashes = new ConcurrentHashMap<String, HashStructure>();
    private final MultiMap<String, Thunk<DBURLFactory.Helper>> m_urlHelpHashes = new MultiMap(CopyOnWriteArrayList.class);

    public DatabaseExtensionHook() {
        this.init();
    }

    private void init() {
        DBCore.setExtensionInitializer((Runnable)new Runnable(){

            @Override
            public void run() {
                DatabaseExtensionHook.this.checkListenerInit();
            }
        });
        DBCore core = DBCore.getInstance();
        core.registerFactoryList(DatabaseFactory.ConnectionCreatorFactory.class, this.createChildList("connection-creator-factories", "connection-creator-factory", DatabaseFactory.ConnectionCreatorFactory.class));
        core.registerFactoryMap(DBObjectProviderFactory.Creator.class, this.createChildMap("provider-creators", "provider-creator", "type", "class", DBObjectProviderFactory.Creator.class));
        core.registerFactoryMap(DBObjectXMLHandler.class, this.createChildMap("object-xml-handlers", "object-xml-handler", "namespace", "class", DBObjectXMLHandler.class));
        core.registerFactoryList(SXMLFragmentGenerator.class, this.createChildList("sxml-fragment-generators", "sxml-fragment-generator", SXMLFragmentGenerator.class));
        core.registerFactoryList(SXMLCommentGenerator.class, this.createChildList("sxml-comment-generators", "sxml-comment-generator", SXMLCommentGenerator.class));
        Metadata.getInstance().registerProperties((Iterable)new Iterable<ExtensionPropertyInfo>(){

            @Override
            public Iterator<ExtensionPropertyInfo> iterator() {
                DatabaseExtensionHook.this.checkListenerInit();
                return DatabaseExtensionHook.this.m_propertyInfos.values().iterator();
            }
        });
        this.createChildList("url-factory-helpers", "url-factory-helper", DBURLFactory.Helper.class);
    }

    @Override
    protected void processHashStructure(HashStructure hash) {
        DatabaseMatcher matcher;
        HashStructure clzHash;
        String type;
        super.processHashStructure(hash);
        for (HashStructure urlHash : this.getChildList(hash, "url-factory-helpers", "url-factory-helper")) {
            type = this.getText(urlHash, "type", false);
            if (type == null) {
                type = "db";
                clzHash = urlHash;
            } else {
                clzHash = urlHash.getHashStructure("class");
            }
            if (clzHash == null) {
                this.logMissingElemError(urlHash, "url-factory-helper", "class");
                continue;
            }
            this.m_urlHelpHashes.add((Object)type, this.createInstanceThunk(clzHash, DBURLFactory.Helper.class));
        }
        this.m_recogHashes.addAll(this.getChildList(hash, "node-recognizers", "node-recognizer"));
        for (HashStructure objHash : this.getChildList(hash, "object-types", "object-type")) {
            type = this.getText(objHash, "object-type");
            if (!ModelUtil.hasLength((String)type)) continue;
            clzHash = objHash.getHashStructure("object-class");
            if (clzHash == null) {
                this.logMissingElemError(objHash, "object-type", "object-class");
            } else {
                DBObjectRegistry.getInstance().registerClass(type, this.createClassThunk(clzHash, DBObject.class));
            }
            this.registerTypeDisplayHash(type, objHash);
        }
        for (HashStructure propHash : this.getChildList(hash, "object-properties", "object-property")) {
            ExtensionPropertyInfo info = new ExtensionPropertyInfo(propHash);
            if (!info.isValid()) continue;
            this.m_propertyInfos.put(info.getPropertyName(), info);
            try {
                Metadata.getInstance().registerProperty((PropertyInfo)info);
            }
            catch (IllegalArgumentException iae) {
                this.logError(hash, iae.getMessage());
            }
            if (info.isCopyFromTemplate()) continue;
            for (Class clz : info.getObjectClasses()) {
                TemplateExpander.registerPropertyToClear((Class)clz, (String)info.getPropertyName());
            }
        }
        for (HashStructure regHash : this.getChildList(hash, "object-registry", "registry-entry")) {
            HashStructure matcherHash = regHash.getHashStructure("database-match");
            if (matcherHash == null) {
                this.logMissingElemError(regHash, "registry-entry", "database-match");
                continue;
            }
            String objType = this.getText(regHash, "object-type");
            matcher = this.createDatabaseMatcher(matcherHash);
            Thunk<Class<DBObjectValidator>> vThunk = this.createClassThunk(regHash, "validator-class", DBObjectValidator.class);
            Thunk<Class<DBObjectBuilder>> bThunk = this.createClassThunk(regHash, "builder-class", DBObjectBuilder.class);
            Thunk<Class<DBObjectLister>> lThunk = this.createClassThunk(regHash, "lister-class", DBObjectLister.class);
            Thunk<Class<DDLGenerator>> dThunk = this.createClassThunk(regHash, "ddl-generator-class", DDLGenerator.class);
            if (objType == null || matcher == null || vThunk == null || bThunk == null || lThunk == null || dThunk == null) continue;
            DBObjectRegistry.getInstance().registerObject(objType, matcher, vThunk, bThunk, lThunk, dThunk);
        }
        for (HashStructure dcHash : this.getChildList(hash, "database-creators", "database-creator")) {
            type = this.getText(dcHash, "database-type", false);
            MetaClass<DatabaseFactory.DatabaseCreator> creatorClass = this.getSingleChildMeta(dcHash, "database-creator-class", DatabaseFactory.DatabaseCreator.class);
            if (creatorClass == null) {
                this.logMissingElemError(dcHash, "database-creator-class");
                continue;
            }
            matcher = null;
            HashStructure matcherHash = dcHash.getHashStructure("connection-matcher");
            if (matcherHash != null) {
                matcher = this.createConnectionMatcher(matcherHash, dcHash);
            }
            ArrayList<DatabaseRegistry.DatabaseVersion> vers = new ArrayList<DatabaseRegistry.DatabaseVersion>();
            List<HashStructure> dbHashes = this.getChildList(dcHash, "databases", "database");
            for (HashStructure dbHash : dbHashes) {
                String verText = this.getText(dbHash, "database-version", true);
                String nlsName = this.getText(dbHash, "database-name", false);
                String dbClzName = this.getText(dbHash, "database-class", true);
                if (dbClzName == null || verText == null) continue;
                try {
                    int version = Integer.parseInt(verText);
                    vers.add(new DatabaseRegistry.DatabaseVersion(version, nlsName, dbClzName));
                }
                catch (NumberFormatException nfe) {
                    this.logError(dbHash, nfe.getMessage());
                }
            }
            if (!vers.isEmpty() && type == null) {
                this.logMissingElemError(dcHash, "database-type");
            }
            DatabaseRegistry reg = DatabaseRegistry.getInstance();
            reg.registerDatabases(type, creatorClass.getClassName(), creatorClass.getClassLoader(), (ConnectionMatcher)matcher, vers.toArray(new DatabaseRegistry.DatabaseVersion[vers.size()]));
        }
        for (HashStructure bundleHash : this.getChildList(hash, "property-display-bundles", "property-display-bundle")) {
            PropertyDisplayRegistry.getInstance().registerBundle(this.createInstanceThunk(bundleHash, ResourceBundle.class));
        }
        for (HashStructure bundleHash : this.getChildList(hash, "property-display-plugins", "property-display-plugin")) {
            PropertyDisplayRegistry.getInstance().registerPlugin(this.createInstanceThunk(bundleHash, PropertyDisplayRegistry.Plugin.class));
        }
    }

    private ConnectionMatcher createConnectionMatcher(HashStructure matcherHash, HashStructure parentHash) {
        List<String> allowedNames = Arrays.asList("and", "or", "database-product-version", "database-product-name", "driver-name");
        ConnectionMatcher retval = null;
        String name = matcherHash.getStructName();
        if ("connection-matcher".equals(name)) {
            String key;
            Object childElem;
            Iterator<String> i$ = allowedNames.iterator();
            while (i$.hasNext() && (!((childElem = matcherHash.getObject(key = i$.next())) instanceof HashStructure) || (retval = this.createConnectionMatcher((HashStructure)childElem, matcherHash)) == null)) {
            }
        } else if ("and".equals(name) || "or".equals(name)) {
            ArrayList<ConnectionMatcher> kids = new ArrayList<ConnectionMatcher>();
            for (String key : allowedNames) {
                ConnectionMatcher child;
                Object childElem = matcherHash.getObject(key);
                if (!(childElem instanceof HashStructure) || (child = this.createConnectionMatcher((HashStructure)childElem, matcherHash)) == null) continue;
                kids.add(child);
            }
            if (kids.isEmpty()) {
                this.logError(matcherHash, name + " expects child elements.");
            } else {
                retval = ConnectionMatcher.matchAll((boolean)"and".equals(name), (ConnectionMatcher[])kids.toArray(new ConnectionMatcher[kids.size()]));
            }
        } else {
            String regexp = HashStructureHook.getText((HashStructure)matcherHash);
            if (regexp == null) {
                this.logMissingElemError(parentHash, name);
            } else if ("database-product-version".equals(name)) {
                retval = ConnectionMatcher.matchDatabaseProductVersion((String)regexp);
            } else if ("database-product-name".equals(name)) {
                retval = ConnectionMatcher.matchDatabaseProductName((String)regexp);
            } else if ("driver-name".equals(name)) {
                retval = ConnectionMatcher.matchDriverName((String)regexp);
            } else {
                this.logError(matcherHash, "Unexpected element " + name);
            }
        }
        return retval;
    }

    private DatabaseMatcher createDatabaseMatcher(HashStructure matcherHash) {
        DatabaseMatcher retval = null;
        String dbType = this.getText(matcherHash, "database-type");
        String dbVerText = this.getText(matcherHash, "database-version");
        String comparisonText = this.getText(matcherHash, "database-version-match");
        DatabaseMatcher.Comparison comparison = null;
        try {
            comparison = DatabaseMatcher.Comparison.valueOf((String)comparisonText);
        }
        catch (IllegalArgumentException iae) {
            this.logError(matcherHash, iae.getMessage());
        }
        Integer dbVer = null;
        if (dbVerText != null) {
            try {
                dbVer = Integer.parseInt(dbVerText);
            }
            catch (NumberFormatException nfe) {
                this.logError(matcherHash, nfe.getMessage());
            }
        }
        if (dbType != null && dbVer != null && comparison != null) {
            retval = new DatabaseMatcher(dbType, dbVer.intValue(), comparison);
            String testSysProp = this.getText(matcherHash, "test-system-property", false);
            retval.setTestSystemProperty(testSysProp);
        }
        return retval;
    }

    private void registerTypeDisplayHash(String type, HashStructure hash) {
        if (this.m_typeDisplayHashes.size() == 0) {
            DBTypeDisplayRegistry.addDBTypeRegistry(new HashDisplayRegistry());
        }
        this.m_typeDisplayHashes.put(type, hash);
    }

    public ProviderNodeRecognizer findNodeRecognizer(Object elem) {
        ProviderNodeRecognizer retval = null;
        if (elem != null) {
            this.checkListenerInit();
            for (HashStructure fEntry : this.m_recogHashes) {
                HashStructure factoryHash;
                String nodeClz = fEntry.getString("node-class/#text");
                if (!ClassUtils.isInstanceOf(elem.getClass(), (String)nodeClz) || (factoryHash = fEntry.getHashStructure("recognizer-class")) == null || (retval = this.instantiateClass(factoryHash, ProviderNodeRecognizer.class, new Object[0])) == null) continue;
                break;
            }
        }
        return retval;
    }

    public Collection<DBURLFactory.Helper> getURLFactoryHelpers(String type) {
        this.checkListenerInit();
        ArrayList<DBURLFactory.Helper> retval = new ArrayList<DBURLFactory.Helper>();
        Collection thunks = this.m_urlHelpHashes.get((Object)type);
        if (thunks != null) {
            for (Thunk t : thunks) {
                DBURLFactory.Helper h = (DBURLFactory.Helper)t.get();
                if (h == null) continue;
                retval.add(h);
            }
        }
        return retval;
    }

    public String getExtensionPropertyDisplayName(String propName, DBObjectProvider pro, DBObject obj) {
        this.checkListenerInit();
        ExtensionPropertyInfo info = propName == null ? null : this.m_propertyInfos.get(propName);
        return info == null ? null : info.getDisplayName();
    }

    public Collection<PropertyInfo> getAutoIncludedProperties(DBObjectProvider pro, Class<? extends DBObject> objClz) {
        ArrayList<PropertyInfo> retval = null;
        Metadata m = Metadata.getInstance();
        Collection extras = m.getSupportedProperties(objClz, pro.getClass(), false, true);
        for (String extraProp : extras) {
            PropertyInfo info = pro.getPropertyManager().findPropertyInfo(objClz, extraProp);
            if (!(info instanceof ExtensionPropertyInfo) || !((ExtensionPropertyInfo)info).isAutoInclude()) continue;
            if (retval == null) {
                retval = new ArrayList<PropertyInfo>();
            }
            retval.add(info);
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    public static synchronized DatabaseExtensionHook getHook() {
        return DatabaseExtensionHook.findHook(NAME, DatabaseExtensionHook.class);
    }

    private class HashDisplayRegistry
    extends DBTypeDisplayRegistryEntry {
        private HashDisplayRegistry() {
        }

        @Override
        protected void populateEntries() {
        }

        private String getTextImpl(String type, String elemName, boolean logErrorIfMissing) {
            HashStructure hash;
            String retval = null;
            if (type != null && (hash = (HashStructure)DatabaseExtensionHook.this.m_typeDisplayHashes.get(type)) != null) {
                retval = DatabaseExtensionHook.this.getText(hash, elemName, logErrorIfMissing);
            }
            return retval;
        }

        @Override
        public String getDisplayName(String type) {
            return this.getTextImpl(type, "display-name", true);
        }

        @Override
        public String getSingularDisplayName(String type) {
            return this.getTextImpl(type, "singular-display-name", true);
        }

        @Override
        public String getNewMenuItemText(String type) {
            return this.getTextImpl(type, "new-menu-text", false);
        }

        private Icon getIconImpl(String type, String elemName, boolean logErrorIfMissing) {
            HashStructure hash;
            Icon retval = null;
            if (type != null && (hash = (HashStructure)DatabaseExtensionHook.this.m_typeDisplayHashes.get(type)) != null) {
                retval = DatabaseExtensionHook.this.getIcon(hash, elemName, logErrorIfMissing);
            }
            return retval;
        }

        @Override
        public Icon getNodeIcon(String type) {
            return this.getIconImpl(type, "node-icon", true);
        }

        @Override
        public Icon getFolderIcon(String type) {
            return this.getIconImpl(type, "folder-icon", false);
        }
    }

    public class ExtensionPropertyInfo
    extends PropertyInfo {
        private final HashStructure m_hash;
        private List<Class<? extends DBObject>> m_objClzs;

        ExtensionPropertyInfo(HashStructure hash) {
            this.m_hash = hash;
        }

        boolean isValid() {
            boolean valid = true;
            String name = this.getPropertyName();
            if (ModelUtil.hasLength((String)name)) {
                if (!ModelUtil.hasLength((String)this.getDisplayName())) {
                    DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "display-name");
                    valid = false;
                }
                if (this.getPropertyClassName() == null) {
                    DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "property-class");
                    valid = false;
                }
            } else {
                DatabaseExtensionHook.this.logMissingElemError(this.m_hash, "object-property", "property-name");
                valid = false;
            }
            return valid;
        }

        public String getPropertyName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "property-name");
        }

        public String getDisplayName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "display-name");
        }

        String getPropertyClassName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "property-class");
        }

        public Class<? extends Object> getPropertyClass() {
            return DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "property-class", Object.class);
        }

        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof ExtensionPropertyInfo && this.m_hash == ((ExtensionPropertyInfo)info).m_hash;
        }

        public Class getReferencedClass() {
            Class retval = DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "referenced-class", DBObject.class);
            if (retval == null) {
                retval = super.getReferencedClass();
            }
            return retval;
        }

        public Nullable.NullBehaviour getNullBehaviour() {
            String content;
            Nullable.NullBehaviour retval = null;
            HashStructure nullHash = this.m_hash.getHashStructure("null-behaviour");
            if (nullHash != null && (content = HashStructureHook.getText((HashStructure)nullHash)) != null) {
                try {
                    retval = Nullable.NullBehaviour.valueOf((String)content);
                }
                catch (Exception e) {
                    DatabaseExtensionHook.this.logError(nullHash, e.getMessage());
                }
            }
            return retval == null ? super.getNullBehaviour() : retval;
        }

        String getProviderClassName() {
            return DatabaseExtensionHook.this.getText(this.m_hash, "provider-class", false);
        }

        protected Class<? extends DBObjectProvider> getProviderClass() {
            return DatabaseExtensionHook.this.loadAPIClass(this.m_hash, "provider-class", DBObjectProvider.class);
        }

        List<String> getObjectClassNames() {
            ArrayList<String> retval = new ArrayList<String>();
            for (HashStructure kid : DatabaseExtensionHook.this.getChildList(this.m_hash, "object-classes", "object-class")) {
                String clzName = HashStructureHook.getText((HashStructure)kid);
                if (!ModelUtil.hasLength((String)clzName)) continue;
                retval.add(clzName);
            }
            return retval;
        }

        protected List<Class<? extends DBObject>> getObjectClasses() {
            if (this.m_objClzs == null) {
                for (HashStructure kid : DatabaseExtensionHook.this.getChildList(this.m_hash, "object-classes", "object-class")) {
                    Class<DBObject> next = DatabaseExtensionHook.this.loadAPIClass(kid, DBObject.class);
                    if (next == null) continue;
                    if (this.m_objClzs == null) {
                        this.m_objClzs = new ArrayList<Class<? extends DBObject>>();
                    }
                    this.m_objClzs.add(next);
                }
                if (this.m_objClzs == null) {
                    this.m_objClzs = Collections.singletonList(DBObject.class);
                }
            }
            return this.m_objClzs;
        }

        public boolean isStaticReference() {
            return Boolean.valueOf(DatabaseExtensionHook.this.getText(this.m_hash, "static-reference", false));
        }

        boolean isCopyFromTemplate() {
            String s = DatabaseExtensionHook.this.getText(this.m_hash, "copy-from-template", false);
            return s == null || Boolean.valueOf(s) != false;
        }

        boolean isAutoInclude() {
            String s = DatabaseExtensionHook.this.getText(this.m_hash, "auto-include-ui", false);
            return s != null && Boolean.valueOf(s) != false;
        }

        public boolean isSupported(Class<? extends DBObjectProvider> proClz, Class<? extends DBObject> objClz) {
            List<String> infoClzs;
            String infoClz;
            if (proClz != null && (infoClz = this.getProviderClassName()) != null && !DatabaseExtensionHook.this.isAssignableFrom(infoClz, proClz)) {
                return false;
            }
            if (objClz != null && (infoClzs = this.getObjectClassNames()) != null && infoClzs.size() > 0) {
                boolean supported = false;
                for (String infoClzName : infoClzs) {
                    if (!DatabaseExtensionHook.this.isAssignableFrom(infoClzName, objClz)) continue;
                    supported = true;
                    break;
                }
                if (!supported) {
                    return false;
                }
            }
            return true;
        }

        public DynamicPropertyProvider getDynamicPropertyProvider() {
            DynamicPropertyProvider retval = null;
            HashStructure clzHash = this.m_hash.getHashStructure("dynamic-property-provider");
            if (clzHash != null) {
                retval = DatabaseExtensionHook.this.instantiateClass(clzHash, DynamicPropertyProvider.class, new Object[0]);
            }
            return retval;
        }
    }
}

