/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.panels.CommentPanel;
import oracle.ideimpl.db.panels.table.ColumnsTableEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.panels.table.ExternalTablePropertiesPanel;
import oracle.ideimpl.db.panels.table.IndexesPanel;
import oracle.ideimpl.db.panels.table.SimpleCreateTablePanel;
import oracle.ideimpl.db.panels.table.StoragePanel;
import oracle.ideimpl.db.panels.table.TableInfoPanel;
import oracle.ideimpl.db.panels.table.TablePartitioningPanel;
import oracle.ideimpl.db.panels.table.TablePropertiesPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.PropertyManager;

public class TablePanelLibrary
extends PanelLibrary<Table> {
    private static final Dimension DIALOG_SIZE = new Dimension(1200, 800);

    public TablePanelLibrary() {
        this((Map<String, String>)null);
    }

    protected TablePanelLibrary(Map<String, String> helpIDs) {
        super("TABLE", helpIDs);
        this.initPanels();
    }

    protected void initPanels() {
        this.addPanel(UIBundle.get("SIMPLETABLE_TITLE"), SimpleCreateTablePanel.class, "f1_odbta_html", "columns");
        this.addPanel(UIBundle.get("COMMENT"), CommentPanel.class, "f1_odbtacomment_html", "Comment");
        this.addPanel(UIBundle.get("COLUMN_INFO_TITLE"), ColumnsTableEditorPanel.class, "f1_odbtacolumns_html", "columns");
        this.addPanel(UIBundle.get("CONSTRAINTS_INFO_TITLE"), ConstraintsPanel.class, "f1_odbtapk_html", "constraints");
        this.addPanel(UIBundle.get("INDEX_PANEL_TITLE"), IndexesPanel.class, "f1_odbtaindexes_html", "indexes");
        this.addPanel(UIBundle.get("TABLE_PROPS_PANEL_TITLE"), TablePropertiesPanel.class, "f1_odbtaprops_html", "OracleIndexOrganizedTableProperties");
        this.addPanel(UIBundle.get("STORAGE_INFO_TITLE"), StoragePanel.class, "f1_odbtastoropts_html", "OracleStorageProperties", "OracleTableProperties");
        this.addPanel(UIBundle.get("PARTITIONS_MAIN_TAB"), TablePartitioningPanel.class, "f1_odbtapart_html", "OracleTablePartitions");
        this.addPanel(UIBundle.get("EXTTAB_TITLE"), ExternalTablePropertiesPanel.class, "f1_odbtaextprops_html", "OracleExternalTableProperties");
    }

    @Override
    public Class<? extends Traversable> getHeader() {
        return TableInfoPanel.class;
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_offlinedbtageneral_html";
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_offlinedbtacreate_html";
    }

    @Override
    public boolean canEditObject(Table obj, DBObjectProvider pro) {
        return true;
    }

    @Override
    protected List<String> getTitles(Table table, DBObjectProvider pro, boolean editing) {
        ArrayList<String> titles = null;
        Table.TableType type = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        if (!Boolean.TRUE.equals(table.getProperty("OBJECT TABLE"))) {
            titles = new ArrayList<String>();
            titles.add(UIBundle.get("COLUMN_INFO_TITLE"));
            titles.add(UIBundle.get("CONSTRAINTS_INFO_TITLE"));
            titles.add(UIBundle.get("INDEX_PANEL_TITLE"));
            titles.add(UIBundle.get("TABLE_PROPS_PANEL_TITLE"));
            titles.add(UIBundle.get("EXTTAB_TITLE"));
            titles.add(UIBundle.get("STORAGE_INFO_TITLE"));
            if (type != Table.TableType.EXTERNAL) {
                boolean temp;
                boolean bl = temp = type == Table.TableType.SESSION_TEMP || type == Table.TableType.TRANSACTION_TEMP;
                if (!temp) {
                    TablePanelLibrary.addPartitioningIfSupported(table, pro, editing, titles);
                }
            }
            titles.add(UIBundle.get("COMMENT"));
        }
        return titles;
    }

    @Override
    protected List<String> getSimpleTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add(UIBundle.get("SIMPLETABLE_TITLE"));
        return titles;
    }

    @Override
    public Dimension getSize(boolean edit) {
        return DIALOG_SIZE;
    }

    @Override
    protected Table newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
        Table table = (Table)super.newDBObject(pro, schema, parent);
        if (table.getColumns().length == 0) {
            Column newCol = (Column)pro.getObjectFactory().newObject(Column.class, (DBObject)table);
            String baseName = "COLUMN";
            if (pro.getDescriptor().getCasePolicy() == 1) {
                baseName = baseName.toLowerCase();
            }
            newCol.setName(baseName + "1");
            newCol.setDataTypeUsage(pro.getDescriptor().createDefaultTypeUsage());
            table.addColumn(newCol);
        }
        return table;
    }

    static void addPartitioningIfSupported(Table table, DBObjectProvider pro, boolean editing, List<String> titles) {
        boolean partitionsSupported;
        PropertyManager pm = pro.getPropertyManager();
        boolean bl = partitionsSupported = pm == null || pm.supportsProperty(table.getClass(), "OracleTablePartitions");
        if (!(!partitionsSupported || editing && pro instanceof Database && table.getProperty("PARTITIONED TABLE") == null)) {
            titles.add(UIBundle.get("PARTITIONS_MAIN_TAB"));
        }
    }
}

