/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.ora.PlSqlPanelLibrary;
import oracle.ideimpl.db.panels.plsql.TriggerPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.plsql.Trigger;

public class TriggerPanelLibrary
extends PlSqlPanelLibrary {
    public static final Dimension DIALOG_SIZE = new Dimension(600, 600);

    public TriggerPanelLibrary() {
        super("TRIGGER");
        this.addPanel(UIBundle.get("PROPERTIES"), TriggerPanel.class, "f1_odbtr_html", "baseObjectID", "baseType", "columnIDs", "enabled", "events", "referencingNewAs", "referencingOldAs", "statementLevel", "timing", "whenClause");
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_odbtr_html";
    }

    protected DBObject newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
        Trigger trg = (Trigger)super.newDBObject(pro, schema, parent);
        if (parent != null) {
            if (parent instanceof Table) {
                trg.setBaseType(Trigger.BaseType.TABLE);
                trg.setTiming(Trigger.Timing.BEFORE);
                trg.setBaseObjectID(parent.getID());
            } else if (parent instanceof View) {
                trg.setBaseType(Trigger.BaseType.VIEW);
                trg.setBaseObjectID(parent.getID());
                trg.setTiming(Trigger.Timing.INSTEAD_OF);
            }
        } else {
            trg.setBaseType(Trigger.BaseType.TABLE);
            trg.setTiming(Trigger.Timing.BEFORE);
        }
        return trg;
    }

    @Override
    protected List<String> getTitles(DBObject obj, DBObjectProvider pro, boolean editing) {
        return Collections.singletonList(UIBundle.get("PROPERTIES"));
    }

    @Override
    public Dimension getSize(boolean edit) {
        return DIALOG_SIZE;
    }

    @Override
    public boolean shouldResetObjectBeforeEdit(DBEditorConfig config) {
        return true;
    }

    @Override
    protected void setContextObject(SchemaObject newObject, SchemaObject contextObject) {
        if (newObject instanceof Trigger && contextObject != null) {
            Trigger trig = (Trigger)newObject;
            if (contextObject instanceof Table) {
                trig.setBaseType(Trigger.BaseType.TABLE);
            } else if (contextObject instanceof View) {
                trig.setBaseType(Trigger.BaseType.VIEW);
            }
            trig.setBaseObjectID(contextObject.getID());
        }
    }

    @Override
    protected Collection<String> getPropsRequiredForNavigables() {
        return Collections.singletonList("baseType");
    }
}

