/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.components.ComponentFactoryImpl;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class BaseEditorPanel<T extends DBObject>
extends DBTraversablePanel {
    private Namespace m_context;
    private final ComponentFactoryImpl m_componentFactory;
    private DBValidationHandler m_validationHandler;
    private DBUILayoutHelper m_layout;
    private boolean m_entered;
    private boolean m_initialized;
    private DBObjectListener m_objListener;
    private DBObjectListener m_factoryObjListener;
    private DBEditorConfig m_lastConfig;

    protected BaseEditorPanel() {
        this(null);
    }

    protected BaseEditorPanel(String panelName) {
        if (panelName == null) {
            panelName = ((Object)((Object)this)).getClass().getSimpleName();
        }
        this.m_componentFactory = new DBUIHelper(panelName, (Component)((Object)this));
        this.setName(panelName);
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)((Object)this));
    }

    protected final Namespace getDataContext() {
        if (this.m_context == null) {
            throw new IllegalStateException("Cannot call getDataContext() until the panel has been entered");
        }
        return this.m_context;
    }

    protected final DBObjectProvider getProvider() {
        return this.getEditorConfig().getProvider();
    }

    @Deprecated
    protected final DBUIHelper getHelper() {
        return (DBUIHelper)this.m_componentFactory;
    }

    @Deprecated
    protected DBObject getHelperOriginalObject() {
        return this.getOriginalObject();
    }

    @Deprecated
    protected DBObject getHelperObject() {
        return this.getUpdatedObject();
    }

    public final ComponentFactory getComponentFactory() {
        return this.m_componentFactory;
    }

    public final ComponentWrapper getOrCreateWrapper(String propName) {
        propName = this.getComponentPath(propName);
        ComponentWrapper retval = this.getComponentFactory().findComponentWrapper(propName);
        if (retval == null) {
            retval = this.getComponentFactory().createWrapper(this.createComponentContext(propName));
            this.getComponentFactory().registerComponentWrapper(retval);
        }
        return retval;
    }

    protected String getComponentPath(String propName) {
        return propName;
    }

    protected final PropertyHelper getPropertyHelper() {
        return BaseEditorPanel.getPropertyHelper(this.getDataContext(), this.getProvider());
    }

    protected final boolean isEditing() {
        return this.getOriginalObject() != null;
    }

    protected final boolean isEntered() {
        return this.m_entered;
    }

    protected final boolean isInitialized() {
        return this.m_initialized;
    }

    protected final T getOriginalObject() {
        return (T)this.getEditorConfig().getOriginalObject();
    }

    protected final T getUpdatedObject() {
        return (T)this.getEditorConfig().getUpdatedObject();
    }

    @Deprecated
    protected final T getDBObject() {
        return this.getUpdatedObject();
    }

    protected final Schema[] getSchemaList() {
        return this.getEditorConfig().getSchemaList();
    }

    public final void onEntry(TraversableContext dataContext) {
        this.onEntry((Namespace)dataContext);
    }

    protected DBObject getComponentFactoryUpdatedObject() {
        return this.getHelperObject();
    }

    protected DBObject getComponentFactoryOriginalObject() {
        return this.getHelperOriginalObject();
    }

    private void setEntered(boolean entered) {
        PropertyAccess props;
        this.m_entered = entered;
        this.getComponentFactory().setActive(entered);
        this.setPanelInContext(entered, BaseEditorPanel.class.getName());
        String customKey = this.getCustomPanelKey();
        if (customKey != null) {
            this.setPanelInContext(entered, customKey);
        }
        Namespace dataContext = this.getDataContext();
        if (entered && dataContext.find(BaseEditorPanel.class) == this && (props = (PropertyAccess)dataContext.find(PropertyAccess.class)) != null) {
            this.loadSettings(props);
            dataContext.remove(PropertyAccess.class.getName());
        }
        if (this.m_initialized) {
            this.registerListener((DBObject)this.getUpdatedObject(), this.m_objListener, entered);
            this.registerListener(this.getComponentFactoryUpdatedObject(), this.m_factoryObjListener, entered);
        }
        if (entered) {
            this.startValidationHandler();
        } else {
            this.stopValidationHandler();
        }
    }

    private void registerListener(DBObject obj, DBObjectListener listener, boolean entered) {
        if (listener != null && obj != null) {
            if (entered) {
                obj.addObjectListener(listener);
            } else {
                obj.removeObjectListener(listener);
            }
        }
    }

    protected final DBValidationHandler getValidationHandler() {
        DBValidationManager fac;
        if (this.m_validationHandler == null && (fac = (DBValidationManager)this.getDataContext().find(DBValidationManager.class)) != null) {
            this.m_validationHandler = fac.createHandler(this.getEditorConfig(), this.getComponentFactory());
        }
        return this.m_validationHandler;
    }

    private void startValidationHandler() {
        DBValidationHandler handler = this.getValidationHandler();
        if (handler != null) {
            handler.startValidation(this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
        }
    }

    private void stopValidationHandler() {
        DBValidationHandler handler = this.getValidationHandler();
        if (handler != null) {
            handler.stopValidation();
        }
    }

    protected String getCustomPanelKey() {
        return null;
    }

    private void setPanelInContext(boolean entered, String panelKey) {
        if (entered) {
            if (this.m_context.get(panelKey) == null) {
                this.m_context.put(panelKey, (Object)this);
            }
        } else if (this.m_context.get(panelKey) == this) {
            this.m_context.remove(panelKey);
        }
    }

    final void onEntry(Namespace context) {
        this.m_context = context;
        this.setEntered(false);
        try {
            this.m_componentFactory.setDataContext(this.m_context);
            this.m_componentFactory.setEditable(this.isEditable());
            if (!this.m_initialized) {
                this.m_initialized = true;
                this.initialiseComponents();
                this.m_objListener = this.createObjectListener();
                this.m_factoryObjListener = this.createComponentFactoryObjectListener();
                this.m_componentFactory.setUpdatedObject(this.getComponentFactoryUpdatedObject());
                this.m_componentFactory.processComponents();
            } else if (this.getUpdatedObject() != null) {
                this.refreshComponents();
            }
            this.initialisePanel();
            DBUIMnemonicBuilder builder = new DBUIMnemonicBuilder((JPanel)((Object)this.getMnemonicBuilderPanel()), (JPanel)((Object)this));
            if (this.isInFlatEditor()) {
                builder.removeAll();
            } else {
                builder.build();
            }
            this.setEntered(true);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error entering panel", e);
        }
    }

    protected void refreshComponents() {
        this.m_componentFactory.refreshComponents(this.getComponentFactoryUpdatedObject());
    }

    protected DBEditorConfig getEditorConfig() {
        return (DBEditorConfig)this.getDataContext().find(DBEditorConfig.class);
    }

    protected boolean isEditable() {
        return this.getEditorConfig().isEditable();
    }

    protected final void processComponent(String propPath) {
        this.m_componentFactory.processComponent(propPath);
    }

    @Deprecated
    protected final void processComponent(Component comp) {
    }

    protected void initialiseComponents() {
    }

    protected abstract void initialisePanel();

    protected DBObjectListener createObjectListener() {
        return null;
    }

    protected DBObjectListener createComponentFactoryObjectListener() {
        return null;
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        this.onExit((Namespace)dataContext);
    }

    final void onExit(Namespace dataContext) throws TraversalException {
        this.m_context = dataContext;
        this.commitCurrentWrapper(true);
        try {
            this.setEntered(false);
            this.commitPanel();
            if (this.shouldValidateOnExit()) {
                this.validateObject();
                this.canCommit();
            }
        }
        catch (TraversalException te) {
            this.setEntered(true);
            throw te;
        }
    }

    protected void canCommit() throws TraversalException {
        this.m_componentFactory.canCommit(this.getEditorConfig());
    }

    protected boolean shouldValidateOnExit() {
        boolean retval = true;
        Namespace dataContext = this.getDataContext();
        PanelLibrary lib = (PanelLibrary)dataContext.find(PanelLibrary.class);
        if (lib != null) {
            retval = lib.shouldValidateOnExit(this, dataContext);
        }
        return retval;
    }

    protected void commitPanel() throws TraversalException {
    }

    protected void validateObject() throws TraversalException {
        try {
            this.doValidation(this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
        }
        catch (ValidationException ve) {
            this.processValidationException(ve);
        }
    }

    protected final void doValidation(DBObject originalObject, DBObject newObject) throws ValidationException {
        if (originalObject != null || newObject != null) {
            Collection<String> paths = this.getValidationPaths();
            if (paths != null && paths.size() > 0) {
                for (String prop : paths) {
                    try {
                        this.getProvider().validateObjectProperty(originalObject, newObject, prop);
                    }
                    catch (MissingValidatorException mve) {
                        this.getLogger().log(Level.WARNING, mve.getMessage());
                    }
                }
            } else {
                this.getProvider().validateObject(originalObject, newObject);
            }
        }
    }

    protected void processValidationException(ValidationException ve) throws TraversalException {
        String title = ve.getTitle();
        throw new TraversalException(ve.getMessage(), title == null ? this.getErrorTitle() : title);
    }

    protected final String getInternalName(String name) throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        T obj = this.getUpdatedObject();
        String type = obj.getType();
        try {
            pro.validateName(type, name);
        }
        catch (InvalidNameException ine) {
            String reason = ine.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(name, type) + " " + reason, this.getErrorTitle());
        }
        return pro.getInternalName(name);
    }

    protected String getErrorTitle() {
        T obj = this.getUpdatedObject();
        String type = DBTypeDisplayRegistry.getSingularDisplayName(obj.getType());
        return UIBundle.format("BASE_ERROR_TITLE", type, obj.getName());
    }

    protected String getInvalidNameMessage(String name, String objtype) {
        String type = DBTypeDisplayRegistry.getSingularDisplayName(objtype);
        if (ModelUtil.hasLength((String)name)) {
            return UIBundle.format("INVALID_NAME_MESSAGE", name, type);
        }
        return UIBundle.format("EMPTY_NAME_MESSAGE", type);
    }

    protected final String getExternalName(String name) {
        return this.getProvider().getExternalName(name);
    }

    protected final String getExternalName(String name, String type) {
        return this.getProvider().getExternalName(name, type);
    }

    protected final String getUniqueName(String base, ListModel model) {
        int size = model.getSize();
        HashSet<String> modelNames = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            Object element = model.getElementAt(i);
            modelNames.add(element.toString());
        }
        return DBUtil.getUniqueName(modelNames, (String)base);
    }

    protected Collection<String> getValidationPaths() {
        return this.getComponentFactory().getPaths();
    }

    protected ComponentContext createComponentContext(String propertyPath) {
        return this.getComponentFactory().createComponentContext(propertyPath, this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
    }

    public final boolean isInFlatEditor() {
        return this.getEditorConfig().isInFlatEditor();
    }

    protected DBUILayoutHelper getDBUILayoutHelper() {
        if (!this.m_initialized) {
            throw new IllegalStateException("Cannot get the layout helper before first call to initialiseComponents.");
        }
        if (this.m_layout == null) {
            this.m_layout = new DBUILayoutHelper((JPanel)((Object)this), this.isInFlatEditor());
        }
        return this.m_layout;
    }

    protected void commitCurrentWrapper() {
        this.commitCurrentWrapper(false);
    }

    private void commitCurrentWrapper(boolean exit) {
        AsynchronousComponentWrapper.commitCurrentWrapper(this.getDataContext(), exit);
    }

    @Override
    public Component getDefaultFocusComponent() {
        JTextComponent retval = null;
        ComponentWrapper wrapper = this.getComponentFactory().findComponentWrapper("name");
        if (wrapper != null) {
            retval = (JTextComponent)wrapper.getActiveComponent();
        }
        return retval;
    }

    public void saveSettings(PropertyAccess props) {
    }

    protected void loadSettings(PropertyAccess props) {
    }

    protected final <D extends DBObject> D getInitialSelection(Class<D> childClz) {
        DBObject retval = null;
        DBEditorConfig config = this.getEditorConfig();
        if (config != this.m_lastConfig && (retval = DBUtil.findParentOfType((DBObject)this.getEditorConfig().getChildObject(), childClz)) != null) {
            this.m_lastConfig = config;
        }
        return (D)retval;
    }

    public ComponentWrapper<? extends BaseEditorPanel> createPanelWrapper() {
        return new BaseEditorPanelWrapper();
    }

    public ComponentWrapper<JButton> createButtonWrapper() {
        return new BaseEditorPanelButtonWrapper();
    }

    public static PropertyHelper getPropertyHelper(Namespace dataContext, DBObjectProvider pro) {
        PropertyHelper retval = (PropertyHelper)dataContext.find(PropertyHelper.class);
        if (retval == null) {
            retval = new PropertyHelper(pro);
            dataContext.put(PropertyHelper.class.getName(), (Object)retval);
        }
        return retval;
    }

    private BaseEditorPanel getMnemonicBuilderPanel() {
        BaseEditorPanel panel;
        for (Object comp = panel = this; comp != null; comp = ((Component)comp).getParent()) {
            if (!(comp instanceof BaseEditorPanel)) continue;
            panel = comp;
        }
        return panel;
    }

    class BaseEditorPanelButtonWrapper
    extends ComponentWrapper<JButton> {
        private String m_title;

        BaseEditorPanelButtonWrapper() {
            super(new JButton());
        }

        @Override
        public Object getPropertyValue() {
            return this.getExistingPropertyValue();
        }

        @Override
        public void setPropertyValue(Object val) {
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        protected void initialiseComponent() {
            this.m_title = PropertyDisplayRegistry.getDisplayName(this.getPropertyName(), this.getProvider(), this.getUpdatedObject());
            JButton button = (JButton)this.getActiveComponent();
            button.setText(this.m_title + "...");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseEditorPanelButtonWrapper.this.launchDialog();
                }
            });
        }

        private void launchDialog() {
            Namespace data = new Namespace(this.getComponentContext().getDataContext());
            DBEditorConfig config = (DBEditorConfig)data.find(DBEditorConfig.class.getName());
            BaseEditorPanel.this.getComponentFactory().setBasePath(this.getComponentContext().getBasePath());
            if (config != null) {
                DBEditorConfig clonedConfig = DBEditorConfig.newClonedConfig(config);
                BaseDBEditorFactory.setEditorType(clonedConfig, DBEditorFactory.EditorType.EDIT_MODAL);
                data.put(DBEditorConfig.class.getName(), (Object)clonedConfig);
            }
            TDialogLauncher launcher = new TDialogLauncher(this.getActiveComponent(), this.m_title, (Traversable)BaseEditorPanel.this, data);
            launcher.setInitialSize(this.getDialogInitialSize());
            JEWTDialog dialog = launcher.initDialog();
            dialog.setName(this.getPropertyName() + "-Dialog");
            dialog.setButtonMask(5);
            launcher.showDialog();
        }

        protected Dimension getDialogInitialSize() {
            return new Dimension(600, 320);
        }
    }

    class BaseEditorPanelWrapper<T extends BaseEditorPanel>
    extends ComponentWrapper<T> {
        private boolean m_entered;

        BaseEditorPanelWrapper() {
            super(BaseEditorPanel.this);
        }

        @Override
        public Object getPropertyValue() {
            return this.getExistingPropertyValue();
        }

        @Override
        public void setPropertyValue(Object val) {
            this.enterComponent();
        }

        protected void enterComponent() {
            if (this.m_entered) {
                this.exitComponent();
            }
            this.m_entered = true;
            ((BaseEditorPanel)((Object)this.getActiveComponent())).onEntry(this.getTraversableContext());
        }

        protected void exitComponent() {
            if (this.m_entered) {
                this.m_entered = false;
                try {
                    ((BaseEditorPanel)((Object)this.getActiveComponent())).onExit(this.getTraversableContext());
                }
                catch (TraversalException te) {
                    this.getLogger().severe(te.getMessage());
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error entering panel", e);
                }
            }
        }

        protected TraversableContext getTraversableContext() {
            return new TraversableContext(this.getComponentContext().getDataContext(), 0);
        }

        @Override
        protected void setActiveImpl(boolean active) {
            if (!active) {
                this.exitComponent();
            }
        }

        @Override
        public Component getDefaultFocusComponent() {
            return ((BaseEditorPanel)((Object)this.getActiveComponent())).getDefaultFocusComponent();
        }

        @Override
        protected Component getDefaultValidationComponent() {
            return null;
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        public JLabel getLabel() {
            return null;
        }
    }
}

