/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public abstract class BaseEditorTabTable<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final GenericTable m_table = new GenericTable();
    private final TabTableModel m_tableModel = new TabTableModel(this.getColumnNames(), this.getColumnTypes());

    public BaseEditorTabTable(String name, String propPath) {
        super(name, propPath);
        this.m_table.setName(name + ".Table");
        this.m_table.setModel((TableModel)this.m_tableModel);
        this.m_table.setRolloverHighlightingEnabled(false);
        this.layoutTable();
    }

    private void layoutTable() {
        DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)((Object)this), true);
        JScrollPane pane = new JScrollPane((Component)this.m_table);
        pane.setPreferredSize(new Dimension(400, 100));
        ReorderableTableWithTitleBar reorderTable = new ReorderableTableWithTitleBar((JTable)this.m_table, (JComponent)pane, false, true);
        this.configureToolBar(reorderTable.getTableToolbar());
        layout.add((Component)reorderTable, 1, 1, true, true);
        layout.layout();
    }

    public P getParentObject() {
        return (P)this.getUpdatedObject();
    }

    protected void setDefaultRenderer(TableCellRenderer renderer, Class columnClz) {
        this.m_table.setDefaultRenderer(columnClz, renderer);
    }

    protected void clearRows() {
        this.m_tableModel.clearRows();
    }

    @Override
    protected void initialisePanel() {
        Object contextObj = this.getChildObject();
        this.setChildContext(contextObj);
    }

    protected void addRow(int rowIndx, Object ... columnValues) {
        this.m_tableModel.addRow(rowIndx, columnValues);
    }

    public abstract void setChildContext(C var1);

    protected abstract void configureToolBar(TableToolbar var1);

    protected abstract String[] getColumnNames();

    protected abstract Class[] getColumnTypes();

    private class TabTableModel
    extends DefaultTableModel {
        private ArrayList<ArrayList<Object>> m_rowData = new ArrayList();
        private Class[] m_columnTypes;
        private String[] m_columnNames;

        public TabTableModel(String[] columnNames, Class[] columnTypes) {
            this.m_columnNames = columnNames;
            this.m_columnTypes = columnTypes;
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.m_rowData != null ? this.m_rowData.size() : 0;
        }

        @Override
        public String getColumnName(int colIndx) {
            return this.m_columnNames[colIndx];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int colIndx) {
            return this.m_columnTypes[colIndx];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ArrayList<Object> rowColumns;
            Object retVal = null;
            if (rowIndex < this.m_rowData.size() && columnIndex < (rowColumns = this.m_rowData.get(rowIndex)).size()) {
                retVal = rowColumns.get(columnIndex);
            }
            return retVal;
        }

        public void clearRows() {
            this.m_rowData.clear();
        }

        public void addRow(int rowIndx, Object ... colValues) {
            ArrayList<Object> rowList = new ArrayList<Object>();
            for (Object colVal : colValues) {
                rowList.add(colVal);
            }
            this.m_rowData.add(rowIndx, rowList);
        }
    }
}

