/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.TitledSeparator;

public abstract class ChildObjectDefineEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final JCheckBox m_chkDefine = new JCheckBox();
    private TitledSeparator m_titledSeparator;
    private C m_lastChild;

    public ChildObjectDefineEditorPanel(String panelName, String basePath) {
        super(panelName, basePath, true);
        this.m_chkDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChildObjectDefineEditorPanel.this.checkBoxChanged();
            }
        });
    }

    protected JCheckBox getDefineCheckBox() {
        return this.m_chkDefine;
    }

    private void checkBoxChanged() {
        if (this.isEntered()) {
            boolean selected = this.m_chkDefine.isSelected();
            Object existingChild = this.getChildObject();
            ChildDBObject newChild = selected ? (existingChild == null ? (this.m_lastChild == null ? (ChildDBObject)this.getProvider().getObjectFactory().newObject(this.getChildClass()) : (ChildDBObject)this.m_lastChild) : (ChildDBObject)existingChild) : null;
            if (newChild != existingChild) {
                this.setChildOnParent(newChild);
                this.getComponentFactory().refreshComponents(this.getComponentFactoryUpdatedObject());
                if (newChild == null) {
                    this.m_lastChild = existingChild;
                }
            }
            this.enabledChildComponents(selected);
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.m_chkDefine.setEnabled(enable);
        if (this.isInitialized()) {
            this.enabledChildComponents(this.m_chkDefine.isSelected() && enable);
        }
    }

    protected void enabledChildComponents(boolean enable) {
        if (!enable || this.isEnabled()) {
            this.getComponentFactory().setEnabled(enable);
        }
    }

    private boolean isDefineSeparatorVisible() {
        String path = Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), this.getPropertyPath()});
        return this.getProvider().getPropertyManager().canCreateProperty((SystemObject)this.getUpdatedObject(), path);
    }

    @Override
    protected final void initialiseChildComponents() {
        super.initialiseChildComponents();
        DBUILayoutHelper topLayout = this.getDBUILayoutHelper();
        topLayout.setMargins(0);
        String propDisplayName = PropertyDisplayRegistry.getDisplayName(this.getPropertyPath(), this.getProvider(), this.getComponentFactoryUpdatedObject());
        DBUIResourceHelper reshelp = this.getComponentFactory().getResourceHelper();
        reshelp.resButton(this.m_chkDefine, UIBundle.format("STORAGE_INFO_PANEL_TITLE", propDisplayName), "Define");
        DBUILayoutHelper innerLayout = topLayout.newTitledHelper(this.m_chkDefine, 1, 1, true, false);
        this.m_titledSeparator = innerLayout.getTitleSeparator();
        this.initialiseChildComponents(innerLayout);
        topLayout.pushUp();
        innerLayout.layout();
        topLayout.layout();
    }

    protected abstract void initialiseChildComponents(DBUILayoutHelper var1);

    protected abstract Class<? extends C> getChildClass();

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        boolean hasChild = this.getChildObject() != null;
        this.m_chkDefine.setSelected(hasChild);
        this.enabledChildComponents(hasChild);
        this.m_titledSeparator.setVisible(this.isDefineSeparatorVisible());
        this.m_lastChild = null;
    }
}

