/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;

public abstract class ChildSelectableComponentEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseChildrenEditorPanel<C, P> {
    private SelectableComponent m_selectableComponent;
    private ListButtons m_listButtons;

    public ChildSelectableComponentEditorPanel(String panelName) {
        super(panelName);
    }

    protected abstract String getListLabel();

    protected abstract SelectableComponent createSelectableComponent();

    protected abstract void populateComponent();

    protected ListButtons createListButtons() {
        return null;
    }

    protected ListButtons.Controller createButtonsHelper() {
        return new DefaultButtonsHelper();
    }

    protected void listSelectionChanged() {
        Object currentChild;
        ChildDBObject newChild = null;
        SelectableComponent comp = this.getSelectableComponent();
        int[] sel = comp.getSelectedIndices();
        if (sel != null && sel.length == 1) {
            newChild = (ChildDBObject)comp.get(sel[0]);
        }
        if ((currentChild = this.getCurrentChild()) == newChild || this.exitChildPanel()) {
            this.enterChildPanel(newChild);
        } else {
            comp.setSelectedIndices(comp.indexOf(currentChild));
        }
    }

    @Override
    protected void initialiseComponents() {
        this.layoutComponents(this.getChildProperty());
    }

    protected final JTextComponent getNameField() {
        return this.getChildPanel().getNameField();
    }

    protected final SelectableComponent getSelectableComponent() {
        if (this.m_selectableComponent == null) {
            this.m_selectableComponent = this.createSelectableComponent();
        }
        return this.m_selectableComponent;
    }

    protected final ListButtons getListButtons() {
        if (this.m_listButtons == null) {
            this.m_listButtons = this.createListButtons();
        }
        return this.m_listButtons;
    }

    @Override
    protected void initialisePanel() {
        Object wasSelected = this.getCurrentChild();
        this.getSelectableComponent().clear();
        this.setCurrentChild(null);
        this.populateComponent();
        Object firstChild = this.getInitialChild(wasSelected);
        this.selectChild(firstChild);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (!this.exitChildPanel()) {
            throw new TraversalException(null);
        }
    }

    @Override
    protected void currentChildNameChanged() {
        ChildObjectEditorPanel childPanel;
        if (this.getCurrentChild() != null && (childPanel = this.getChildPanel()) != null) {
            ((Component)this.getSelectableComponent().getComponent()).repaint();
        }
    }

    @Override
    protected final void selectChild(C child) {
        Object currentChild = this.getCurrentChild();
        if (currentChild != child && (currentChild == null || this.exitChildPanel())) {
            this.getSelectableComponent().setSelectedIndices(this.getSelectableComponent().indexOf(child));
            if (!this.isEntered()) {
                this.listSelectionChanged();
            }
        }
        if (child == null && !this.getChildPanel().isEntered()) {
            if (this.getListButtons() != null) {
                this.getListButtons().enableButtons();
            }
            this.enterChildPanel(null);
        }
    }

    private void layoutComponents(String ... propPath) {
        this.m_selectableComponent = this.createSelectableComponent();
        DBUILayoutHelper pnlListLayout = this.getDBUILayoutHelper();
        Component childComponent = this.getChildPanel().getComponent();
        boolean leftRightSplit = this.isHorizontalSplit();
        ListButtons listButtons = this.getListButtons();
        if (listButtons != null) {
            JComponent pnlList = listButtons.getComponent();
            this.getComponentFactory().getResourceHelper().setName(pnlList, "ChildListPanel");
            pnlListLayout.add(pnlList, 1, 1, !leftRightSplit, leftRightSplit);
            if (leftRightSplit) {
                childComponent = pnlListLayout.wrapForInvisibility(childComponent);
            } else {
                pnlListLayout.nextRow();
            }
        }
        this.getComponentFactory().registerComponent(listButtons == null ? null : listButtons.getLabel(), (Component)this.getSelectableComponent().getComponent(), this.getListLabel(), "ChildList", Property.createPath((String[])propPath));
        pnlListLayout.add(childComponent, 1, 1, true, true);
        pnlListLayout.layout();
        this.getSelectableComponent().addSelectionListener(new SelectableComponent.SelectionListener(){

            @Override
            public void valueChanged(SelectableComponent.SelectionEvent event) {
                if (ChildSelectableComponentEditorPanel.this.isEntered()) {
                    ChildSelectableComponentEditorPanel.this.listSelectionChanged();
                }
            }
        });
    }

    @Override
    public ComponentWrapper<JButton> createButtonWrapper() {
        return new ChildSelectableComponentEditorPanelButtonWrapper();
    }

    private class ChildSelectableComponentEditorPanelButtonWrapper
    extends BaseEditorPanel.BaseEditorPanelButtonWrapper {
        private ChildSelectableComponentEditorPanelButtonWrapper() {
        }

        @Override
        protected Dimension getDialogInitialSize() {
            return new Dimension(660, 450);
        }
    }

    protected class DefaultButtonsHelper
    extends ListButtons.Controller {
        protected DefaultButtonsHelper() {
        }

        @Override
        public void addToList() {
            SelectableComponent comp = this.getSelectableComponent();
            if (ChildSelectableComponentEditorPanel.this.exitChildPanel()) {
                Object child = ChildSelectableComponentEditorPanel.this.newChild();
                comp.add(child);
                ChildSelectableComponentEditorPanel.this.selectChild(child);
                ChildSelectableComponentEditorPanel.this.commitChildProperty();
                JTextComponent txt = ChildSelectableComponentEditorPanel.this.getChildPanel().getNameField();
                if (txt != null) {
                    txt.requestFocusInWindow();
                }
            } else {
                comp.setSelectedIndices(comp.indexOf(ChildSelectableComponentEditorPanel.this.getCurrentChild()));
            }
        }

        @Override
        public void removeFromList() {
            SelectableComponent comp = this.getSelectableComponent();
            int[] selected = comp.getSelectedIndices();
            if (selected != null && selected.length > 0) {
                int numSelected = selected.length;
                ChildSelectableComponentEditorPanel.this.setCurrentChild(null);
                Arrays.sort(selected);
                for (int selectIndx = numSelected - 1; selectIndx > -1; --selectIndx) {
                    comp.remove(selected[selectIndx]);
                }
                int lastSelectIndex = selected[numSelected - 1];
                int newSelectIndx = lastSelectIndex - numSelected + 1;
                int remaining = comp.size();
                if (newSelectIndx == remaining) {
                    --newSelectIndx;
                }
                ChildSelectableComponentEditorPanel.this.commitChildProperty();
                ChildSelectableComponentEditorPanel.this.selectChild(newSelectIndx >= 0 ? (ChildDBObject)comp.get(newSelectIndx) : null);
            }
        }

        @Override
        public boolean canAdd() {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        public boolean canAdd(Object val) {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canRemove() {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canRemove(Object val) {
            return ChildSelectableComponentEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public String getBaseName() {
            return ChildSelectableComponentEditorPanel.this.getComponentFactory().getResourceHelper().getPanelName();
        }

        @Override
        public String getListLabel() {
            return ChildSelectableComponentEditorPanel.this.getListLabel();
        }

        @Override
        public boolean useResizeComponent() {
            return ChildSelectableComponentEditorPanel.this.isInFlatEditor();
        }

        @Override
        public void objectMovedDown(Object obj) {
            ChildSelectableComponentEditorPanel.this.commitChildProperty();
        }

        @Override
        public void objectMovedUp(Object obj) {
            ChildSelectableComponentEditorPanel.this.commitChildProperty();
        }
    }
}

