/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;

public abstract class ChildTableTabPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private TableColumnsTabbedPanel m_tabPane;
    private Map<Class, Navigable> m_tabsMap;
    private final List<TabSelectedListener> m_listeners = new ArrayList<TabSelectedListener>();
    private int m_defaultTabIndex = -1;

    protected ChildTableTabPanel(String panelName, String basePath, int defaultTabIndex) {
        super(panelName, basePath);
        this.m_defaultTabIndex = defaultTabIndex;
    }

    protected ChildTableTabPanel(String panelName, String basePath) {
        this(panelName, basePath, -1);
    }

    @Override
    protected void initialiseChildComponents() {
        this.addTabs();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add((Component)((Object)this.m_tabPane));
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.onTabEntry();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        TraversableContext tc = new TraversableContext(this.getDataContext(), 0);
        this.m_tabPane.ignoreListeners(true);
        this.m_tabPane.onExit(tc);
        this.m_tabPane.ignoreListeners(false);
        super.commitPanel();
    }

    protected void onTabEntry() {
        if (this.m_tabPane != null) {
            TraversableContext tc = new TraversableContext(this.getDataContext(), 0);
            tc.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)this.m_defaultTabIndex);
            this.m_tabPane.ignoreListeners(true);
            this.m_tabPane.onEntry(tc);
            this.m_tabPane.ignoreListeners(false);
            this.enableTabs();
            this.validate();
            this.repaint();
        }
    }

    protected abstract Collection<Navigable> getTabs();

    private void addTabs() {
        Collection<Navigable> tabNavs = this.getTabs();
        this.m_tabsMap = new HashMap<Class, Navigable>();
        for (Navigable nav : tabNavs) {
            this.m_tabsMap.put(nav.getTraversableClass(), nav);
        }
        Navigable[] navs = tabNavs.toArray(new Navigable[tabNavs.size()]);
        this.m_tabPane = new TableColumnsTabbedPanel(navs);
    }

    protected Navigable createNavigable(String tabHeader, Class tabClass, String ... properties) {
        DBNavigable nav = new DBNavigable(tabHeader, tabClass);
        if (properties != null) {
            nav.setProperties(Arrays.asList(properties));
        }
        return nav;
    }

    protected void setEnabledTab(Class tabClass, boolean enabled) {
        Navigable nav = this.m_tabsMap.get(tabClass);
        if (nav != null) {
            this.m_tabPane.enableTabForNavigable(nav, enabled);
        }
    }

    public final void addTabSelectedListener(TabSelectedListener l) {
        this.m_listeners.add(l);
    }

    public final void removeTabSelectedListener(TabSelectedListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyTabListeners() {
        for (TabSelectedListener cl : this.m_listeners) {
            cl.tabSelected();
        }
    }

    public void selectDefaultTab(int defaultTabIndex) {
        this.m_defaultTabIndex = defaultTabIndex;
        this.onTabEntry();
    }

    protected void enableTabs() {
    }

    public static interface TabSelectedListener {
        public void tabSelected();
    }

    private class TableColumnsTabbedPanel
    extends DBTabbedPanel {
        private boolean m_ignoreListeners;

        public TableColumnsTabbedPanel(Navigable[] rootNavigables) {
            super(rootNavigables);
            this.setBaseEditorPanel(ChildTableTabPanel.this);
        }

        @Override
        public Navigable getCurrentNavigable() {
            if (!this.m_ignoreListeners) {
                ChildTableTabPanel.this.m_defaultTabIndex = 0;
                ChildTableTabPanel.this.notifyTabListeners();
            }
            return super.getCurrentNavigable();
        }

        public void ignoreListeners(boolean ignore) {
            this.m_ignoreListeners = ignore;
        }
    }
}

