/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.beans.PropertyChangeEvent;
import java.math.BigInteger;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;

public class IncrementerPanel<T extends AbstractIncrementer>
extends BaseEditorPanel<AbstractIncrementer> {
    private final boolean m_useTwoColumns;

    protected IncrementerPanel() {
        this(null, false);
    }

    protected IncrementerPanel(String baseProperyPath, boolean useTwoColumns) {
        this.m_useTwoColumns = useTwoColumns;
        this.getComponentFactory().setBasePath(baseProperyPath);
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"cacheFlag"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                IncrementerPanel.this.setCacheFlag(pce.getNewValue());
            }
        };
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwStartWith = this.getOrCreateWrapper("startWith");
        ComponentWrapper cwIncrement = this.getOrCreateWrapper("incrementBy");
        ComponentWrapper cwMinValue = this.getOrCreateWrapper("minValue");
        ComponentWrapper cwMaxValue = this.getOrCreateWrapper("maxValue");
        ComponentWrapper cwCacheSize = this.getOrCreateWrapper("cacheSize");
        ComponentWrapper cwCache = this.getOrCreateWrapper("cacheFlag");
        ComponentWrapper cwCycle = this.getOrCreateWrapper("cycleFlag");
        ComponentWrapper cwOrder = this.getOrCreateWrapper("orderFlag");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add(cwStartWith);
        if (!this.m_useTwoColumns) {
            layout.nextRow();
        }
        layout.add(cwIncrement);
        layout.nextRow();
        layout.add(cwMinValue);
        if (!this.m_useTwoColumns) {
            layout.nextRow();
        }
        layout.add(cwMaxValue);
        layout.nextRow();
        layout.add(cwCache);
        if (!this.m_useTwoColumns) {
            layout.nextRow();
        }
        layout.add(cwCacheSize);
        if (!this.m_useTwoColumns) {
            layout.indent(cwCacheSize.getLabel());
        }
        layout.nextRow();
        layout.add(cwCycle);
        layout.nextRow();
        layout.add(cwOrder);
        this.completeLayout();
    }

    @Override
    protected void initialisePanel() {
        AbstractIncrementer model = (AbstractIncrementer)this.getComponentFactoryUpdatedObject();
        if (model != null) {
            this.setCacheFlag(model.getCacheFlag());
        }
    }

    protected void completeLayout() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.nextRow();
        layout.pushUp();
        layout.layout();
    }

    private void setCacheFlag(Object cacheFlag) {
        boolean cached = Boolean.TRUE.equals(cacheFlag);
        ComponentWrapper cacheSizeWrapper = this.getOrCreateWrapper("cacheSize");
        cacheSizeWrapper.setEnabled(cached);
        cacheSizeWrapper.setPropertyValue(cached ? this.getCacheSizeDefault() : null);
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger twenty;
        AbstractIncrementer seq = (AbstractIncrementer)this.getComponentFactoryUpdatedObject();
        BigInteger max = seq.getMaxValue();
        BigInteger min = seq.getMinValue();
        BigInteger inc = seq.getIncrementBy();
        if (inc == null || inc.equals(BigInteger.ZERO)) {
            inc = BigInteger.ONE;
        }
        if (max == null) {
            max = inc.signum() > 0 ? BigInteger.valueOf(10L).pow(27) : BigInteger.ONE.negate();
        }
        if (min == null) {
            min = inc.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10L).pow(26).negate();
        }
        BigInteger[] dr = max.subtract(min).abs().divideAndRemainder(inc.abs());
        BigInteger def = dr[0];
        if (dr[1].signum() > 0) {
            def = def.add(BigInteger.ONE);
        }
        if (def.subtract(twenty = new BigInteger("20")).signum() > 0) {
            def = twenty;
        }
        return def;
    }

    @Override
    protected DBObject getComponentFactoryUpdatedObject() {
        DBObject obj = (DBObject)this.getDataContext().find("NewChildObject");
        if (obj instanceof Column) {
            return ((Column)obj).getIdentityProperties();
        }
        return this.getUpdatedObject();
    }

    @Override
    protected DBObject getComponentFactoryOriginalObject() {
        DBObject orig = null;
        DBObject obj = this.getComponentFactoryUpdatedObject();
        if (obj != null && obj.getID() instanceof TemporaryObjectID) {
            try {
                orig = ((TemporaryObjectID)obj.getID()).resolveOriginalID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return orig;
    }
}

