/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.ChildTableTabPanel;
import sun.swing.DefaultLookup;

public class TableWithTabbedChildSplitPane
extends JSplitPane {
    private static final int NO_TAB = -1;
    private static final int DEFAULT_TAB = 0;
    private static final int MINIMUM_BOTTOM_SIZE = 38;
    private static final int MINIMUM_TOP_SIZE = 87;
    private static final int DEFAULT_DIVIDER_LOCATION = 250;
    private ChildTableTabPanel.TabSelectedListener m_tabsList;

    public TableWithTabbedChildSplitPane(Component newTopComponent, ChildTableTabPanel newTabbedComponent) {
        super(0, newTopComponent, (Component)((Object)newTabbedComponent));
        TableWithTabbedChildSplitPaneUI tabbedUI = new TableWithTabbedChildSplitPaneUI();
        this.setUI(tabbedUI);
        this.setOneTouchExpandable(true);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        final TableWithTabbedChildSplitPaneUI.TableWithTabbedChildDivider divider = tabbedUI.getDivider();
        divider.setLocation(0, divider.getMinimumLocation());
        this.m_tabsList = new ChildTableTabPanel.TabSelectedListener(){

            @Override
            public void tabSelected() {
                if (divider.isTableExpanded()) {
                    divider.getContractTableButton().doClick();
                }
            }
        };
        newTabbedComponent.addTabSelectedListener(this.m_tabsList);
        newTabbedComponent.setMinimumSize(new Dimension(0, 0));
        newTabbedComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = e.getComponent().getSize();
                if (size.getHeight() == 0.0) {
                    TableWithTabbedChildSplitPane.this.setDividerLocation(divider.getMinimumLocation());
                    TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                    divider.getContractTableButton().setEnabled(true);
                    divider.m_isTableExpanded = true;
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                divider.preserveLocation();
            }
        });
        newTopComponent.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public TableWithTabbedChildSplitPaneUI getUI() {
        return (TableWithTabbedChildSplitPaneUI)super.getUI();
    }

    private void selectTabWithDefaultIndex(int defaultTabIndex) {
        ChildTableTabPanel tabPanel = (ChildTableTabPanel)((Object)this.getBottomComponent());
        tabPanel.removeTabSelectedListener(this.m_tabsList);
        tabPanel.selectDefaultTab(defaultTabIndex);
        tabPanel.addTabSelectedListener(this.m_tabsList);
    }

    public class TableWithTabbedChildSplitPaneUI
    extends BasicSplitPaneUI {
        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new TableWithTabbedChildDivider(this);
        }

        @Override
        public TableWithTabbedChildDivider getDivider() {
            return (TableWithTabbedChildDivider)super.getDivider();
        }

        public class TableWithTabbedChildDivider
        extends BasicSplitPaneDivider {
            boolean m_isTableExpanded;
            boolean m_dragging;
            int m_splitLocation;

            TableWithTabbedChildDivider(BasicSplitPaneUI ui) {
                super(ui);
                this.m_isTableExpanded = true;
                this.m_dragging = false;
                this.m_splitLocation = 250;
            }

            @Override
            protected void oneTouchExpandableChanged() {
                if (!DefaultLookup.getBoolean(this.splitPane, this.splitPaneUI, "SplitPane.supportsOneTouchButtons", true)) {
                    return;
                }
                if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
                    DBUIResourceHelper reshelp = new DBUIResourceHelper("TableWithTabbedChildSplitPane");
                    this.leftButton = this.createLeftOneTouchButton();
                    reshelp.setName(this.leftButton, "leftButton");
                    if (this.leftButton != null) {
                        this.leftButton.addActionListener(new CustomOneTouchActionHandler(true));
                    }
                    this.rightButton = this.createRightOneTouchButton();
                    reshelp.setName(this.rightButton, "rightButton");
                    if (this.rightButton != null) {
                        this.rightButton.addActionListener(new CustomOneTouchActionHandler(false));
                    }
                    if (this.leftButton != null && this.rightButton != null) {
                        this.add(this.leftButton);
                        this.add(this.rightButton);
                    }
                }
                this.doRevalidate();
            }

            public void preserveLocation() {
                if (this.m_isTableExpanded) {
                    this.splitPane.setDividerLocation(this.getMinimumLocation());
                }
            }

            public int getMinimumLocation() {
                return this.splitPane.getHeight() - 38;
            }

            private int getSplitLocation() {
                return this.m_splitLocation;
            }

            private void setSplitLocation(int location) {
                boolean selectTab = false;
                int newLoc = location;
                if (this.m_dragging) {
                    if (location < 87) {
                        newLoc = 87;
                        selectTab = true;
                    } else if (location > 250 && location < this.getMinimumLocation()) {
                        if (!this.m_isTableExpanded) {
                            newLoc = this.getMinimumLocation();
                        } else {
                            newLoc = 250;
                            selectTab = true;
                        }
                    } else if (location >= this.getMinimumLocation()) {
                        newLoc = this.getMinimumLocation();
                    } else if (this.m_isTableExpanded) {
                        selectTab = true;
                    }
                    if (this.m_isTableExpanded && selectTab) {
                        this.m_isTableExpanded = false;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(0);
                        this.enableButtons(true, false);
                    } else if (!this.m_isTableExpanded && newLoc == this.getMinimumLocation()) {
                        this.m_isTableExpanded = true;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                        this.enableButtons(false, true);
                    }
                    this.m_splitLocation = newLoc != this.getMinimumLocation() ? newLoc : 250;
                }
                this.m_dragging = false;
                this.splitPane.setDividerLocation(newLoc);
            }

            @Override
            protected void finishDraggingTo(int location) {
                super.finishDraggingTo(location);
                this.m_dragging = true;
                this.setSplitLocation(location);
            }

            private void doRevalidate() {
                this.invalidate();
                if (this.splitPane != null) {
                    this.splitPane.revalidate();
                }
            }

            private JButton getContractTableButton() {
                return this.leftButton;
            }

            private boolean isTableExpanded() {
                return this.m_isTableExpanded;
            }

            private void enableButtons(boolean enableLeft, boolean enableRight) {
                this.leftButton.setEnabled(enableLeft);
                this.leftButton.setEnabled(enableRight);
            }

            private class CustomOneTouchActionHandler
            implements ActionListener {
                private final boolean isLeft;

                CustomOneTouchActionHandler(boolean isLeft) {
                    this.isLeft = isLeft;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int currLoc = TableWithTabbedChildDivider.this.splitPane.getDividerLocation();
                    int splitterLoc = TableWithTabbedChildDivider.this.getSplitLocation();
                    int minLoc = TableWithTabbedChildDivider.this.getMinimumLocation();
                    int newLoc = currLoc;
                    if (this.isLeft) {
                        newLoc = splitterLoc;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(0);
                        TableWithTabbedChildDivider.this.enableButtons(true, false);
                        TableWithTabbedChildDivider.this.m_isTableExpanded = false;
                    } else {
                        newLoc = minLoc;
                        TableWithTabbedChildDivider.this.m_isTableExpanded = true;
                        TableWithTabbedChildSplitPane.this.selectTabWithDefaultIndex(-1);
                        TableWithTabbedChildDivider.this.enableButtons(false, true);
                    }
                    TableWithTabbedChildDivider.this.splitPane.setDividerLocation(newLoc);
                }
            }
        }
    }
}

