/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class TraversableProxy
implements Traversable {
    private final Traversable m_traversable;
    private boolean m_enabled;
    private TraversableContext m_lastContext;

    public TraversableProxy(Traversable traversable) {
        this.m_traversable = traversable;
    }

    public void enable() {
        this.m_enabled = true;
        if (this.m_lastContext != null) {
            this.onEntry(this.m_lastContext);
            this.m_lastContext = null;
        }
    }

    public void onEntry(TraversableContext dataContext) {
        if (this.m_enabled) {
            this.m_traversable.onEntry(dataContext);
        } else {
            this.m_lastContext = dataContext;
        }
    }

    public Component getComponent() {
        return this.m_traversable.getComponent();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_traversable.onExit(dataContext);
    }

    public Object getExitTransition() {
        return this.m_traversable.getExitTransition();
    }

    public String getHelpID() {
        return this.m_traversable.getHelpID();
    }
}

