/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mviewlog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JLabel;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.icons.OracleIcons;

public class MViewLogHeader
extends BaseEditorPanel<MaterializedViewLog>
implements ActionListener {
    private JLabel m_lblSchema = new JLabel();
    private DBObjectChooser m_cmbOwner = new DBObjectChooser("SCHEMA");
    private JLabel m_lblMasterTable = new JLabel();
    private SchemaObjectComboBox m_cmbMasterTable = new SchemaObjectComboBox();
    private JLabel m_templateHint = new JLabel();
    private boolean m_firstInit = true;
    private boolean m_listening;
    private HashMap m_tableNameAndIdHash = new HashMap();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("MViewLogHeader");

    public MViewLogHeader() {
        this.setLayout(new GridBagLayout());
        this.m_cmbOwner.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (MViewLogHeader.this.m_listening) {
                    try {
                        MViewLogHeader.this.commitPanel();
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                    MViewLogHeader.this.m_listening = true;
                }
            }
        });
        this.m_resHelper.resLabel(this.m_lblSchema, this.m_cmbOwner, UIBundle.format("LABEL_IDPROP_SCHEMA", DisplayNames.getPropertyDisplayName((String)"masterTableID")), "_cmbOwner");
        this.add(this.m_lblSchema, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.add(this.m_cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cmbMasterTable.addActionListener(this);
        this.m_resHelper.resLabel(this.m_lblMasterTable, this.m_cmbMasterTable, DisplayNames.getPropertyDisplayName((String)"masterTableID") + ":", "_cmbMasterTable");
        this.add(this.m_lblMasterTable, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_cmbMasterTable, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_templateHint, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public void commitPanel() throws TraversalException {
        String name;
        if (this.getEditorConfig().isEdit()) {
            return;
        }
        MaterializedViewLog mvl = (MaterializedViewLog)this.getUpdatedObject();
        this.m_listening = false;
        Schema oldSchema = mvl.getSchema();
        Schema schema = (Schema)this.m_cmbOwner.getDBObject();
        String oldName = mvl.getName();
        SchemaObjectDescriptor sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
        String string = name = sod == null ? null : sod.getName();
        if (!DBUtil.areNamesAndTypesEqual((DBObject)schema, (DBObject)oldSchema)) {
            HashMap<String, PropertyChangeEvent> props = new HashMap<String, PropertyChangeEvent>(2);
            mvl.setSchema(schema);
            PropertyChangeEvent spce = new PropertyChangeEvent(mvl, "schema", oldSchema, schema);
            props.put(spce.getPropertyName(), spce);
            this.setupMasterTable();
            sod = (SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem();
            if (sod != null) {
                name = sod.getName();
                mvl.setName(name);
                mvl.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
                name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
                PropertyChangeEvent npce = new PropertyChangeEvent(mvl, "name", oldName, name);
                props.put(npce.getPropertyName(), npce);
            }
            DBObjectChange.firePropertiesChanged((SystemObject)mvl, props);
        } else if (name != null && !name.equals(oldName)) {
            name = ((SchemaObjectDescriptor)this.m_cmbMasterTable.getSelectedItem()).getName();
            mvl.setName(name);
            mvl.setMasterTableID((DBObjectID)this.m_tableNameAndIdHash.get(name));
            DBObjectChange.firePropertyChanged((SystemObject)mvl, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(mvl, "name", oldName, name)});
        }
    }

    @Override
    protected void initialisePanel() {
        final MaterializedViewLog mvl = (MaterializedViewLog)this.getUpdatedObject();
        final DBObjectProvider pro = this.getProvider();
        if (this.m_firstInit) {
            String templateName;
            this.m_cmbOwner.setProvider(pro);
            this.m_cmbOwner.setDBObject((DBObject)mvl.getSchema());
            this.m_cmbOwner.setFilter(new DBObjectFilter(){

                public boolean accept(DBObject dbObj) {
                    boolean doAccept = false;
                    if (pro instanceof Database) {
                        String type = mvl.getType();
                        if (pro.hasPriviledge(type, (Schema)dbObj, MViewLogHeader.this.isEditing() ? "MODIFY" : "CREATE")) {
                            doAccept = true;
                        }
                    } else {
                        doAccept = true;
                    }
                    return doAccept;
                }
            });
            this.setupMasterTable();
            this.m_cmbOwner.setEditable(false);
            this.m_cmbMasterTable.setEditable(false);
            if (this.m_cmbMasterTable.getModel().getSize() != 0) {
                try {
                    this.commitPanel();
                }
                catch (TraversalException e) {
                    // empty catch block
                }
            }
            if ((templateName = TemplateExpander.getTemplateObjectName((DBObject)mvl)) != null) {
                this.m_templateHint.setText(templateName);
                this.m_templateHint.setIcon(OracleIcons.getIcon((String)"copy.png"));
                this.m_templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_GENERAL", templateName));
            } else {
                this.m_templateHint.setVisible(false);
            }
            this.m_firstInit = false;
        } else {
            this.m_cmbOwner.setDBObject((DBObject)mvl.getSchema());
            this.setupMasterTable();
        }
        this.m_listening = true;
        if (this.isEditing()) {
            this.m_lblSchema.setEnabled(false);
            this.m_cmbOwner.setEnabled(false);
            this.m_lblMasterTable.setEnabled(false);
            this.m_cmbMasterTable.setEnabled(false);
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_cmbMasterTable;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            try {
                this.commitPanel();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            this.m_listening = true;
        }
    }

    private void setupMasterTable() {
        final MaterializedViewLog mvl = (MaterializedViewLog)this.getUpdatedObject();
        final DBObjectProvider pro = this.getProvider();
        this.m_cmbMasterTable.removeAllItems();
        this.m_cmbMasterTable.setShowIcon(true);
        this.m_tableNameAndIdHash.clear();
        if (!this.isEditing()) {
            mvl.setName(null);
            mvl.setMasterTableID(null);
            if (pro instanceof OracleDatabaseImpl) {
                final QueryWrapper wrap = new QueryWrapper((Database)pro, MaterializedViewLogBuilder.getCandidateTablesQuery(), new Object[]{mvl.getSchema()});
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                DBObjectID tableID = ((OracleDatabaseImpl)pro).createID(null, mvl.getSchema(), rs.getString(1), rs.getString(2), (Object)rs.getString(3));
                                SchemaObjectDescriptor sod = new SchemaObjectDescriptor(rs.getString(1), rs.getString(2), mvl.getSchema().getName());
                                MViewLogHeader.this.m_cmbMasterTable.addItem(sod);
                                MViewLogHeader.this.m_tableNameAndIdHash.put(rs.getString(1), tableID);
                                if (mvl.getMasterTableID() != null) continue;
                                mvl.setMasterTableID(tableID);
                            }
                        }
                        catch (SQLException ex) {
                            wrap.throwDBException(ex);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    boolean debug = false;
                }
            } else {
                int tabLoop;
                SchemaObject[] tables = null;
                String[] tabTypes = new String[]{"TABLE", "MATERIALIZED VIEW"};
                try {
                    tables = pro.listObjects(tabTypes, mvl.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                SchemaObject[] mvls = null;
                String[] mvlType = new String[]{"MATERIALIZED VIEW LOG"};
                try {
                    mvls = pro.listObjects(mvlType, mvl.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                block8: for (tabLoop = 0; tabLoop < tables.length; ++tabLoop) {
                    for (int mvlLoop = 0; mvlLoop < mvls.length; ++mvlLoop) {
                        if (!tables[tabLoop].getID().equals(((MaterializedViewLog)mvls[mvlLoop]).getMasterTableID())) continue;
                        tables[tabLoop] = null;
                        continue block8;
                    }
                }
                for (tabLoop = 0; tabLoop < tables.length; ++tabLoop) {
                    Object type;
                    Table tab;
                    if (tables[tabLoop] == null || (tab = (Table)tables[tabLoop]) == null || (type = tab.getProperty("TableType")) == Table.TableType.TRANSACTION_TEMP || type == Table.TableType.SESSION_TEMP || type == Table.TableType.EXTERNAL) continue;
                    SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), mvl.getSchema().getName());
                    this.m_cmbMasterTable.addItem(sod);
                    this.m_tableNameAndIdHash.put(tab.getName(), tab.getID());
                    if (mvl.getMasterTableID() != null) continue;
                    mvl.setMasterTableID(tab.getID());
                }
            }
            if (this.m_cmbMasterTable.getSelectedItem() != null) {
                mvl.setMasterTableID(null);
            }
        } else {
            DBObject tab = null;
            try {
                tab = mvl.getMasterTableID().resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (tab != null) {
                SchemaObjectDescriptor sod = new SchemaObjectDescriptor(tab.getName(), tab.getType(), mvl.getSchema().getName());
                this.m_cmbMasterTable.addItem(sod);
            }
        }
    }
}

