/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.panels.partition.HashPartitionPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

abstract class AbstractPartitionPanel<T extends DBObject>
extends BaseEditorPanel<T> {
    private final ChildSelectableComponentEditorPanel m_chooserPanel;
    private final HashPartitionPanel m_hashPanel;
    private final JPanel m_container;
    private static final String HASH_PANEL = "Hash";
    private static final String RANGE_AND_LIST_PANEL = "RangeAndList";

    AbstractPartitionPanel(String panelName, ChildSelectableComponentEditorPanel chooserPanel, HashPartitionPanel hashPanel) {
        super(panelName);
        this.m_chooserPanel = chooserPanel;
        this.m_hashPanel = hashPanel;
        this.m_container = new JPanel(new CardLayout());
        this.m_container.add((Component)((Object)this.m_chooserPanel), RANGE_AND_LIST_PANEL);
        this.m_container.add((Component)((Object)this.m_hashPanel), HASH_PANEL);
    }

    @Override
    public final void initialiseComponents() {
        super.initialiseComponents();
        DBUILayoutHelper lh = this.getDBUILayoutHelper();
        this.layoutComponents(lh);
        lh.layout();
    }

    protected void layoutComponents(DBUILayoutHelper lh) {
        lh.add(this.m_container, 4, 1, true, true);
        lh.nextRow();
        lh.pushUp();
    }

    @Override
    protected void initialisePanel() {
        ExtendedPartitionType type = this.getExtendedPartitionType();
        CardLayout cl = (CardLayout)this.m_container.getLayout();
        if (type.isHash()) {
            cl.show(this.m_container, HASH_PANEL);
            this.m_hashPanel.onEntry((TraversableContext)this.getDataContext());
        } else if (type.isRange() || type.isList()) {
            cl.show(this.m_container, RANGE_AND_LIST_PANEL);
            this.m_chooserPanel.onEntry((TraversableContext)this.getDataContext());
        } else {
            throw new IllegalStateException("Attempting to access subpartitions for a table that doesn't have subpartitioning");
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        ExtendedPartitionType type = this.getExtendedPartitionType();
        if (type != null) {
            CardLayout cl = (CardLayout)this.m_container.getLayout();
            if (type.isHash()) {
                cl.show(this.m_container, HASH_PANEL);
                this.m_hashPanel.onExit((TraversableContext)this.getDataContext());
            } else if (type.isRange() || type.isList()) {
                cl.show(this.m_container, RANGE_AND_LIST_PANEL);
                this.m_chooserPanel.onExit((TraversableContext)this.getDataContext());
            } else {
                throw new IllegalStateException("Attempting to access subpartitions for a table that doesn't have subpartitioning");
            }
        }
    }

    protected ExtendedPartitionType getExtendedPartitionType() {
        ExtendedPartitionType type = null;
        OracleTablePartitions otp = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
        if (otp != null) {
            type = ExtendedPartitionType.getType((DBObject)otp);
        } else {
            OracleIndexPartitions oip = (OracleIndexPartitions)this.getUpdatedObject().getProperty("OracleIndexPartitions");
            if (oip != null) {
                type = ExtendedPartitionType.getType((DBObject)oip);
            }
        }
        return type;
    }

    @Override
    protected void validateObject() throws TraversalException {
    }
}

