/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public enum ExtendedPartitionType {
    UNDEFINED(null, null),
    TABLE_RANGE(Location.TABLE, Definition.RANGE),
    TABLE_LIST(Location.TABLE, Definition.LIST),
    TABLE_HASH(Location.TABLE, Definition.HASH),
    INDEX_GLOBAL_RANGE(Location.INDEX_GLOBAL, Definition.RANGE),
    INDEX_GLOBAL_HASH(Location.INDEX_GLOBAL, Definition.HASH),
    INDEX_LOCAL_HASH(Location.INDEX_LOCAL, Definition.HASH),
    INDEX_LOCAL_COMP(Location.INDEX_LOCAL, Definition.COMPOSITE),
    INDEX_LOCAL_OTHER(Location.INDEX_LOCAL, Definition.OTHER),
    INDEX_SUBPARTITION(Location.INDEX_LOCAL, Definition.SUBPARTITION),
    INDEX_DOMAIN(Location.INDEX_LOCAL, Definition.DOMAIN);

    private final Location m_loc;
    private final Definition m_def;

    private ExtendedPartitionType(Location location, Definition definition) {
        this.m_loc = location;
        this.m_def = definition;
    }

    public boolean isRange() {
        return this.m_def == Definition.RANGE;
    }

    public boolean isList() {
        return this.m_def == Definition.LIST;
    }

    public boolean isHash() {
        return this.m_def == Definition.HASH;
    }

    public boolean isTable() {
        return this.m_loc == Location.TABLE;
    }

    public boolean isIndex() {
        return this.m_loc == Location.INDEX_GLOBAL || this.m_loc == Location.INDEX_LOCAL;
    }

    public static ExtendedPartitionType getType(DBObject object) {
        if (object instanceof IndexPartition) {
            object = object.getParent();
        }
        if (object instanceof Table) {
            object = (OracleTablePartitions)object.getProperty("OracleTablePartitions");
        }
        if (object instanceof Index) {
            object = (OracleIndexPartitions)object.getProperty("OracleIndexPartitions");
        }
        if (object instanceof OracleTablePartitions || object instanceof TablePartition) {
            OracleTablePartitions.PartitionType type = (OracleTablePartitions.PartitionType)object.getProperty("partitionType");
            if (type == OracleTablePartitions.PartitionType.RANGE) {
                return TABLE_RANGE;
            }
            if (type == OracleTablePartitions.PartitionType.LIST) {
                return TABLE_LIST;
            }
            if (type == OracleTablePartitions.PartitionType.HASH) {
                return TABLE_HASH;
            }
        } else if (object instanceof OracleIndexPartitions) {
            OracleIndexPartitions oip = (OracleIndexPartitions)object;
            OracleIndexPartitions.PartitionType type = oip.getPartitionType();
            if (type == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                return INDEX_GLOBAL_RANGE;
            }
            if (type == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
                return INDEX_GLOBAL_HASH;
            }
            if (type == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                return INDEX_LOCAL_HASH;
            }
            if (type == OracleIndexPartitions.PartitionType.LOCAL_COMP) {
                return INDEX_LOCAL_COMP;
            }
            if (type == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                return INDEX_LOCAL_OTHER;
            }
            if (type == OracleIndexPartitions.PartitionType.SUBPARTITION) {
                return INDEX_SUBPARTITION;
            }
            if (type == OracleIndexPartitions.PartitionType.DOMAIN) {
                return INDEX_DOMAIN;
            }
        }
        return UNDEFINED;
    }

    private static enum Definition {
        RANGE,
        LIST,
        HASH,
        COMPOSITE,
        DOMAIN,
        SUBPARTITION,
        OTHER;

    }

    private static enum Location {
        TABLE,
        INDEX_GLOBAL,
        INDEX_LOCAL;

    }
}

