/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionPanel;
import oracle.ideimpl.db.panels.partition.LocalIndexPartitionPanel;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

public class IndexPartitionPanel
extends ChildObjectEditorPanel<OracleIndexPartitions, Index> {
    private final GlobalIndexPartitionPanel m_globalPanel = new GlobalIndexPartitionPanel();
    private final LocalIndexPartitionPanel m_localPanel = new LocalIndexPartitionPanel();
    private TraversableContext m_context;

    public IndexPartitionPanel() {
        super("IndexPartitionPanel", null, true);
    }

    @Override
    public void initialiseChildComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwType = this.getOrCreateWrapper("partitionType");
        layout.add(cwType.getLabel(), 1, 1, false, false);
        layout.add(cwType.getComponent(), 1, 1, false, false);
        layout.add(Box.createHorizontalBox(), 1, 1, true, false);
        layout.nextRowWithGap();
        layout.add((Component)((Object)this.m_globalPanel), 3, 1, true, true);
        layout.nextRow();
        layout.add((Component)((Object)this.m_localPanel), 3, 1, true, true);
        layout.nextRow();
        layout.pushUp();
        layout.layout();
        cwType.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndexPartitionPanel.this.switchPanels();
            }
        });
    }

    private void switchPanels() {
        OracleIndexPartitions oip = (OracleIndexPartitions)this.getChildObject();
        Index index = (Index)this.getUpdatedObject();
        OracleTablePartitions otp = null;
        if (index != null) {
            otp = (OracleTablePartitions)index.getParent().getProperty("OracleTablePartitions");
        }
        OracleIndexPartitions.PartitionType type = null;
        if (oip != null) {
            type = oip.getPartitionType();
        }
        if (type == null) {
            this.m_globalPanel.setVisible(false);
            this.m_localPanel.setVisible(false);
        } else {
            switch (type) {
                case GLOBAL_RANGE: 
                case GLOBAL_HASH: {
                    this.m_localPanel.setVisible(false);
                    this.m_globalPanel.setVisible(true);
                    if (this.m_context == null) break;
                    this.m_globalPanel.onEntry(this.m_context);
                    break;
                }
                case LOCAL_COMP: 
                case LOCAL_HASH: 
                case LOCAL_OTHER: 
                case DOMAIN: {
                    this.m_globalPanel.setVisible(false);
                    if (otp == null || otp.getPartitionColumns() == null || otp.getPartitionColumns().length == 0) {
                        this.m_localPanel.setVisible(true);
                        break;
                    }
                    this.m_localPanel.setVisible(true);
                    if (this.m_context == null) break;
                    this.m_localPanel.onEntry(this.m_context);
                }
            }
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.m_context = new TraversableContext(this.getDataContext().getParent(), 0);
        this.switchPanels();
    }

    @Override
    public void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_globalPanel.isVisible()) {
            this.m_globalPanel.onExit(this.m_context);
        } else if (this.m_localPanel.isVisible()) {
            this.m_localPanel.onExit(this.m_context);
        }
    }
}

