/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.table.LobColumnPropertiesPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.DisplayNames;

public class LobDescriptorsPanel
extends ChildListEditorPanel<LOBDescriptor, Table> {
    public LobDescriptorsPanel() {
        super("LobDescriptorsPanel");
        this.getComponentFactory().setBasePath(PartitionProperty.PARTITIONS);
        this.setHelpID("f1_odbtalobdescriptors_html");
    }

    @Override
    protected ChildObjectEditorPanel<LOBDescriptor, Table> createChildPanel() {
        return new DetailPanel();
    }

    @Override
    protected Class<LOBDescriptor> getChildClass() {
        return LOBDescriptor.class;
    }

    @Override
    protected String getChildProperty() {
        return "LOBDescriptors";
    }

    @Override
    protected String getListLabel() {
        return DisplayNames.getPropertyDisplayName((String)"LOBDescriptors");
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new LOBDescriptorListRenderer();
    }

    private static final class DetailPanel
    extends ChildObjectEditorPanel<LOBDescriptor, Table> {
        DetailPanel() {
            super("LobDescriptorsPanel", PartitionProperty.LOB_DESCRIPTORS);
        }

        @Override
        protected void initialiseChildComponents() {
            super.initialiseChildComponents();
            DBUILayoutHelper lh = this.getDBUILayoutHelper();
            lh.setMargins(0);
            ComponentWrapper cw = this.getOrCreateWrapper("columns");
            lh.add(cw.getLabel(), 4, 1);
            lh.nextRow();
            lh.add(cw.getComponent(), 4, 1, true, true);
            lh.nextRow();
            LobColumnPropertiesPanel.initialiseLobComponents(this, (DBEditorConfig)this.getDataContext().find(DBEditorConfig.class), lh);
            lh.layout();
        }
    }

    private class LOBDescriptorListRenderer
    extends DBObjectRenderer {
        private LOBDescriptorListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel retval = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            LOBDescriptor lob = (LOBDescriptor)value;
            StringBuilder bob = new StringBuilder();
            if (lob.getColumns() != null) {
                boolean addComma = false;
                for (DBObjectID colID : lob.getColumns()) {
                    if (addComma) {
                        bob.append(", ");
                    }
                    bob.append(DBUtil.getDBObjectName((DBObjectID)colID));
                    addComma = true;
                }
            }
            retval.setText(bob.length() == 0 ? UIBundle.get("LOB_PARAM_NO_COLUMNS") : bob.toString());
            return retval;
        }
    }
}

